/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.OneToManyDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class OneToManyDeleteMethod
implements MethodDefinition {
    private final TableDefinition tableDefinition;
    private final boolean isModelContainerAdapter;
    private final boolean useWrapper;

    public OneToManyDeleteMethod(TableDefinition tableDefinition, boolean isModelContainerAdapter, boolean useWrapper) {
        this.tableDefinition = tableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
        this.useWrapper = useWrapper;
    }

    @Override
    public MethodSpec getMethodSpec() {
        boolean shouldWrite = false;
        for (OneToManyDefinition oneToManyDefinition : this.tableDefinition.oneToManyDefinitions) {
            if (!oneToManyDefinition.isDelete()) continue;
            shouldWrite = true;
            break;
        }
        if (shouldWrite || !this.isModelContainerAdapter && this.tableDefinition.cachingEnabled) {
            CodeBlock.Builder builder = CodeBlock.builder();
            for (OneToManyDefinition oneToManyDefinition : this.tableDefinition.oneToManyDefinitions) {
                oneToManyDefinition.writeDelete(builder, this.useWrapper);
            }
            if (!this.isModelContainerAdapter && this.tableDefinition.cachingEnabled) {
                builder.addStatement("getModelCache().removeModel(getCachingId($L))", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter)});
            }
            builder.addStatement("super.delete($L$L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), this.useWrapper ? ", " + ModelUtils.getWrapper() : ""});
            MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"delete").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)this.tableDefinition.elementClassName, ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).addCode(builder.build()).returns(TypeName.VOID);
            if (this.useWrapper) {
                builder2.addParameter((TypeName)ClassNames.DATABASE_WRAPPER, ModelUtils.getWrapper(), new Modifier[0]);
            }
            return builder2.build();
        }
        return null;
    }
}

