/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ForeignKeyReference;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;

public class PrivateColumnAccess
extends BaseColumnAccess {
    private String getterName;
    private String setterName;
    public final boolean useBooleanSetters;

    public PrivateColumnAccess(Column column, boolean useBooleanSetters) {
        if (column != null) {
            this.getterName = column.getterName();
            this.setterName = column.setterName();
        }
        this.useBooleanSetters = useBooleanSetters;
    }

    public PrivateColumnAccess(ForeignKeyReference reference) {
        this.getterName = reference.referencedGetterName();
        this.setterName = reference.referencedSetterName();
        this.useBooleanSetters = false;
    }

    public PrivateColumnAccess(boolean useBooleanSetters) {
        this.useBooleanSetters = useBooleanSetters;
    }

    @Override
    public String getColumnAccessString(TypeName fieldType, String elementName, String fullElementName, String variableNameString, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        if (!isModelContainerAdapter) {
            return String.format("%1s.%1s()", variableNameString, this.getGetterNameElement(elementName));
        }
        String method = SQLiteHelper.getModelContainerMethod(fieldType);
        if (method == null) {
            method = "get";
        }
        return variableNameString + "." + method + "Value(\"" + elementName + "\")";
    }

    @Override
    public String getShortAccessString(TypeName fieldType, String elementName, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        if (!isModelContainerAdapter) {
            return String.format("%1s()", this.getGetterNameElement(elementName));
        }
        return elementName;
    }

    @Override
    public String setColumnAccessString(TypeName fieldType, String elementName, String fullElementName, boolean isModelContainerAdapter, String variableNameString, CodeBlock formattedAccess, boolean toModel) {
        if (isModelContainerAdapter) {
            return variableNameString + ".put(\"" + elementName + "\", " + formattedAccess + ")";
        }
        String varNameFull = variableNameString;
        if (!StringUtils.isNullOrEmpty(varNameFull)) {
            varNameFull = varNameFull + ".";
        }
        return String.format("%s%1s(%1s)", varNameFull, this.getSetterNameElement(elementName), formattedAccess);
    }

    public String getGetterNameElement(String elementName) {
        if (StringUtils.isNullOrEmpty(this.getterName)) {
            if (this.useBooleanSetters && !elementName.startsWith("is")) {
                return "is" + StringUtils.capitalize(elementName);
            }
            if (!this.useBooleanSetters && !elementName.startsWith("get")) {
                return "get" + StringUtils.capitalize(elementName);
            }
            return StringUtils.lower(elementName);
        }
        return this.getterName;
    }

    public String getSetterNameElement(String elementName) {
        if (StringUtils.isNullOrEmpty(this.setterName)) {
            if (!elementName.startsWith("set")) {
                if (this.useBooleanSetters && elementName.startsWith("is")) {
                    elementName = elementName.replaceFirst("is", "");
                }
                return "set" + StringUtils.capitalize(elementName);
            }
            return StringUtils.lower(elementName);
        }
        return this.setterName;
    }
}

