/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ForeignKey;
import com.raizlabs.android.dbflow.annotation.ForeignKeyAction;
import com.raizlabs.android.dbflow.annotation.ForeignKeyReference;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.ProcessorUtils;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.DefinitionUtils;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyReferenceDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ModelContainerAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.SimpleColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.TypeConverterAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ForeignKeyColumnDefinition
extends ColumnDefinition {
    public final List<ForeignKeyReferenceDefinition> foreignKeyReferenceDefinitionList = new ArrayList<ForeignKeyReferenceDefinition>();
    public final TableDefinition tableDefinition;
    public ClassName referencedTableClassName;
    public ForeignKeyAction onDelete;
    public ForeignKeyAction onUpdate;
    public boolean isModelContainer;
    public boolean isForeignKeyContainer;
    public boolean isModel;
    public boolean needsReferences;
    public boolean nonModelColumn;
    public boolean saveForeignKeyModel;

    /*
     * WARNING - void declaration
     */
    public ForeignKeyColumnDefinition(ProcessorManager manager, TableDefinition tableDefinition, Element typeElement, boolean isPackagePrivate) {
        super(manager, typeElement, tableDefinition, isPackagePrivate);
        ForeignKeyReference[] references;
        this.tableDefinition = tableDefinition;
        ForeignKey foreignKey = typeElement.getAnnotation(ForeignKey.class);
        this.onUpdate = foreignKey.onUpdate();
        this.onDelete = foreignKey.onDelete();
        try {
            foreignKey.tableClass();
        }
        catch (MirroredTypeException mte) {
            this.referencedTableClassName = ClassName.get((TypeElement)manager.getElements().getTypeElement(mte.getTypeMirror().toString()));
        }
        TypeElement erasedElement = manager.getElements().getTypeElement(manager.getTypeUtils().erasure(typeElement.asType()).toString());
        if (this.referencedTableClassName.equals((Object)TypeName.OBJECT)) {
            if (this.elementTypeName instanceof ParameterizedTypeName) {
                List args = ((ParameterizedTypeName)this.elementTypeName).typeArguments;
                if (args.size() > 0) {
                    this.referencedTableClassName = ClassName.bestGuess((String)((TypeName)args.get(0)).toString());
                    this.isModelContainer = true;
                }
            } else {
                if (ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.MODEL_CONTAINER.toString(), erasedElement)) {
                    void var8_12;
                    Types types = manager.getTypeUtils();
                    Object var8_11 = null;
                    DeclaredType modelContainer = manager.getTypeUtils().getDeclaredType(manager.getElements().getTypeElement(ClassNames.MODEL_CONTAINER.toString()), types.getWildcardType(manager.getElements().getTypeElement(ClassNames.MODEL.toString()).asType(), null), types.getWildcardType(null, null));
                    for (TypeMirror typeMirror : types.directSupertypes(erasedElement.asType())) {
                        if (!types.isAssignable(typeMirror, modelContainer)) continue;
                        DeclaredType declaredType = (DeclaredType)typeMirror;
                    }
                    if (var8_12 != null) {
                        List<? extends TypeMirror> typeArgs = var8_12.getTypeArguments();
                        this.referencedTableClassName = ClassName.get((TypeElement)manager.getElements().getTypeElement(typeArgs.get(0).toString()));
                        this.isModelContainer = true;
                    }
                }
                if (this.referencedTableClassName == null || this.referencedTableClassName.equals((Object)ClassName.OBJECT)) {
                    this.referencedTableClassName = ClassName.bestGuess((String)this.elementTypeName.toString());
                }
            }
        }
        if (this.referencedTableClassName == null) {
            manager.logError("Referenced was null for %1s within %1s", typeElement, this.elementTypeName);
        }
        this.isModel = ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.MODEL.toString(), erasedElement);
        this.isModelContainer = this.isModelContainer || ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.MODEL_CONTAINER.toString(), erasedElement);
        this.isForeignKeyContainer = this.isModelContainer && ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.FOREIGN_KEY_CONTAINER.toString(), erasedElement);
        this.nonModelColumn = !this.isModel && !this.isModelContainer;
        this.saveForeignKeyModel = foreignKey.saveForeignKeyModel();
        if (this.columnAccess instanceof TypeConverterAccess) {
            if (typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                boolean useIs = this.elementTypeName.box().equals((Object)TypeName.BOOLEAN.box()) && tableDefinition.useIsForPrivateBooleans;
                this.columnAccess = new PrivateColumnAccess(typeElement.getAnnotation(Column.class), useIs);
            } else {
                this.columnAccess = new SimpleColumnAccess();
            }
        }
        if ((references = foreignKey.references()).length == 0) {
            this.needsReferences = true;
        } else {
            for (ForeignKeyReference foreignKeyReference : references) {
                ForeignKeyReferenceDefinition referenceDefinition = new ForeignKeyReferenceDefinition(manager, this.elementName, foreignKeyReference, this.columnAccess, this);
                this.foreignKeyReferenceDefinitionList.add(referenceDefinition);
            }
            if (this.nonModelColumn && this.foreignKeyReferenceDefinitionList.size() == 1) {
                ForeignKeyReferenceDefinition foreignKeyReferenceDefinition = this.foreignKeyReferenceDefinitionList.get(0);
                this.columnName = foreignKeyReferenceDefinition.columnName;
            }
        }
    }

    @Override
    public void addPropertyDefinition(TypeSpec.Builder typeBuilder, TypeName tableClassName) {
        this.checkNeedsReferences();
        for (ForeignKeyReferenceDefinition reference : this.foreignKeyReferenceDefinitionList) {
            Object propParam = reference.columnClassName.isPrimitive() && !reference.columnClassName.equals((Object)TypeName.BOOLEAN) ? ClassName.get((String)"com.raizlabs.android.dbflow.sql.language.property", (String)(StringUtils.capitalize(reference.columnClassName.toString()) + "Property"), (String[])new String[0]) : ParameterizedTypeName.get((ClassName)ClassNames.PROPERTY, (TypeName[])new TypeName[]{reference.columnClassName.box()});
            typeBuilder.addField(FieldSpec.builder((TypeName)propParam, (String)reference.columnName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($T.class, $S)", new Object[]{propParam, tableClassName, reference.columnName}).build());
        }
    }

    @Override
    public void addPropertyCase(MethodSpec.Builder methodBuilder) {
        this.checkNeedsReferences();
        for (ForeignKeyReferenceDefinition reference : this.foreignKeyReferenceDefinitionList) {
            methodBuilder.beginControlFlow("case $S: ", new Object[]{QueryBuilder.quoteIfNeeded((String)reference.columnName)});
            methodBuilder.addStatement("return $L", new Object[]{reference.columnName});
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void addColumnName(CodeBlock.Builder codeBuilder) {
        this.checkNeedsReferences();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            ForeignKeyReferenceDefinition reference = this.foreignKeyReferenceDefinitionList.get(i);
            if (i > 0) {
                codeBuilder.add(",", new Object[0]);
            }
            codeBuilder.add(reference.columnName, new Object[0]);
        }
    }

    @Override
    public CodeBlock getInsertStatementColumnName() {
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            if (i > 0) {
                builder.add(",", new Object[0]);
            }
            ForeignKeyReferenceDefinition referenceDefinition = this.foreignKeyReferenceDefinitionList.get(i);
            builder.add("$L", new Object[]{QueryBuilder.quote((String)referenceDefinition.columnName)});
        }
        return builder.build();
    }

    @Override
    public CodeBlock getInsertStatementValuesString() {
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            if (i > 0) {
                builder.add(",", new Object[0]);
            }
            builder.add("?", new Object[0]);
        }
        return builder.build();
    }

    @Override
    public CodeBlock getCreationName() {
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            if (i > 0) {
                builder.add(" ,", new Object[0]);
            }
            ForeignKeyReferenceDefinition referenceDefinition = this.foreignKeyReferenceDefinitionList.get(i);
            builder.add(referenceDefinition.getCreationStatement());
        }
        return builder.build();
    }

    @Override
    public String getPrimaryKeyName() {
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            if (i > 0) {
                builder.add(" ,", new Object[0]);
            }
            ForeignKeyReferenceDefinition referenceDefinition = this.foreignKeyReferenceDefinitionList.get(i);
            builder.add(referenceDefinition.getPrimaryKeyName(), new Object[0]);
        }
        return builder.build().toString();
    }

    @Override
    public CodeBlock getContentValuesStatement(boolean isModelContainerAdapter) {
        if (this.nonModelColumn) {
            return super.getContentValuesStatement(isModelContainerAdapter);
        }
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        String statement = this.columnAccess.getColumnAccessString(this.elementTypeName, this.elementName, this.elementName, ModelUtils.getVariable(isModelContainerAdapter), isModelContainerAdapter, false);
        String finalAccessStatement = this.getFinalAccessStatement(builder, isModelContainerAdapter, statement);
        builder.beginControlFlow("if ($L != null)", new Object[]{finalAccessStatement});
        if (this.saveForeignKeyModel) {
            builder.addStatement("$L.save()", new Object[]{finalAccessStatement});
        }
        CodeBlock.Builder elseBuilder = CodeBlock.builder();
        for (ForeignKeyReferenceDefinition referenceDefinition : this.foreignKeyReferenceDefinitionList) {
            builder.add(referenceDefinition.getContentValuesStatement(isModelContainerAdapter));
            elseBuilder.addStatement("$L.putNull($S)", new Object[]{"values", QueryBuilder.quote((String)referenceDefinition.columnName)});
        }
        builder.nextControlFlow("else", new Object[0]).add(elseBuilder.build()).endControlFlow();
        return builder.build();
    }

    @Override
    public CodeBlock getSQLiteStatementMethod(AtomicInteger index, boolean isModelContainerAdapter) {
        if (this.nonModelColumn) {
            return super.getSQLiteStatementMethod(index, isModelContainerAdapter);
        }
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder();
        String statement = this.columnAccess.getColumnAccessString(this.elementTypeName, this.elementName, this.elementName, ModelUtils.getVariable(isModelContainerAdapter), isModelContainerAdapter, true);
        String finalAccessStatement = this.getFinalAccessStatement(builder, isModelContainerAdapter, statement);
        builder.beginControlFlow("if ($L != null)", new Object[]{finalAccessStatement});
        if (this.saveForeignKeyModel) {
            builder.addStatement("$L.save()", new Object[]{finalAccessStatement});
        }
        CodeBlock.Builder elseBuilder = CodeBlock.builder();
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            if (i > 0) {
                index.incrementAndGet();
            }
            ForeignKeyReferenceDefinition referenceDefinition = this.foreignKeyReferenceDefinitionList.get(i);
            builder.add(referenceDefinition.getSQLiteStatementMethod(index, isModelContainerAdapter));
            elseBuilder.addStatement("$L.bindNull($L)", new Object[]{"statement", index.intValue() + " + " + "start"});
        }
        builder.nextControlFlow("else", new Object[0]).add(elseBuilder.build()).endControlFlow();
        return builder.build();
    }

    @Override
    public CodeBlock getLoadFromCursorMethod(boolean isModelContainerAdapter, boolean putNullForContainerAdapter, boolean endNonPrimitiveIf, AtomicInteger index) {
        if (this.nonModelColumn) {
            return super.getLoadFromCursorMethod(isModelContainerAdapter, putNullForContainerAdapter, endNonPrimitiveIf, index);
        }
        this.checkNeedsReferences();
        CodeBlock.Builder builder = CodeBlock.builder().add("//// Only load model if references match, for efficiency\n", new Object[0]);
        CodeBlock.Builder ifNullBuilder = CodeBlock.builder().add("if (", new Object[0]);
        CodeBlock.Builder selectBuilder = CodeBlock.builder();
        String foreignKeyContainerRefName = "ref" + this.columnName;
        for (int i = 0; i < this.foreignKeyReferenceDefinitionList.size(); ++i) {
            String indexName;
            if (i > 0) {
                index.incrementAndGet();
            }
            ForeignKeyReferenceDefinition referenceDefinition = this.foreignKeyReferenceDefinitionList.get(i);
            if (!this.tableDefinition.orderedCursorLookUp || index.intValue() == -1) {
                indexName = "index" + referenceDefinition.columnName;
                builder.addStatement("int $L = $L.getColumnIndex($S)", new Object[]{indexName, "cursor", referenceDefinition.columnName});
            } else {
                indexName = index.intValue() + "";
            }
            if (i > 0) {
                ifNullBuilder.add(" && ", new Object[0]);
            }
            if (!this.tableDefinition.orderedCursorLookUp || index.intValue() == -1) {
                ifNullBuilder.add("$L != -1 && !$L.isNull($L)", new Object[]{indexName, "cursor", indexName});
            } else {
                ifNullBuilder.add("!$L.isNull($L)", new Object[]{"cursor", indexName});
            }
            CodeBlock loadFromCursorBlock = CodeBlock.builder().add("$L.$L($L)", new Object[]{"cursor", DefinitionUtils.getLoadFromCursorMethodString(referenceDefinition.columnClassName, referenceDefinition.columnAccess), indexName}).build();
            ClassName generatedTableRef = ClassName.get((String)this.referencedTableClassName.packageName(), (String)(this.referencedTableClassName.simpleName() + this.tableDefinition.databaseDefinition.fieldRefSeparator + "Table"), (String[])new String[0]);
            if (!this.isForeignKeyContainer) {
                selectBuilder.add("\n.and($L.$L.eq($L))", new Object[]{generatedTableRef, referenceDefinition.foreignColumnName, loadFromCursorBlock});
                continue;
            }
            selectBuilder.add("\n$L.put($S, $L);", new Object[]{foreignKeyContainerRefName, referenceDefinition.foreignColumnName, loadFromCursorBlock});
        }
        ifNullBuilder.add(")", new Object[0]);
        builder.beginControlFlow(ifNullBuilder.build().toString(), new Object[0]);
        CodeBlock.Builder initializer = CodeBlock.builder();
        if (this.isForeignKeyContainer) {
            builder.addStatement("$T $L = new $T($T.class)", new Object[]{this.elementTypeName, foreignKeyContainerRefName, this.elementTypeName, this.referencedTableClassName});
            builder.add(selectBuilder.build()).add("\n", new Object[0]);
            initializer.add(foreignKeyContainerRefName, new Object[0]);
        } else {
            initializer.add("new $T().from($T.class).where()", new Object[]{ClassNames.SELECT, this.referencedTableClassName}).add(selectBuilder.build());
            if (!isModelContainerAdapter && !this.isModelContainer) {
                initializer.add(".querySingle()", new Object[0]);
            } else if (isModelContainerAdapter) {
                initializer.add(".queryModelContainer($L.getInstance($L.newDataInstance(), $T.class)).getData()", new Object[]{ModelUtils.getVariable(true), ModelUtils.getVariable(true), this.referencedTableClassName});
            } else {
                initializer.add(".queryModelContainer(new $T($T.class))", new Object[]{this.elementTypeName, this.referencedTableClassName});
            }
        }
        builder.addStatement(this.columnAccess.setColumnAccessString(this.elementTypeName, this.elementName, this.elementName, isModelContainerAdapter, ModelUtils.getVariable(isModelContainerAdapter), initializer.build(), false), new Object[0]);
        boolean putDefaultValue = putNullForContainerAdapter;
        if (this.putContainerDefaultValue != putDefaultValue && isModelContainerAdapter) {
            putDefaultValue = this.putContainerDefaultValue;
        }
        if (putDefaultValue && this.tableDefinition.assignDefaultValuesFromCursor) {
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$L.putDefault($S)", new Object[]{ModelUtils.getVariable(true), this.columnName});
        }
        if (endNonPrimitiveIf || !this.tableDefinition.assignDefaultValuesFromCursor) {
            builder.endControlFlow();
        }
        return builder.build();
    }

    @Override
    public CodeBlock getToModelMethod() {
        this.checkNeedsReferences();
        if (this.nonModelColumn) {
            return super.getToModelMethod();
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        String statement = this.columnAccess.getColumnAccessString(this.elementTypeName, this.elementName, this.elementName, ModelUtils.getVariable(true), true, true);
        String finalAccessStatement = this.getFinalAccessStatement(builder, true, statement);
        builder.beginControlFlow("if ($L != null)", new Object[]{finalAccessStatement});
        if (!this.isModelContainer) {
            CodeBlock.Builder modelContainerRetrieval = CodeBlock.builder();
            modelContainerRetrieval.add("$L.getContainerAdapter($T.class).toModel($L)", new Object[]{ClassNames.FLOW_MANAGER, this.referencedTableClassName, finalAccessStatement});
            builder.addStatement(this.columnAccess.setColumnAccessString(this.elementTypeName, this.elementName, this.elementName, false, ModelUtils.getVariable(false), modelContainerRetrieval.build(), true), new Object[0]);
        } else {
            builder.addStatement(this.columnAccess.setColumnAccessString(this.elementTypeName, this.elementName, this.elementName, false, ModelUtils.getVariable(false), CodeBlock.builder().add("new $T($L)", new Object[]{this.elementTypeName, finalAccessStatement}).build(), true), new Object[0]);
        }
        builder.endControlFlow();
        return builder.build();
    }

    @Override
    public CodeBlock getForeignKeyContainerMethod(ClassName tableClassName) {
        if (this.nonModelColumn) {
            return super.getForeignKeyContainerMethod(tableClassName);
        }
        String access = this.columnAccess.getColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, ModelUtils.getVariable(false), false, false);
        CodeBlock.Builder builder = CodeBlock.builder();
        CodeBlock.Builder elseBuilder = CodeBlock.builder();
        builder.beginControlFlow("if ($L != null)", new Object[]{access});
        for (ForeignKeyReferenceDefinition referenceDefinition : this.foreignKeyReferenceDefinitionList) {
            builder.add(referenceDefinition.getForeignKeyContainerMethod(tableClassName));
            elseBuilder.addStatement("$L.putDefault($T.$L)", new Object[]{ModelUtils.getVariable(true), tableClassName, referenceDefinition.columnName});
        }
        builder.nextControlFlow("else", new Object[0]);
        builder.add(elseBuilder.build());
        builder.endControlFlow();
        return builder.build();
    }

    @Override
    public void appendPropertyComparisonAccessStatement(boolean isModelContainerAdapter, CodeBlock.Builder codeBuilder) {
        if (this.nonModelColumn || this.columnAccess instanceof TypeConverterAccess) {
            super.appendPropertyComparisonAccessStatement(isModelContainerAdapter, codeBuilder);
        } else {
            String origStatement = this.getColumnAccessString(isModelContainerAdapter, false);
            if (this.isPrimaryKey) {
                TableDefinition referenced = this.manager.getTableDefinition(this.tableDefinition.databaseDefinition.elementTypeName, (TypeName)this.referencedTableClassName);
                String statement = "";
                String variableName = "container" + this.elementName;
                TypeName typeName = this.elementTypeName;
                if (isModelContainerAdapter) {
                    typeName = ParameterizedTypeName.get((ClassName)ClassNames.MODEL_CONTAINER, (TypeName[])new TypeName[]{this.elementTypeName, WildcardTypeName.subtypeOf(Object.class)});
                }
                codeBuilder.addStatement("\n$T $L = ($T) $L", new Object[]{typeName, variableName, typeName, origStatement});
                codeBuilder.beginControlFlow("if ($L != null)", new Object[]{variableName});
                CodeBlock.Builder elseBuilder = CodeBlock.builder();
                for (ForeignKeyReferenceDefinition referenceDefinition : this.getForeignKeyReferenceDefinitionList()) {
                    if (this.isModelContainer || isModelContainerAdapter) {
                        String method = SQLiteHelper.getModelContainerMethod(referenceDefinition.columnClassName);
                        if (method == null) {
                            method = "get";
                        }
                        statement = String.format("%1s.%1sValue(%1s.%1s.getContainerKey())", variableName, method, referenced.outputClassName, referenceDefinition.foreignColumnName);
                    } else {
                        statement = this.isModel ? referenceDefinition.getPrimaryReferenceString(isModelContainerAdapter) : origStatement;
                    }
                    codeBuilder.addStatement("clause.and($T.$L.eq($L))", new Object[]{this.tableDefinition.getPropertyClassName(), referenceDefinition.columnName, statement});
                    elseBuilder.addStatement("clause.and($T.$L.eq(($T) $L))", new Object[]{this.tableDefinition.getPropertyClassName(), referenceDefinition.columnName, referenceDefinition.columnClassName, DefinitionUtils.getDefaultValueString(referenceDefinition.columnClassName)});
                }
                codeBuilder.nextControlFlow("else", new Object[0]);
                codeBuilder.add(elseBuilder.build());
                codeBuilder.endControlFlow();
            }
        }
    }

    String getFinalAccessStatement(CodeBlock.Builder codeBuilder, boolean isModelContainerAdapter, String statement) {
        String finalAccessStatement = statement;
        if (this.columnAccess instanceof TypeConverterAccess || this.columnAccess instanceof ModelContainerAccess || isModelContainerAdapter) {
            TypeName typeName;
            finalAccessStatement = this.getRefName();
            if (this.columnAccess instanceof TypeConverterAccess) {
                typeName = ((TypeConverterAccess)this.columnAccess).typeConverterDefinition.getDbTypeName();
            } else if (this.columnAccess instanceof ModelContainerAccess) {
                typeName = ModelUtils.getModelContainerType(this.manager, (TypeName)this.referencedTableClassName);
            } else if (this.isModelContainer || this.isModel) {
                typeName = ModelUtils.getModelContainerType(this.manager, (TypeName)this.referencedTableClassName);
                statement = ModelUtils.getVariable(isModelContainerAdapter) + ".getInstance(" + statement + ", " + this.referencedTableClassName + ".class)";
            } else {
                typeName = this.referencedTableClassName;
            }
            codeBuilder.addStatement("$T $L = $L", new Object[]{typeName, finalAccessStatement, statement});
        }
        return finalAccessStatement;
    }

    String getForeignKeyReferenceAccess(boolean isModelContainerAdapter, String statement) {
        if (this.columnAccess instanceof TypeConverterAccess || this.columnAccess instanceof ModelContainerAccess || isModelContainerAdapter) {
            return this.getRefName();
        }
        return statement;
    }

    public String getRefName() {
        return "ref" + this.elementName;
    }

    public List<ForeignKeyReferenceDefinition> getForeignKeyReferenceDefinitionList() {
        this.checkNeedsReferences();
        return this.foreignKeyReferenceDefinitionList;
    }

    private void checkNeedsReferences() {
        TableDefinition referencedTableDefinition = this.manager.getTableDefinition(this.tableDefinition.databaseTypeName, (TypeName)this.referencedTableClassName);
        if (referencedTableDefinition == null) {
            this.manager.logError(ForeignKeyColumnDefinition.class, "Could not find the referenced table definition %1s from %1s. Ensure it exists in the samedatabase %1s", this.referencedTableClassName, this.tableDefinition.tableName, this.tableDefinition.databaseTypeName);
        } else {
            if (this.needsReferences) {
                List<ColumnDefinition> primaryColumns = referencedTableDefinition.getPrimaryColumnDefinitions();
                for (ColumnDefinition primaryColumn : primaryColumns) {
                    ForeignKeyReferenceDefinition foreignKeyReferenceDefinition = new ForeignKeyReferenceDefinition(this.manager, this.elementName, primaryColumn, this.columnAccess, this, primaryColumns.size());
                    this.foreignKeyReferenceDefinitionList.add(foreignKeyReferenceDefinition);
                }
                if (this.nonModelColumn) {
                    this.columnName = this.foreignKeyReferenceDefinitionList.get((int)0).columnName;
                }
                this.needsReferences = false;
            }
            if (this.nonModelColumn && this.foreignKeyReferenceDefinitionList.size() == 1) {
                ForeignKeyReferenceDefinition foreignKeyReferenceDefinition = this.foreignKeyReferenceDefinitionList.get(0);
                this.columnName = foreignKeyReferenceDefinition.columnName;
            }
        }
    }
}

