/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.annotation.ContainerKey;
import com.raizlabs.android.dbflow.annotation.ForeignKey;
import com.raizlabs.android.dbflow.annotation.IndexGroup;
import com.raizlabs.android.dbflow.annotation.InheritedColumn;
import com.raizlabs.android.dbflow.annotation.InheritedPrimaryKey;
import com.raizlabs.android.dbflow.annotation.ModelCacheField;
import com.raizlabs.android.dbflow.annotation.ModelContainer;
import com.raizlabs.android.dbflow.annotation.MultiCacheField;
import com.raizlabs.android.dbflow.annotation.OneToMany;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Table;
import com.raizlabs.android.dbflow.annotation.UniqueGroup;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.ProcessorUtils;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.IndexGroupsDefinition;
import com.raizlabs.android.dbflow.processor.definition.InternalAdapterHelper;
import com.raizlabs.android.dbflow.processor.definition.ModelContainerDefinition;
import com.raizlabs.android.dbflow.processor.definition.OneToManyDefinition;
import com.raizlabs.android.dbflow.processor.definition.UniqueGroupsDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ContainerKeyDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.BindToContentValuesMethod;
import com.raizlabs.android.dbflow.processor.definition.method.BindToStatementMethod;
import com.raizlabs.android.dbflow.processor.definition.method.CreationQueryMethod;
import com.raizlabs.android.dbflow.processor.definition.method.CustomTypeConverterPropertyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.ExistenceMethod;
import com.raizlabs.android.dbflow.processor.definition.method.InsertStatementQueryMethod;
import com.raizlabs.android.dbflow.processor.definition.method.LoadFromCursorMethod;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.OneToManyDeleteMethod;
import com.raizlabs.android.dbflow.processor.definition.method.OneToManySaveMethod;
import com.raizlabs.android.dbflow.processor.definition.method.PrimaryConditionMethod;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.processor.validator.ColumnValidator;
import com.raizlabs.android.dbflow.processor.validator.OneToManyValidator;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class TableDefinition
extends BaseTableDefinition {
    public static final String DBFLOW_TABLE_TAG = "Table";
    public static final String DBFLOW_TABLE_ADAPTER = "Adapter";
    public String tableName;
    public String adapterName;
    public TypeName databaseTypeName;
    public String insertConflictActionName;
    public String updateConflictActionName;
    public String primaryKeyConflictActionName;
    public List<ColumnDefinition> primaryColumnDefinitions;
    public List<ForeignKeyColumnDefinition> foreignKeyDefinitions;
    public List<UniqueGroupsDefinition> uniqueGroupsDefinitions;
    public List<IndexGroupsDefinition> indexGroupsDefinitions;
    public ColumnDefinition autoIncrementDefinition;
    public boolean hasAutoIncrement = false;
    public boolean hasRowID = false;
    public boolean implementsContentValuesListener = false;
    public boolean implementsSqlStatementListener = false;
    public boolean implementsLoadFromCursorListener = false;
    private final MethodDefinition[] methods;
    public boolean cachingEnabled = false;
    public int cacheSize;
    public String customCacheFieldName;
    public String customMultiCacheFieldName;
    public boolean allFields = false;
    public boolean useIsForPrivateBooleans;
    public final Map<String, ColumnDefinition> mColumnMap = Maps.newHashMap();
    public Map<Integer, List<ColumnDefinition>> columnUniqueMap = Maps.newHashMap();
    public List<OneToManyDefinition> oneToManyDefinitions = new ArrayList<OneToManyDefinition>();
    public List<ContainerKeyDefinition> containerKeyDefinitions = new ArrayList<ContainerKeyDefinition>();
    public Map<String, InheritedColumn> inheritedColumnMap = new HashMap<String, InheritedColumn>();
    public List<String> inheritedFieldNameList = new ArrayList<String>();
    public Map<String, InheritedPrimaryKey> inheritedPrimaryKeyMap = new HashMap<String, InheritedPrimaryKey>();
    public ModelContainerDefinition modelContainerDefinition;

    public TableDefinition(ProcessorManager manager, TypeElement element) {
        super((Element)element, manager);
        this.primaryColumnDefinitions = new ArrayList<ColumnDefinition>();
        this.foreignKeyDefinitions = new ArrayList<ForeignKeyColumnDefinition>();
        this.uniqueGroupsDefinitions = new ArrayList<UniqueGroupsDefinition>();
        this.indexGroupsDefinitions = new ArrayList<IndexGroupsDefinition>();
        Table table = element.getAnnotation(Table.class);
        if (table != null) {
            InheritedPrimaryKey[] inheritedPrimaryKeys;
            InheritedColumn[] inheritedColumns;
            this.tableName = table.name();
            if (this.tableName == null || this.tableName.isEmpty()) {
                this.tableName = element.getSimpleName().toString();
            }
            try {
                table.database();
            }
            catch (MirroredTypeException mte) {
                this.databaseTypeName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
            this.cachingEnabled = table.cachingEnabled();
            this.cacheSize = table.cacheSize();
            this.orderedCursorLookUp = table.orderedCursorLookUp();
            this.assignDefaultValuesFromCursor = table.assignDefaultValuesFromCursor();
            this.allFields = table.allFields();
            this.useIsForPrivateBooleans = table.useBooleanGetterSetters();
            manager.addModelToDatabase((TypeName)this.elementClassName, this.databaseTypeName);
            for (InheritedColumn inheritedColumn : inheritedColumns = table.inheritedColumns()) {
                if (this.inheritedFieldNameList.contains(inheritedColumn.fieldName())) {
                    manager.logError("A duplicate inherited column with name %1s was found for %1s", inheritedColumn.fieldName(), this.tableName);
                }
                this.inheritedFieldNameList.add(inheritedColumn.fieldName());
                this.inheritedColumnMap.put(inheritedColumn.fieldName(), inheritedColumn);
            }
            for (InheritedPrimaryKey inheritedColumn : inheritedPrimaryKeys = table.inheritedPrimaryKeys()) {
                if (this.inheritedFieldNameList.contains(inheritedColumn.fieldName())) {
                    manager.logError("A duplicate inherited column with name %1s was found for %1s", inheritedColumn.fieldName(), this.tableName);
                }
                this.inheritedFieldNameList.add(inheritedColumn.fieldName());
                this.inheritedPrimaryKeyMap.put(inheritedColumn.fieldName(), inheritedColumn);
            }
            this.implementsLoadFromCursorListener = ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.LOAD_FROM_CURSOR_LISTENER.toString(), element);
            this.implementsContentValuesListener = ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.CONTENT_VALUES_LISTENER.toString(), element);
            this.implementsSqlStatementListener = ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.SQLITE_STATEMENT_LISTENER.toString(), element);
        }
        if (element.getAnnotation(ModelContainer.class) != null) {
            this.modelContainerDefinition = new ModelContainerDefinition(element, manager);
        }
        this.methods = new MethodDefinition[]{new BindToContentValuesMethod(this, true, false, this.implementsContentValuesListener), new BindToContentValuesMethod(this, false, false, this.implementsContentValuesListener), new BindToStatementMethod(this, true, false), new BindToStatementMethod(this, false, false), new InsertStatementQueryMethod(this, true), new InsertStatementQueryMethod(this, false), new CreationQueryMethod(this), new LoadFromCursorMethod(this, false, this.implementsLoadFromCursorListener, false), new ExistenceMethod(this, false), new PrimaryConditionMethod(this, false), new OneToManyDeleteMethod(this, false, false), new OneToManyDeleteMethod(this, false, true), new OneToManySaveMethod(this, false, "save", false), new OneToManySaveMethod(this, false, "insert", false), new OneToManySaveMethod(this, false, "update", false), new OneToManySaveMethod(this, false, "save", true), new OneToManySaveMethod(this, false, "insert", true), new OneToManySaveMethod(this, false, "update", true)};
    }

    @Override
    public void prepareForWrite() {
        this.columnDefinitions = new ArrayList();
        this.mColumnMap.clear();
        this.classElementLookUpMap.clear();
        this.autoIncrementDefinition = null;
        this.primaryColumnDefinitions.clear();
        this.uniqueGroupsDefinitions.clear();
        this.indexGroupsDefinitions.clear();
        this.foreignKeyDefinitions.clear();
        this.columnUniqueMap.clear();
        this.containerKeyDefinitions.clear();
        this.oneToManyDefinitions.clear();
        this.customCacheFieldName = null;
        this.customMultiCacheFieldName = null;
        Table table = this.element.getAnnotation(Table.class);
        if (table != null) {
            ConflictAction updateConflict;
            this.databaseDefinition = this.manager.getDatabaseHolderDefinition(this.databaseTypeName).getDatabaseDefinition();
            if (this.databaseDefinition == null) {
                this.manager.logError("DatabaseDefinition was null for : " + this.tableName + " for db type: " + this.databaseTypeName, new Object[0]);
            }
            this.setOutputClassName(this.databaseDefinition.classSeparator + DBFLOW_TABLE_TAG);
            this.adapterName = this.getModelClassName() + this.databaseDefinition.classSeparator + DBFLOW_TABLE_ADAPTER;
            ConflictAction insertConflict = table.insertConflict();
            if (insertConflict.equals((Object)ConflictAction.NONE) && !this.databaseDefinition.insertConflict.equals((Object)ConflictAction.NONE)) {
                insertConflict = this.databaseDefinition.insertConflict;
            }
            if ((updateConflict = table.updateConflict()).equals((Object)ConflictAction.NONE) && !this.databaseDefinition.updateConflict.equals((Object)ConflictAction.NONE)) {
                updateConflict = this.databaseDefinition.updateConflict;
            }
            ConflictAction primaryKeyConflict = table.primaryKeyConflict();
            this.insertConflictActionName = insertConflict.equals((Object)ConflictAction.NONE) ? "" : insertConflict.name();
            this.updateConflictActionName = updateConflict.equals((Object)ConflictAction.NONE) ? "" : updateConflict.name();
            this.primaryKeyConflictActionName = primaryKeyConflict.equals((Object)ConflictAction.NONE) ? "" : primaryKeyConflict.name();
            this.createColumnDefinitions(this.typeElement);
            UniqueGroup[] groups = table.uniqueColumnGroups();
            HashSet<Integer> uniqueNumbersSet = new HashSet<Integer>();
            for (UniqueGroup uniqueGroup : groups) {
                if (uniqueNumbersSet.contains(uniqueGroup.groupNumber())) {
                    this.manager.logError("A duplicate unique group with number %1s was found for %1s", uniqueGroup.groupNumber(), this.tableName);
                }
                UniqueGroupsDefinition definition = new UniqueGroupsDefinition(this.manager, uniqueGroup);
                for (ColumnDefinition columnDefinition : this.getColumnDefinitions()) {
                    if (!columnDefinition.uniqueGroups.contains(definition.number)) continue;
                    definition.addColumnDefinition(columnDefinition);
                }
                this.uniqueGroupsDefinitions.add(definition);
                uniqueNumbersSet.add(uniqueGroup.groupNumber());
            }
            IndexGroup[] indexGroups = table.indexGroups();
            uniqueNumbersSet = new HashSet();
            for (IndexGroup indexGroup : indexGroups) {
                if (uniqueNumbersSet.contains(indexGroup.number())) {
                    this.manager.logError(TableDefinition.class, "A duplicate unique index number %1s was found for %1s", indexGroup.number(), this.elementName);
                }
                IndexGroupsDefinition definition = new IndexGroupsDefinition(this.manager, this, indexGroup);
                for (ColumnDefinition columnDefinition : this.getColumnDefinitions()) {
                    if (!columnDefinition.indexGroups.contains(definition.indexNumber)) continue;
                    definition.columnDefinitionList.add(columnDefinition);
                }
                this.indexGroupsDefinitions.add(definition);
                uniqueNumbersSet.add(indexGroup.number());
            }
        }
        if (this.modelContainerDefinition != null) {
            this.modelContainerDefinition.prepareForWrite();
        }
    }

    @Override
    public boolean hasAutoIncrement() {
        return this.hasAutoIncrement;
    }

    @Override
    public boolean hasRowID() {
        return this.hasRowID;
    }

    @Override
    public ColumnDefinition getAutoIncrementColumn() {
        return this.autoIncrementDefinition;
    }

    @Override
    protected void createColumnDefinitions(TypeElement typeElement) {
        List<? extends Element> elements = ElementUtility.getAllElements(typeElement, this.manager);
        for (Element element : elements) {
            this.classElementLookUpMap.put(element.getSimpleName().toString(), element);
        }
        ColumnValidator columnValidator = new ColumnValidator();
        OneToManyValidator oneToManyValidator = new OneToManyValidator();
        AtomicInteger integer = new AtomicInteger(0);
        for (Element element : elements) {
            boolean isAllFields = ElementUtility.isValidAllFields(this.allFields, element);
            boolean isPackagePrivate = ElementUtility.isPackagePrivate(element);
            boolean isPackagePrivateNotInSamePackage = isPackagePrivate && !ElementUtility.isInSamePackage(this.manager, element, this.element);
            boolean isForeign = element.getAnnotation(ForeignKey.class) != null;
            boolean isPrimary = element.getAnnotation(PrimaryKey.class) != null;
            boolean isInherited = this.inheritedColumnMap.containsKey(element.getSimpleName().toString());
            boolean isInheritedPrimaryKey = this.inheritedPrimaryKeyMap.containsKey(element.getSimpleName().toString());
            if (element.getAnnotation(Column.class) != null || isForeign || isPrimary || isAllFields || isInherited || isInheritedPrimaryKey) {
                ColumnDefinition columnDefinition;
                InheritedPrimaryKey inherited;
                if (isInheritedPrimaryKey) {
                    inherited = this.inheritedPrimaryKeyMap.get(element.getSimpleName().toString());
                    columnDefinition = new ColumnDefinition(this.manager, element, this, isPackagePrivateNotInSamePackage, inherited.column(), inherited.primaryKey());
                } else if (isInherited) {
                    inherited = this.inheritedColumnMap.get(element.getSimpleName().toString());
                    columnDefinition = new ColumnDefinition(this.manager, element, this, isPackagePrivateNotInSamePackage, inherited.column(), null);
                } else {
                    columnDefinition = isForeign ? new ForeignKeyColumnDefinition(this.manager, this, element, isPackagePrivateNotInSamePackage) : new ColumnDefinition(this.manager, element, this, isPackagePrivateNotInSamePackage);
                }
                if (!columnValidator.validate(this.manager, columnDefinition)) continue;
                this.columnDefinitions.add(columnDefinition);
                this.mColumnMap.put(columnDefinition.columnName, columnDefinition);
                if (columnDefinition.isPrimaryKey) {
                    this.primaryColumnDefinitions.add(columnDefinition);
                } else if (columnDefinition.isPrimaryKeyAutoIncrement()) {
                    this.autoIncrementDefinition = columnDefinition;
                    this.hasAutoIncrement = true;
                } else if (columnDefinition.isRowId) {
                    this.autoIncrementDefinition = columnDefinition;
                    this.hasRowID = true;
                }
                if (columnDefinition instanceof ForeignKeyColumnDefinition) {
                    this.foreignKeyDefinitions.add((ForeignKeyColumnDefinition)columnDefinition);
                }
                if (!columnDefinition.uniqueGroups.isEmpty()) {
                    List<Integer> groups = columnDefinition.uniqueGroups;
                    for (int group : groups) {
                        List<ColumnDefinition> groupList = this.columnUniqueMap.get(group);
                        if (groupList == null) {
                            groupList = new ArrayList<ColumnDefinition>();
                            this.columnUniqueMap.put(group, groupList);
                        }
                        if (groupList.contains(columnDefinition)) continue;
                        groupList.add(columnDefinition);
                    }
                }
                if (!isPackagePrivate) continue;
                this.packagePrivateList.add(columnDefinition);
                continue;
            }
            if (element.getAnnotation(OneToMany.class) != null) {
                OneToManyDefinition oneToManyDefinition = new OneToManyDefinition((ExecutableElement)element, this.manager);
                if (!oneToManyValidator.validate(this.manager, oneToManyDefinition)) continue;
                this.oneToManyDefinitions.add(oneToManyDefinition);
                continue;
            }
            if (element.getAnnotation(ContainerKey.class) != null) {
                ContainerKeyDefinition containerKeyDefinition = new ContainerKeyDefinition(element, this.manager, this, isPackagePrivateNotInSamePackage);
                this.containerKeyDefinitions.add(containerKeyDefinition);
                continue;
            }
            if (element.getAnnotation(ModelCacheField.class) != null) {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.manager.logError("ModelCacheField must be public from: " + typeElement, new Object[0]);
                }
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.manager.logError("ModelCacheField must be static from: " + typeElement, new Object[0]);
                }
                if (!StringUtils.isNullOrEmpty(this.customCacheFieldName)) {
                    this.manager.logError("ModelCacheField can only be declared once from: " + typeElement, new Object[0]);
                    continue;
                }
                this.customCacheFieldName = element.getSimpleName().toString();
                continue;
            }
            if (element.getAnnotation(MultiCacheField.class) == null) continue;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.manager.logError("MultiCacheField must be public from: " + typeElement, new Object[0]);
            }
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.manager.logError("MultiCacheField must be static from: " + typeElement, new Object[0]);
            }
            if (!StringUtils.isNullOrEmpty(this.customMultiCacheFieldName)) {
                this.manager.logError("MultiCacheField can only be declared once from: " + typeElement, new Object[0]);
                continue;
            }
            this.customMultiCacheFieldName = element.getSimpleName().toString();
        }
    }

    public ColumnDefinition getAutoIncrementPrimaryKey() {
        return this.autoIncrementDefinition;
    }

    @Override
    public List<ColumnDefinition> getPrimaryColumnDefinitions() {
        if (this.getAutoIncrementPrimaryKey() != null) {
            return Lists.newArrayList((Object[])new ColumnDefinition[]{this.getAutoIncrementPrimaryKey()});
        }
        return this.primaryColumnDefinitions;
    }

    public ClassName getAdapterClassName() {
        return ClassName.get((String)this.packageName, (String)this.adapterName, (String[])new String[0]);
    }

    @Override
    public ClassName getPropertyClassName() {
        return this.outputClassName;
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        FieldSpec.Builder propertyConverter = FieldSpec.builder((TypeName)ClassNames.PROPERTY_CONVERTER, (String)"PROPERTY_CONVERTER", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer(CodeBlock.builder().add("new $T(){ \n", new Object[]{ClassNames.PROPERTY_CONVERTER}).add("public $T fromName(String columnName) {\n", new Object[]{ClassNames.IPROPERTY}).add("return $L.getProperty(columnName); \n}\n}", new Object[]{this.getPropertyClassName()}).build());
        typeBuilder.addField(propertyConverter.build());
        MethodSpec.Builder getPropertyForNameMethod = MethodSpec.methodBuilder((String)"getProperty").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "columnName", new Modifier[0]).returns((TypeName)ClassNames.BASE_PROPERTY);
        MethodSpec.Builder getAllColumnPropertiesMethod = MethodSpec.methodBuilder((String)"getAllColumnProperties").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).returns((TypeName)ArrayTypeName.of((TypeName)ClassNames.IPROPERTY));
        CodeBlock.Builder getPropertiesBuilder = CodeBlock.builder();
        getPropertyForNameMethod.addStatement("columnName = $T.quoteIfNeeded(columnName)", new Object[]{ClassName.get(QueryBuilder.class)});
        getPropertyForNameMethod.beginControlFlow("switch ($L) ", new Object[]{"columnName"});
        for (int i = 0; i < this.columnDefinitions.size(); ++i) {
            if (i > 0) {
                getPropertiesBuilder.add(",", new Object[0]);
            }
            ColumnDefinition columnDefinition = (ColumnDefinition)this.columnDefinitions.get(i);
            columnDefinition.addPropertyDefinition(typeBuilder, (TypeName)this.elementClassName);
            columnDefinition.addPropertyCase(getPropertyForNameMethod);
            columnDefinition.addColumnName(getPropertiesBuilder);
        }
        getPropertyForNameMethod.beginControlFlow("default: ", new Object[0]);
        getPropertyForNameMethod.addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, "Invalid column name passed. Ensure you are calling the correct table's column"});
        getPropertyForNameMethod.endControlFlow();
        getPropertyForNameMethod.endControlFlow();
        getAllColumnPropertiesMethod.addStatement("return new $T[]{$L}", new Object[]{ClassNames.IPROPERTY, getPropertiesBuilder.build().toString()});
        typeBuilder.addMethod(getAllColumnPropertiesMethod.build());
        for (IndexGroupsDefinition indexGroupsDefinition : this.indexGroupsDefinitions) {
            typeBuilder.addField(indexGroupsDefinition.getFieldSpec());
        }
        typeBuilder.addMethod(getPropertyForNameMethod.build());
    }

    public void writeAdapter(ProcessingEnvironment processingEnvironment) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.adapterName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.MODEL_ADAPTER, (TypeName[])new TypeName[]{this.elementClassName}));
        InternalAdapterHelper.writeGetModelClass(typeBuilder, this.elementClassName);
        InternalAdapterHelper.writeGetTableName(typeBuilder, this.tableName);
        if (this.hasAutoIncrement || this.hasRowID) {
            InternalAdapterHelper.writeUpdateAutoIncrement(typeBuilder, (TypeName)this.elementClassName, this.autoIncrementDefinition, false);
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getAutoIncrementingId").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)this.elementClassName, ModelUtils.getVariable(false), new Modifier[0]).addStatement("return $L", new Object[]{this.autoIncrementDefinition.getColumnAccessString(false, false)}).returns((TypeName)ClassName.get(Number.class)).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getAutoIncrementingColumnName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $S", new Object[]{QueryBuilder.stripQuotes((String)this.autoIncrementDefinition.columnName)}).returns((TypeName)ClassName.get(String.class)).build());
        }
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getAllColumnProperties").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.getAllColumnProperties()", new Object[]{this.outputClassName}).returns((TypeName)ArrayTypeName.of((TypeName)ClassNames.IPROPERTY)).build());
        if (this.cachingEnabled) {
            boolean singlePrimaryKey = this.getPrimaryColumnDefinitions().size() == 1;
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"createSingleModelLoader").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T<>(getModelClass())", new Object[]{singlePrimaryKey ? ClassNames.SINGLE_KEY_CACHEABLE_MODEL_LOADER : ClassNames.CACHEABLE_MODEL_LOADER}).returns((TypeName)ClassNames.SINGLE_MODEL_LOADER).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"createListModelLoader").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T<>(getModelClass())", new Object[]{singlePrimaryKey ? ClassNames.SINGLE_KEY_CACHEABLE_LIST_MODEL_LOADER : ClassNames.CACHEABLE_LIST_MODEL_LOADER}).returns((TypeName)ClassNames.LIST_MODEL_LOADER).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"createListModelSaver").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T<>(getModelSaver())", new Object[]{ClassNames.CACHEABLE_LIST_MODEL_SAVER}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.CACHEABLE_LIST_MODEL_SAVER, (TypeName[])new TypeName[]{this.elementClassName, ParameterizedTypeName.get((ClassName)ClassNames.MODEL_ADAPTER, (TypeName[])new TypeName[]{this.elementTypeName})})).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"cachingEnabled").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{true}).returns(TypeName.BOOLEAN).build());
            ArrayList primaries = this.primaryColumnDefinitions;
            if (primaries == null || primaries.isEmpty()) {
                primaries = Lists.newArrayList((Object[])new ColumnDefinition[]{this.autoIncrementDefinition});
            }
            InternalAdapterHelper.writeGetCachingId(typeBuilder, (TypeName)this.elementClassName, primaries, false);
            MethodSpec.Builder cachingbuilder = MethodSpec.methodBuilder((String)"createCachingColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            String columns = "return new String[]{";
            for (int i = 0; i < primaries.size(); ++i) {
                ColumnDefinition column = (ColumnDefinition)primaries.get(i);
                if (i > 0) {
                    columns = columns + ",";
                }
                columns = columns + "\"" + QueryBuilder.quoteIfNeeded((String)column.columnName) + "\"";
            }
            columns = columns + "}";
            cachingbuilder.addStatement(columns, new Object[0]).returns((TypeName)ArrayTypeName.of((TypeName)ClassName.get(String.class)));
            typeBuilder.addMethod(cachingbuilder.build());
            if (this.cacheSize != 25) {
                typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getCacheSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{this.cacheSize}).returns(TypeName.INT).build());
            }
            if (!StringUtils.isNullOrEmpty(this.customCacheFieldName)) {
                typeBuilder.addMethod(MethodSpec.methodBuilder((String)"createModelCache").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.$L", new Object[]{this.elementClassName, this.customCacheFieldName}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.MODEL_CACHE, (TypeName[])new TypeName[]{this.elementClassName, WildcardTypeName.subtypeOf(Object.class)})).build());
            }
            if (!StringUtils.isNullOrEmpty(this.customMultiCacheFieldName)) {
                typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getCacheConverter").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.$L", new Object[]{this.elementClassName, this.customMultiCacheFieldName}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.MULTI_KEY_CACHE_CONVERTER, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).build());
            }
            MethodSpec.Builder reloadMethod = MethodSpec.methodBuilder((String)"reloadRelationships").addAnnotation(Override.class).addParameter((TypeName)this.elementClassName, ModelUtils.getVariable(false), new Modifier[0]).addParameter((TypeName)ClassNames.CURSOR, "cursor", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            CodeBlock.Builder loadStatements = CodeBlock.builder();
            AtomicInteger noIndex = new AtomicInteger(-1);
            for (ColumnDefinition columnDefinition : this.foreignKeyDefinitions) {
                CodeBlock.Builder codeBuilder = columnDefinition.getLoadFromCursorMethod(false, false, false, noIndex).toBuilder();
                if (!columnDefinition.elementTypeName.isPrimitive()) {
                    codeBuilder.nextControlFlow("else", new Object[0]);
                    codeBuilder.addStatement(columnDefinition.setColumnAccessString(CodeBlock.builder().add("null", new Object[0]).build(), false), new Object[0]);
                    codeBuilder.endControlFlow();
                }
                loadStatements.add(codeBuilder.build());
            }
            reloadMethod.addCode(loadStatements.build());
            typeBuilder.addMethod(reloadMethod.build());
        }
        CustomTypeConverterPropertyMethod customTypeConverterPropertyMethod = new CustomTypeConverterPropertyMethod(this);
        customTypeConverterPropertyMethod.addToType(typeBuilder);
        CodeBlock.Builder constructorCode = CodeBlock.builder();
        constructorCode.addStatement("super(databaseDefinition)", new Object[0]);
        customTypeConverterPropertyMethod.addCode(constructorCode);
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassNames.DATABASE_HOLDER, "holder", new Modifier[0]).addParameter((TypeName)ClassNames.BASE_DATABASE_DEFINITION_CLASSNAME, "databaseDefinition", new Modifier[0]).addCode(constructorCode.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        for (MethodDefinition methodDefinition : this.methods) {
            MethodSpec spec = methodDefinition.getMethodSpec();
            if (spec == null) continue;
            typeBuilder.addMethod(spec);
        }
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{this.elementClassName}).returns((TypeName)this.elementClassName).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getProperty").addAnnotation(Override.class).addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.getProperty($L)", new Object[]{this.outputClassName, "name"}).returns((TypeName)ClassNames.BASE_PROPERTY).build());
        if (!this.updateConflictActionName.isEmpty()) {
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getUpdateOnConflictAction").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.$L", new Object[]{ClassNames.CONFLICT_ACTION, this.updateConflictActionName}).returns((TypeName)ClassNames.CONFLICT_ACTION).build());
        }
        if (!this.insertConflictActionName.isEmpty()) {
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getInsertOnConflictAction").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.$L", new Object[]{ClassNames.CONFLICT_ACTION, this.insertConflictActionName}).returns((TypeName)ClassNames.CONFLICT_ACTION).build());
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)typeBuilder.build());
        javaFileBuilder.build().writeTo(processingEnvironment.getFiler());
    }
}

