/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.google.common.collect.Lists;
import com.raizlabs.android.dbflow.annotation.OneToMany;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.ProcessorUtils;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.SimpleColumnAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class OneToManyDefinition
extends BaseDefinition {
    public String methodName;
    public String variableName;
    public List<OneToMany.Method> methods = Lists.newArrayList();
    private BaseColumnAccess columnAccess;
    private boolean extendsBaseModel;

    public OneToManyDefinition(ExecutableElement typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        List typeArguments;
        OneToMany oneToMany = typeElement.getAnnotation(OneToMany.class);
        this.methodName = typeElement.getSimpleName().toString();
        this.variableName = oneToMany.variableName();
        if (this.variableName == null || this.variableName.isEmpty()) {
            this.variableName = this.methodName.replace("get", "");
            this.variableName = this.variableName.substring(0, 1).toLowerCase() + this.variableName.substring(1);
        }
        this.methods.addAll(Arrays.asList(oneToMany.methods()));
        this.columnAccess = oneToMany.isVariablePrivate() ? new PrivateColumnAccess(false) : new SimpleColumnAccess();
        this.extendsBaseModel = false;
        TypeMirror returnType = typeElement.getReturnType();
        TypeName typeName = TypeName.get((TypeMirror)returnType);
        if (typeName instanceof ParameterizedTypeName && (typeArguments = ((ParameterizedTypeName)typeName).typeArguments).size() == 1) {
            TypeName returnTypeName = (TypeName)typeArguments.get(0);
            this.extendsBaseModel = ProcessorUtils.isSubclass(this.manager.getProcessingEnvironment(), ClassNames.BASE_MODEL.toString(), this.manager.getElements().getTypeElement(returnTypeName.toString()));
        }
    }

    public boolean isLoad() {
        return this.isAll() || this.methods.contains(OneToMany.Method.LOAD);
    }

    public boolean isAll() {
        return this.methods.contains(OneToMany.Method.ALL);
    }

    public boolean isDelete() {
        return this.isAll() || this.methods.contains(OneToMany.Method.DELETE);
    }

    public boolean isSave() {
        return this.isAll() || this.methods.contains(OneToMany.Method.SAVE);
    }

    public void writeLoad(CodeBlock.Builder codeBuilder) {
        if (this.isLoad()) {
            codeBuilder.addStatement(this.getMethodName(), new Object[0]);
        }
    }

    public void writeDelete(CodeBlock.Builder codeBuilder, boolean useWrapper) {
        if (this.isDelete()) {
            this.writeLoopWithMethod(codeBuilder, "delete", useWrapper && this.extendsBaseModel);
            codeBuilder.addStatement(this.columnAccess.setColumnAccessString(null, this.variableName, this.variableName, false, ModelUtils.getVariable(false), CodeBlock.builder().add("null", new Object[0]).build(), false), new Object[0]);
        }
    }

    public void writeSave(CodeBlock.Builder codeBuilder, boolean useWrapper) {
        if (this.isSave()) {
            this.writeLoopWithMethod(codeBuilder, "save", useWrapper && this.extendsBaseModel);
        }
    }

    public void writeUpdate(CodeBlock.Builder codeBuilder, boolean useWrapper) {
        if (this.isSave()) {
            this.writeLoopWithMethod(codeBuilder, "update", useWrapper && this.extendsBaseModel);
        }
    }

    public void writeInsert(CodeBlock.Builder codeBuilder, boolean useWrapper) {
        if (this.isSave()) {
            this.writeLoopWithMethod(codeBuilder, "insert", useWrapper && this.extendsBaseModel);
        }
    }

    private void writeLoopWithMethod(CodeBlock.Builder codeBuilder, String methodName, boolean useWrapper) {
        codeBuilder.beginControlFlow("if ($L != null) ", new Object[]{this.getMethodName()}).beginControlFlow("for ($T value: $L) ", new Object[]{this.extendsBaseModel ? ClassNames.BASE_MODEL : ClassNames.MODEL, this.getMethodName()}).addStatement("value.$L($L)", new Object[]{methodName, useWrapper ? ModelUtils.getWrapper() : ""}).endControlFlow().endControlFlow();
    }

    private String getMethodName() {
        return String.format("%1s.%1s()", ModelUtils.getVariable(false), this.methodName);
    }

    private String getVariableName() {
        return String.format("%1s.%1s", ModelUtils.getVariable(false), this.variableName);
    }
}

