/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.provider.Notify;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class NotifyDefinition
extends BaseDefinition {
    public String[] paths;
    public Notify.Method method;
    public String parent;
    public String methodName;
    public String params;
    public boolean returnsArray;
    public boolean returnsSingle;

    public NotifyDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        Notify notify = typeElement.getAnnotation(Notify.class);
        this.paths = notify.paths();
        this.method = notify.method();
        this.parent = ((TypeElement)typeElement.getEnclosingElement()).getQualifiedName().toString();
        this.methodName = typeElement.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)typeElement;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        StringBuilder paramsBuilder = new StringBuilder();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (first) {
                first = false;
            } else {
                paramsBuilder.append(", ");
            }
            TypeMirror paramType = variableElement.asType();
            String typeAsString = paramType.toString();
            if ("android.content.Context".equals(typeAsString)) {
                paramsBuilder.append("getContext()");
                continue;
            }
            if ("android.net.Uri".equals(typeAsString)) {
                paramsBuilder.append("uri");
                continue;
            }
            if ("android.content.ContentValues".equals(typeAsString)) {
                paramsBuilder.append("values");
                continue;
            }
            if ("long".equals(typeAsString)) {
                paramsBuilder.append("id");
                continue;
            }
            if ("java.lang.String".equals(typeAsString)) {
                paramsBuilder.append("where");
                continue;
            }
            if (!"java.lang.String[]".equals(typeAsString)) continue;
            paramsBuilder.append("whereArgs");
        }
        this.params = paramsBuilder.toString();
        TypeMirror typeMirror = executableElement.getReturnType();
        if ((ClassNames.URI + "[]").equals(typeMirror.toString())) {
            this.returnsArray = true;
        } else if (ClassNames.URI.toString().equals(typeMirror.toString())) {
            this.returnsSingle = true;
        } else {
            processorManager.logError("Notify method returns wrong type. It must return Uri or Uri[]", new Object[0]);
        }
    }

    @Override
    protected ClassName getElementClassName(Element element) {
        return null;
    }
}

