/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.ForeignKey;
import com.raizlabs.android.dbflow.annotation.ManyToMany;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Table;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class ManyToManyDefinition
extends BaseDefinition {
    TypeName referencedTable;
    public TypeName databaseTypeName;
    boolean generateAutoIncrement;
    boolean sameTableReferenced;
    String generatedTableClassName;
    boolean saveForeignKeyModels;
    String thisColumnName;
    String referencedColumnName;

    public ManyToManyDefinition(TypeElement element, ProcessorManager processorManager) {
        this(element, processorManager, element.getAnnotation(ManyToMany.class));
    }

    public ManyToManyDefinition(TypeElement element, ProcessorManager processorManager, ManyToMany manyToMany) {
        super(element, processorManager);
        this.referencedTable = TypeName.get((TypeMirror)ModelUtils.getReferencedClassFromAnnotation(manyToMany));
        this.generateAutoIncrement = manyToMany.generateAutoIncrement();
        this.generatedTableClassName = manyToMany.generatedTableClassName();
        this.saveForeignKeyModels = manyToMany.saveForeignKeyModels();
        this.sameTableReferenced = this.referencedTable.equals((Object)this.elementTypeName);
        Table table = element.getAnnotation(Table.class);
        try {
            table.database();
        }
        catch (MirroredTypeException mte) {
            this.databaseTypeName = TypeName.get((TypeMirror)mte.getTypeMirror());
        }
        this.thisColumnName = manyToMany.thisTableColumnName();
        this.referencedColumnName = manyToMany.referencedTableColumnName();
        if (!StringUtils.isNullOrEmpty(this.thisColumnName) && !StringUtils.isNullOrEmpty(this.referencedColumnName) && this.thisColumnName.equals(this.referencedColumnName)) {
            this.manager.logError(ManyToManyDefinition.class, "The thisTableColumnName and referenceTableColumnNamecannot be the same", new Object[0]);
        }
    }

    public void prepareForWrite() {
        DatabaseDefinition databaseDefinition = this.manager.getDatabaseHolderDefinition(this.databaseTypeName).getDatabaseDefinition();
        if (databaseDefinition == null) {
            this.manager.logError("DatabaseDefinition was null for : " + this.elementName, new Object[0]);
        } else if (StringUtils.isNullOrEmpty(this.generatedTableClassName)) {
            ClassName referencedOutput = this.getElementClassName(this.manager.getElements().getTypeElement(this.referencedTable.toString()));
            this.setOutputClassName(databaseDefinition.classSeparator + referencedOutput.simpleName());
        } else {
            this.setOutputClassNameFull(this.generatedTableClassName);
        }
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        typeBuilder.addAnnotation(AnnotationSpec.builder(Table.class).addMember("database", "$T.class", new Object[]{this.databaseTypeName}).build());
        TableDefinition referencedDefinition = this.manager.getTableDefinition(this.databaseTypeName, this.referencedTable);
        TableDefinition selfDefinition = this.manager.getTableDefinition(this.databaseTypeName, this.elementTypeName);
        if (this.generateAutoIncrement) {
            typeBuilder.addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)"_id", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(PrimaryKey.class).addMember("autoincrement", "true", new Object[0]).build()).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getId").returns(TypeName.LONG).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{"_id"}).build());
        }
        this.appendColumnDefinitions(typeBuilder, referencedDefinition, 0, this.referencedColumnName);
        this.appendColumnDefinitions(typeBuilder, selfDefinition, 1, this.thisColumnName);
    }

    @Override
    protected TypeName getExtendsClass() {
        return ClassNames.BASE_MODEL;
    }

    private void appendColumnDefinitions(TypeSpec.Builder typeBuilder, TableDefinition referencedDefinition, int index, String optionalName) {
        String fieldName = StringUtils.lower(referencedDefinition.elementName);
        if (this.sameTableReferenced) {
            fieldName = fieldName + index;
        }
        if (!StringUtils.isNullOrEmpty(optionalName)) {
            fieldName = optionalName;
        }
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)referencedDefinition.elementClassName, (String)fieldName, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(ForeignKey.class).addMember("saveForeignKeyModel", this.saveForeignKeyModels + "", new Object[0]).build());
        if (!this.generateAutoIncrement) {
            fieldBuilder.addAnnotation(AnnotationSpec.builder(PrimaryKey.class).build());
        }
        typeBuilder.addField(fieldBuilder.build()).build();
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)("get" + StringUtils.capitalize(fieldName))).returns((TypeName)referencedDefinition.elementClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{fieldName}).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)("set" + StringUtils.capitalize(fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)referencedDefinition.elementClassName, "param", new Modifier[0]).addStatement("$L = param", new Object[]{fieldName}).build());
    }
}

