/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.TypeConverterDefinition;
import com.raizlabs.android.dbflow.processor.definition.TypeDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseHolderDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class FlowManagerHolderDefinition
implements TypeDefinition {
    private final ProcessorManager processorManager;
    private String className = "";
    private static final String OPTION_TARGET_MODULE_NAME = "targetModuleName";

    public FlowManagerHolderDefinition(ProcessorManager processorManager) {
        this.processorManager = processorManager;
        Map<String, String> options = this.processorManager.getProcessingEnvironment().getOptions();
        if (options.containsKey(OPTION_TARGET_MODULE_NAME)) {
            this.className = options.get(OPTION_TARGET_MODULE_NAME);
        }
        this.className = this.className + "GeneratedDatabaseHolder";
    }

    @Override
    public TypeSpec getTypeSpec() {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ClassNames.DATABASE_HOLDER);
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeConverterDefinition typeConverterDefinition : this.processorManager.getTypeConverters()) {
            constructor.addStatement("$L.put($T.class, new $T())", new Object[]{"typeConverters", typeConverterDefinition.getModelTypeName(), typeConverterDefinition.getClassName()});
        }
        for (DatabaseHolderDefinition databaseDefinition : this.processorManager.getDatabaseDefinitionMap()) {
            if (databaseDefinition.getDatabaseDefinition() == null) continue;
            constructor.addStatement("new $T(this)", new Object[]{databaseDefinition.getDatabaseDefinition().outputClassName});
        }
        typeBuilder.addMethod(constructor.build());
        return typeBuilder.build();
    }
}

