/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.processor.definition.TypeDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class BaseDefinition
implements TypeDefinition {
    public final ProcessorManager manager;
    public ClassName elementClassName;
    public TypeName elementTypeName;
    public ClassName outputClassName;
    public TypeName erasedTypeName;
    public Element element;
    public TypeElement typeElement;
    public String elementName;
    public String packageName;

    public BaseDefinition(ExecutableElement element, ProcessorManager processorManager) {
        this.manager = processorManager;
        this.element = element;
        this.packageName = this.manager.getElements().getPackageOf(element).toString();
        this.elementName = element.getSimpleName().toString();
        try {
            TypeMirror typeMirror = element.asType();
            this.elementTypeName = TypeName.get((TypeMirror)typeMirror);
            if (!this.elementTypeName.isPrimitive()) {
                this.elementClassName = this.getElementClassName(element);
            }
            TypeMirror erasedType = processorManager.getTypeUtils().erasure(typeMirror);
            this.erasedTypeName = TypeName.get((TypeMirror)erasedType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BaseDefinition(Element element, ProcessorManager processorManager) {
        this.manager = processorManager;
        this.element = element;
        this.packageName = this.manager.getElements().getPackageOf(element).toString();
        try {
            TypeMirror typeMirror;
            if (element instanceof ExecutableElement) {
                typeMirror = ((ExecutableElement)element).getReturnType();
                this.elementTypeName = TypeName.get((TypeMirror)typeMirror);
            } else {
                typeMirror = element.asType();
                this.elementTypeName = TypeName.get((TypeMirror)typeMirror);
            }
            TypeMirror erasedType = processorManager.getTypeUtils().erasure(typeMirror);
            this.erasedTypeName = TypeName.get((TypeMirror)erasedType);
        }
        catch (IllegalArgumentException i) {
            this.manager.logError("Found illegal type:" + element.asType() + " for " + element.getSimpleName().toString(), new Object[0]);
            this.manager.logError("Exception here:" + i.toString(), new Object[0]);
        }
        this.elementName = element.getSimpleName().toString();
        if (!this.elementTypeName.isPrimitive()) {
            this.elementClassName = this.getElementClassName(element);
        }
        if (element instanceof TypeElement) {
            this.typeElement = (TypeElement)element;
        }
    }

    public BaseDefinition(TypeElement element, ProcessorManager processorManager) {
        this.manager = processorManager;
        this.typeElement = element;
        this.elementClassName = ClassName.get((TypeElement)this.typeElement);
        this.elementTypeName = TypeName.get((TypeMirror)element.asType());
        this.elementName = element.getSimpleName().toString();
        this.packageName = this.manager.getElements().getPackageOf(element).toString();
    }

    protected ClassName getElementClassName(Element element) {
        try {
            return ClassName.bestGuess((String)element.asType().toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setOutputClassName(String postfix) {
        String outputName;
        if (this.elementClassName == null) {
            if (this.elementTypeName instanceof ClassName) {
                outputName = ((ClassName)this.elementTypeName).simpleName();
            } else if (this.elementTypeName instanceof ParameterizedTypeName) {
                outputName = ((ParameterizedTypeName)this.elementTypeName).rawType.simpleName();
                this.elementClassName = ((ParameterizedTypeName)this.elementTypeName).rawType;
            } else {
                outputName = this.elementTypeName.toString();
            }
        } else {
            outputName = this.elementClassName.simpleName();
        }
        this.outputClassName = ClassName.get((String)this.packageName, (String)(outputName + postfix), (String[])new String[0]);
    }

    protected void setOutputClassNameFull(String fullName) {
        this.outputClassName = ClassName.get((String)this.packageName, (String)fullName, (String[])new String[0]);
    }

    @Override
    public TypeSpec getTypeSpec() {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.outputClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterfaces(Arrays.asList(this.getImplementsClasses()));
        TypeName extendsClass = this.getExtendsClass();
        if (extendsClass != null) {
            typeBuilder.superclass(extendsClass);
        }
        typeBuilder.addJavadoc("This is generated code. Please do not modify", new Object[0]);
        this.onWriteDefinition(typeBuilder);
        return typeBuilder.build();
    }

    public ProcessorManager getManager() {
        return this.manager;
    }

    protected TypeName getExtendsClass() {
        return null;
    }

    protected TypeName[] getImplementsClasses() {
        return new TypeName[0];
    }

    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
    }
}

