/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor;

import com.raizlabs.android.dbflow.data.Blob;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum SQLiteHelper {
    INTEGER{

        @Override
        public String getSQLiteStatementMethod() {
            return "Long";
        }
    }
    ,
    REAL{

        @Override
        public String getSQLiteStatementMethod() {
            return "Double";
        }
    }
    ,
    TEXT{

        @Override
        public String getSQLiteStatementMethod() {
            return "String";
        }
    }
    ,
    BLOB{

        @Override
        public String getSQLiteStatementMethod() {
            return "Blob";
        }
    };

    private static final HashMap<TypeName, SQLiteHelper> sTypeMap;
    private static final Map<TypeName, String> sMethodMap;
    private static Map<TypeName, String> sModelContainerMethodMap;
    private static Set<TypeName> sNumberMethodList;

    public abstract String getSQLiteStatementMethod();

    public static SQLiteHelper get(TypeName typeName) {
        SQLiteHelper sqLiteHelper = sTypeMap.get(typeName);
        if (sqLiteHelper == null) {
            sqLiteHelper = TEXT;
        }
        return sqLiteHelper;
    }

    public static boolean containsType(TypeName typeName) {
        return sTypeMap.containsKey(typeName);
    }

    public static boolean containsMethod(TypeName typeName) {
        return sMethodMap.containsKey(typeName);
    }

    public static String getMethod(TypeName typeName) {
        return sMethodMap.get(typeName);
    }

    public static String getModelContainerMethod(TypeName typeName) {
        return sModelContainerMethodMap.get(typeName);
    }

    public static boolean containsNumberMethod(TypeName typeName) {
        return sNumberMethodList.contains(typeName);
    }

    static {
        sTypeMap = new HashMap<TypeName, SQLiteHelper>(){
            {
                this.put(TypeName.BYTE, INTEGER);
                this.put(TypeName.SHORT, INTEGER);
                this.put(TypeName.INT, INTEGER);
                this.put(TypeName.LONG, INTEGER);
                this.put(TypeName.FLOAT, REAL);
                this.put(TypeName.DOUBLE, REAL);
                this.put(TypeName.BOOLEAN, INTEGER);
                this.put(TypeName.CHAR, TEXT);
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE), BLOB);
                this.put(TypeName.BYTE.box(), INTEGER);
                this.put(TypeName.SHORT.box(), INTEGER);
                this.put(TypeName.INT.box(), INTEGER);
                this.put(TypeName.LONG.box(), INTEGER);
                this.put(TypeName.FLOAT.box(), REAL);
                this.put(TypeName.DOUBLE.box(), REAL);
                this.put(TypeName.BOOLEAN.box(), INTEGER);
                this.put(TypeName.CHAR.box(), TEXT);
                this.put(ClassName.get(String.class), TEXT);
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE.box()), BLOB);
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE), BLOB);
                this.put(ClassName.get(Blob.class), BLOB);
            }
        };
        sMethodMap = new HashMap<TypeName, String>(){
            {
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE), "getBlob");
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE.box()), "getBlob");
                this.put(TypeName.BOOLEAN, "getInt");
                this.put(TypeName.BYTE, "getInt");
                this.put(TypeName.BYTE.box(), "getInt");
                this.put(TypeName.CHAR, "getString");
                this.put(TypeName.CHAR.box(), "getString");
                this.put(TypeName.DOUBLE, "getDouble");
                this.put(TypeName.DOUBLE.box(), "getDouble");
                this.put(TypeName.FLOAT, "getFloat");
                this.put(TypeName.FLOAT.box(), "getFloat");
                this.put(TypeName.INT, "getInt");
                this.put(TypeName.INT.box(), "getInt");
                this.put(TypeName.LONG, "getLong");
                this.put(TypeName.LONG.box(), "getLong");
                this.put(TypeName.SHORT, "getShort");
                this.put(TypeName.SHORT.box(), "getShort");
                this.put(ClassName.get(String.class), "getString");
                this.put(ClassName.get(Blob.class), "getBlob");
            }
        };
        sModelContainerMethodMap = new HashMap<TypeName, String>(){
            {
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE), "getBlb");
                this.put(ArrayTypeName.of((TypeName)TypeName.BYTE.box()), "getBlob");
                this.put(TypeName.BYTE, "getByt");
                this.put(TypeName.BYTE.box(), "getByte");
                this.put(TypeName.DOUBLE, "getDble");
                this.put(TypeName.DOUBLE.box(), "getDouble");
                this.put(TypeName.FLOAT, "getFlt");
                this.put(TypeName.FLOAT.box(), "getFloat");
                this.put(TypeName.INT, "getInt");
                this.put(TypeName.INT.box(), "getInteger");
                this.put(TypeName.LONG, "getLng");
                this.put(TypeName.LONG.box(), "getLong");
                this.put(TypeName.SHORT, "getShrt");
                this.put(TypeName.SHORT.box(), "getShort");
                this.put(TypeName.BOOLEAN.box(), "getBoolean");
                this.put(TypeName.BOOLEAN, "getBool");
                this.put(ClassName.get(String.class), "getString");
                this.put(ClassName.get(Blob.class), "getBlb");
            }
        };
        sNumberMethodList = new HashSet<TypeName>(){
            {
                this.add(TypeName.BYTE);
                this.add(TypeName.DOUBLE);
                this.add(TypeName.FLOAT);
                this.add(TypeName.LONG);
                this.add(TypeName.SHORT);
                this.add(TypeName.INT);
            }
        };
    }
}

