/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ProcessorUtils {
    public static boolean implementsClass(ProcessingEnvironment processingEnvironment, String fqTn, TypeElement element) {
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(fqTn);
        if (typeElement == null) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type Element was null for: " + fqTn + "" + "ensure that the visibility of the class is not private.");
            return false;
        }
        TypeMirror classMirror = typeElement.asType();
        if (classMirror != null) {
            classMirror = processingEnvironment.getTypeUtils().erasure(classMirror);
        }
        return classMirror != null && element != null && element.asType() != null && processingEnvironment.getTypeUtils().isAssignable(element.asType(), classMirror);
    }

    public static boolean isSubclass(ProcessingEnvironment processingEnvironment, String fqTn, TypeElement element) {
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(fqTn);
        if (typeElement == null) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type Element was null for: " + fqTn + "" + "ensure that the visibility of the class is not private.");
            return false;
        }
        TypeMirror classMirror = typeElement.asType();
        return classMirror != null && element != null && element.asType() != null && processingEnvironment.getTypeUtils().isSubtype(element.asType(), classMirror);
    }

    public static boolean isSubclassOf(String columnFieldType, Class<?> enumClass) {
        boolean isSubClass = false;
        try {
            Class<?> type = Class.forName(columnFieldType);
            isSubClass = type.getSuperclass() != null && (type.getSuperclass().equals(enumClass) || ProcessorUtils.isSubclassOf(type.getSuperclass().getName(), enumClass));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isSubClass;
    }
}

