/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    public HorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new HorizontalBarBuffer(set.getEntryCount() * 4 * (set.isStacked() ? set.getStackSize() : 1), barData.getDataSetCount(), set.isStacked());
        }
    }

    @Override
    protected void drawDataSet(Canvas c, IBarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        this.mBarBorderPaint.setColor(dataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        for (int j = 0; j < buffer.size() && this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3]); j += 4) {
            if (!this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) continue;
            if (this.mChart.isDrawBarShadowEnabled()) {
                c.drawRect(this.mViewPortHandler.contentLeft(), buffer.buffer[j + 1], this.mViewPortHandler.contentRight(), buffer.buffer[j + 3], this.mShadowPaint);
            }
            this.mRenderPaint.setColor(dataSet.getColor(j / 4));
            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            if (!drawBorder) continue;
            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mBarBorderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                IBarDataSet dataSet = (IBarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                this.applyValueTextStyle(dataSet);
                float halfTextHeight = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                ValueFormatter formatter = dataSet.getValueFormatter();
                BarBuffer buffer = this.mBarBuffers[i];
                if (!dataSet.isStacked()) {
                    int j = 0;
                    while ((float)j < (float)buffer.buffer.length * this.mAnimator.getPhaseX()) {
                        float y = (buffer.buffer[j + 1] + buffer.buffer[j + 3]) / 2.0f;
                        if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 1])) continue block0;
                        if (this.mViewPortHandler.isInBoundsX(buffer.buffer[j]) && this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                            BarEntry e = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            float val = e.getY();
                            String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                            float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            this.drawValue(c, formattedValue, buffer.buffer[j + 2] + (val >= 0.0f ? posOffset : negOffset), y + halfTextHeight, dataSet.getValueTextColor(j / 2));
                        }
                        j += 4;
                    }
                    continue;
                }
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int bufferIndex = 0;
                int index = 0;
                while ((float)index < (float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()) {
                    BarEntry e = (BarEntry)dataSet.getEntryForIndex(index);
                    int color = dataSet.getValueTextColor(index);
                    float[] vals = e.getYVals();
                    if (vals == null) {
                        if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[bufferIndex + 1])) continue block0;
                        if (!this.mViewPortHandler.isInBoundsX(buffer.buffer[bufferIndex]) || !this.mViewPortHandler.isInBoundsBottom(buffer.buffer[bufferIndex + 1])) continue;
                        float val = e.getY();
                        String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                        float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                        posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                        float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                        if (isInverted) {
                            posOffset = -posOffset - valueTextWidth;
                            negOffset = -negOffset - valueTextWidth;
                        }
                        this.drawValue(c, formattedValue, buffer.buffer[bufferIndex + 2] + (e.getY() >= 0.0f ? posOffset : negOffset), buffer.buffer[bufferIndex + 1] + halfTextHeight, color);
                    } else {
                        float[] transformed = new float[vals.length * 2];
                        float posY = 0.0f;
                        float negY = -e.getNegativeSum();
                        int k = 0;
                        int idx = 0;
                        while (k < transformed.length) {
                            float y;
                            float value = vals[idx];
                            if (value >= 0.0f) {
                                y = posY += value;
                            } else {
                                y = negY;
                                negY -= value;
                            }
                            transformed[k] = y * this.mAnimator.getPhaseY();
                            k += 2;
                            ++idx;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float val = vals[k / 2];
                            String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                            float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            float x = transformed[k] + (val >= 0.0f ? posOffset : negOffset);
                            float y = (buffer.buffer[bufferIndex + 1] + buffer.buffer[bufferIndex + 3]) / 2.0f;
                            if (!this.mViewPortHandler.isInBoundsTop(y)) break;
                            if (!this.mViewPortHandler.isInBoundsX(x) || !this.mViewPortHandler.isInBoundsBottom(y)) continue;
                            this.drawValue(c, formattedValue, x, y + halfTextHeight, color);
                        }
                    }
                    bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                    ++index;
                }
            }
        }
    }

    protected void drawValue(Canvas c, String valueText, float x, float y, int color) {
        this.mValuePaint.setColor(color);
        c.drawText(valueText, x, y, this.mValuePaint);
    }

    @Override
    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, Transformer trans) {
        float top = x - barWidthHalf;
        float bottom = x + barWidthHalf;
        float left = y1;
        float right = y2;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectToPixelPhaseHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    protected void setHighlightDrawPos(Highlight high, RectF bar) {
        high.setDraw(bar.centerY(), bar.right);
    }

    @Override
    protected boolean isDrawingValuesAllowed(ChartInterface chart) {
        return (float)chart.getData().getEntryCount() < (float)chart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

