/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.utils.Utils;

public class YAxis
extends AxisBase {
    private boolean mDrawTopYLabelEntry = true;
    protected boolean mInverted = false;
    protected boolean mDrawZeroLine = false;
    protected int mZeroLineColor = -7829368;
    protected float mZeroLineWidth = 1.0f;
    protected float mSpacePercentTop = 10.0f;
    protected float mSpacePercentBottom = 10.0f;
    private YAxisLabelPosition mPosition = YAxisLabelPosition.OUTSIDE_CHART;
    private AxisDependency mAxisDependency;
    protected float mMinWidth = 0.0f;
    protected float mMaxWidth = Float.POSITIVE_INFINITY;

    public YAxis() {
        this.mAxisDependency = AxisDependency.LEFT;
        this.mYOffset = 0.0f;
    }

    public YAxis(AxisDependency position) {
        this.mAxisDependency = position;
        this.mYOffset = 0.0f;
    }

    public AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    public float getMinWidth() {
        return this.mMinWidth;
    }

    public void setMinWidth(float minWidth) {
        this.mMinWidth = minWidth;
    }

    public float getMaxWidth() {
        return this.mMaxWidth;
    }

    public void setMaxWidth(float maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public YAxisLabelPosition getLabelPosition() {
        return this.mPosition;
    }

    public void setPosition(YAxisLabelPosition pos) {
        this.mPosition = pos;
    }

    public boolean isDrawTopYLabelEntryEnabled() {
        return this.mDrawTopYLabelEntry;
    }

    public void setDrawTopYLabelEntry(boolean enabled) {
        this.mDrawTopYLabelEntry = enabled;
    }

    public void setInverted(boolean enabled) {
        this.mInverted = enabled;
    }

    public boolean isInverted() {
        return this.mInverted;
    }

    @Deprecated
    public void setStartAtZero(boolean startAtZero) {
        if (startAtZero) {
            this.setAxisMinValue(0.0f);
        } else {
            this.resetAxisMinValue();
        }
    }

    public void setSpaceTop(float percent) {
        this.mSpacePercentTop = percent;
    }

    public float getSpaceTop() {
        return this.mSpacePercentTop;
    }

    public void setSpaceBottom(float percent) {
        this.mSpacePercentBottom = percent;
    }

    public float getSpaceBottom() {
        return this.mSpacePercentBottom;
    }

    public boolean isDrawZeroLineEnabled() {
        return this.mDrawZeroLine;
    }

    public void setDrawZeroLine(boolean mDrawZeroLine) {
        this.mDrawZeroLine = mDrawZeroLine;
    }

    public int getZeroLineColor() {
        return this.mZeroLineColor;
    }

    public void setZeroLineColor(int color) {
        this.mZeroLineColor = color;
    }

    public float getZeroLineWidth() {
        return this.mZeroLineWidth;
    }

    public void setZeroLineWidth(float width) {
        this.mZeroLineWidth = Utils.convertDpToPixel(width);
    }

    public float getRequiredWidthSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel();
        float width = (float)Utils.calcTextWidth(p, label) + this.getXOffset() * 2.0f;
        float minWidth = this.getMinWidth();
        float maxWidth = this.getMaxWidth();
        if (minWidth > 0.0f) {
            minWidth = Utils.convertDpToPixel(minWidth);
        }
        if (maxWidth > 0.0f && maxWidth != Float.POSITIVE_INFINITY) {
            maxWidth = Utils.convertDpToPixel(maxWidth);
        }
        width = Math.max(minWidth, Math.min(width, (double)maxWidth > 0.0 ? maxWidth : width));
        return width;
    }

    public float getRequiredHeightSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel();
        return (float)Utils.calcTextHeight(p, label) + this.getYOffset() * 2.0f;
    }

    public boolean needsOffset() {
        return this.isEnabled() && this.isDrawLabelsEnabled() && this.getLabelPosition() == YAxisLabelPosition.OUTSIDE_CHART;
    }

    @Override
    public void calculate(float dataMin, float dataMax) {
        float min;
        float max = this.mCustomAxisMax ? this.mAxisMaximum : dataMax;
        float range = Math.abs(max - (min = this.mCustomAxisMin ? this.mAxisMinimum : dataMin));
        if (range == 0.0f) {
            max += 1.0f;
            min -= 1.0f;
        }
        if (!this.mCustomAxisMin) {
            float bottomSpace = range / 100.0f * this.getSpaceBottom();
            this.mAxisMinimum = min - bottomSpace;
        }
        if (!this.mCustomAxisMax) {
            float topSpace = range / 100.0f * this.getSpaceTop();
            this.mAxisMaximum = max + topSpace;
        }
        this.mAxisRange = Math.abs(this.mAxisMaximum - this.mAxisMinimum);
    }

    public static enum AxisDependency {
        LEFT,
        RIGHT;

    }

    public static enum YAxisLabelPosition {
        OUTSIDE_CHART,
        INSIDE_CHART;

    }
}

