/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.ScatterBuffer;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.renderer.scatter.ShapeRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    protected ScatterDataProvider mChart;
    protected ScatterBuffer[] mScatterBuffers;

    public ScatterChartRenderer(ScatterDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void initBuffers() {
        ScatterData scatterData = this.mChart.getScatterData();
        this.mScatterBuffers = new ScatterBuffer[scatterData.getDataSetCount()];
        for (int i = 0; i < this.mScatterBuffers.length; ++i) {
            IScatterDataSet set = (IScatterDataSet)scatterData.getDataSetByIndex(i);
            this.mScatterBuffers[i] = new ScatterBuffer(set.getEntryCount() * 2);
        }
    }

    @Override
    public void drawData(Canvas c) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (IScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, IScatterDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = Math.max(0.0f, Math.min(1.0f, this.mAnimator.getPhaseX()));
        float phaseY = this.mAnimator.getPhaseY();
        float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
        ScatterBuffer buffer = this.mScatterBuffers[this.mChart.getScatterData().getIndexOfDataSet(dataSet)];
        buffer.setPhases(phaseX, phaseY);
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        ShapeRenderer renderer = dataSet.getShapeRenderer();
        if (renderer == null) {
            throw new RuntimeException("No ShapeRenderer found for provided identifier. Please make sure to add a ShapeRenderer capable of rendering the provided shape.");
        }
        renderer.renderShape(c, dataSet, this.mViewPortHandler, buffer, this.mRenderPaint, shapeSize);
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getScatterData().getDataSets();
            for (int i = 0; i < this.mChart.getScatterData().getDataSetCount(); ++i) {
                IScatterDataSet dataSet = (IScatterDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesScatter(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), bounds.min, bounds.max);
                float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
                for (int j = 0; j < positions.length && this.mViewPortHandler.isInBoundsRight(positions[j]); j += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(positions[j]) || !this.mViewPortHandler.isInBoundsY(positions[j + 1])) continue;
                    Object entry = dataSet.getEntryForIndex(j / 2 + bounds.min);
                    this.drawValue(c, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2 + bounds.min));
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (Highlight high : indices) {
            Object e;
            IScatterDataSet set = (IScatterDataSet)scatterData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXPos(high.getX())), set)) continue;
            PointD pix = this.mChart.getTransformer(set.getAxisDependency()).getPixelsForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.mAnimator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }
}

