/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

public class LineChartRenderer
extends LineRadarRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected Path cubicPath = new Path();
    protected Path cubicFillPath = new Path();
    private float[] mLineBuffer = new float[4];
    private Path mCirclePathBuffer = new Path();

    public LineChartRenderer(LineDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        LineData lineData = this.mChart.getLineData();
        for (ILineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
        c.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void drawDataSet(Canvas c, ILineDataSet dataSet) {
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
        switch (dataSet.getMode()) {
            default: {
                this.drawLinear(c, dataSet);
                break;
            }
            case CUBIC_BEZIER: {
                this.drawCubicBezier(dataSet);
                break;
            }
            case HORIZONTAL_BEZIER: {
                this.drawHorizontalBezier(dataSet);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawHorizontalBezier(ILineDataSet dataSet) {
        float phaseY = this.mAnimator.getPhaseY();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
        this.cubicPath.reset();
        if (bounds.range >= 1) {
            Object prev;
            Object cur = prev = dataSet.getEntryForIndex(bounds.min);
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            for (int j = bounds.min + 1; j <= bounds.range + bounds.min; ++j) {
                prev = dataSet.getEntryForIndex(j - 1);
                cur = dataSet.getEntryForIndex(j);
                float cpx = ((Entry)prev).getX() + (((Entry)cur).getX() - ((Entry)prev).getX()) / 2.0f;
                this.cubicPath.cubicTo(cpx, ((BaseEntry)prev).getY() * phaseY, cpx, ((BaseEntry)cur).getY() * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, dataSet, this.cubicFillPath, trans, bounds);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicBezier(ILineDataSet dataSet) {
        float phaseX = Math.max(0.0f, Math.min(1.0f, this.mAnimator.getPhaseX()));
        float phaseY = this.mAnimator.getPhaseY();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        if (bounds.range >= 1) {
            Object prevPrev;
            Object prev;
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            Object cur = prev = (prevPrev = dataSet.getEntryForIndex(bounds.min));
            Object next = dataSet.getEntryForIndex(bounds.min + 1);
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            for (int j = bounds.min + 1; j <= bounds.range + bounds.min; ++j) {
                prevPrev = dataSet.getEntryForIndex(j == 1 ? 0 : j - 2);
                prev = dataSet.getEntryForIndex(j - 1);
                cur = dataSet.getEntryForIndex(j);
                next = bounds.max > j + 1 ? dataSet.getEntryForIndex(j + 1) : cur;
                prevDx = (((Entry)cur).getX() - ((Entry)prevPrev).getX()) * intensity;
                prevDy = (((BaseEntry)cur).getY() - ((BaseEntry)prevPrev).getY()) * intensity;
                curDx = (((Entry)next).getX() - ((Entry)prev).getX()) * intensity;
                curDy = (((BaseEntry)next).getY() - ((BaseEntry)prev).getY()) * intensity;
                this.cubicPath.cubicTo(((Entry)prev).getX() + prevDx, (((BaseEntry)prev).getY() + prevDy) * phaseY, ((Entry)cur).getX() - curDx, (((BaseEntry)cur).getY() - curDy) * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, dataSet, this.cubicFillPath, trans, bounds);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(Canvas c, ILineDataSet dataSet, Path spline, Transformer trans, BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        spline.lineTo((float)(bounds.min + bounds.range), fillMin);
        spline.lineTo((float)bounds.min, fillMin);
        spline.close();
        trans.pathValueToPixel(spline);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, spline, drawable);
        } else {
            this.drawFilledPath(c, spline, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    protected void drawLinear(Canvas c, ILineDataSet dataSet) {
        int entryCount = dataSet.getEntryCount();
        boolean isDrawSteppedEnabled = dataSet.isDrawSteppedEnabled();
        int pointsPerEntryPair = isDrawSteppedEnabled ? 4 : 2;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Canvas canvas = null;
        canvas = dataSet.isDashedLineEnabled() ? this.mBitmapCanvas : c;
        BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
        if (dataSet.getColors().size() > 1) {
            if (this.mLineBuffer.length != pointsPerEntryPair * 2) {
                this.mLineBuffer = new float[pointsPerEntryPair * 2];
            }
            for (int j = bounds.min; j <= bounds.range + bounds.min; ++j) {
                Object e = dataSet.getEntryForIndex(j);
                if (e == null) continue;
                this.mLineBuffer[0] = ((Entry)e).getX();
                this.mLineBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                if (j < bounds.max) {
                    e = dataSet.getEntryForIndex(j + 1);
                    if (e == null) break;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[2] = ((Entry)e).getX();
                        this.mLineBuffer[3] = this.mLineBuffer[1];
                        this.mLineBuffer[4] = this.mLineBuffer[2];
                        this.mLineBuffer[5] = this.mLineBuffer[3];
                        this.mLineBuffer[6] = ((Entry)e).getX();
                        this.mLineBuffer[7] = ((BaseEntry)e).getY() * phaseY;
                    } else {
                        this.mLineBuffer[2] = ((Entry)e).getX();
                        this.mLineBuffer[3] = ((BaseEntry)e).getY() * phaseY;
                    }
                } else {
                    this.mLineBuffer[2] = this.mLineBuffer[0];
                    this.mLineBuffer[3] = this.mLineBuffer[1];
                }
                trans.pointValuesToPixel(this.mLineBuffer);
                if (this.mViewPortHandler.isInBoundsRight(this.mLineBuffer[0])) {
                    if (!this.mViewPortHandler.isInBoundsLeft(this.mLineBuffer[2]) || !this.mViewPortHandler.isInBoundsTop(this.mLineBuffer[1]) && !this.mViewPortHandler.isInBoundsBottom(this.mLineBuffer[3]) || !this.mViewPortHandler.isInBoundsTop(this.mLineBuffer[1]) && !this.mViewPortHandler.isInBoundsBottom(this.mLineBuffer[3])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    canvas.drawLines(this.mLineBuffer, 0, pointsPerEntryPair * 2, this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            Object e1;
            if (this.mLineBuffer.length != Math.max(entryCount * pointsPerEntryPair, pointsPerEntryPair) * 2) {
                this.mLineBuffer = new float[Math.max(entryCount * pointsPerEntryPair, pointsPerEntryPair) * 2];
            }
            if ((e1 = dataSet.getEntryForIndex(bounds.min)) != null) {
                int j = 0;
                for (int x = bounds.min; x <= bounds.range + bounds.min; ++x) {
                    e1 = dataSet.getEntryForIndex(x == 0 ? 0 : x - 1);
                    Object e2 = dataSet.getEntryForIndex(x);
                    if (e1 == null || e2 == null) continue;
                    this.mLineBuffer[j++] = ((Entry)e1).getX();
                    this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[j++] = ((Entry)e2).getX();
                        this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                        this.mLineBuffer[j++] = ((Entry)e2).getX();
                        this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                    }
                    this.mLineBuffer[j++] = ((Entry)e2).getX();
                    this.mLineBuffer[j++] = ((BaseEntry)e2).getY() * phaseY;
                }
                if (j > 0) {
                    trans.pointValuesToPixel(this.mLineBuffer);
                    int size = Math.max((bounds.range + 1) * pointsPerEntryPair, pointsPerEntryPair) * 2;
                    this.mRenderPaint.setColor(dataSet.getColor());
                    canvas.drawLines(this.mLineBuffer, 0, size, this.mRenderPaint);
                }
            }
        }
        this.mRenderPaint.setPathEffect(null);
        if (dataSet.isDrawFilledEnabled() && entryCount > 0) {
            this.drawLinearFill(c, dataSet, trans, bounds);
        }
    }

    protected void drawLinearFill(Canvas c, ILineDataSet dataSet, Transformer trans, BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Path filled = this.generateFilledPath(dataSet, bounds);
        trans.pathValueToPixel(filled);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, filled, drawable);
        } else {
            this.drawFilledPath(c, filled, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    private Path generateFilledPath(ILineDataSet dataSet, BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        float phaseY = this.mAnimator.getPhaseY();
        boolean isDrawSteppedEnabled = dataSet.getMode() == LineDataSet.Mode.STEPPED;
        Path filled = new Path();
        Object entry = dataSet.getEntryForIndex(bounds.min);
        filled.moveTo(((Entry)entry).getX(), fillMin);
        filled.lineTo(((Entry)entry).getX(), ((BaseEntry)entry).getY() * phaseY);
        for (int x = bounds.min + 1; x <= bounds.range + bounds.min; ++x) {
            Object e = dataSet.getEntryForIndex(x);
            if (isDrawSteppedEnabled) {
                Object ePrev = dataSet.getEntryForIndex(x - 1);
                if (ePrev == null) continue;
                filled.lineTo(((Entry)e).getX(), ((BaseEntry)ePrev).getY() * phaseY);
            }
            filled.lineTo(((Entry)e).getX(), ((BaseEntry)e).getY() * phaseY);
        }
        filled.lineTo(((Entry)dataSet.getEntryForIndex(bounds.range + bounds.min)).getX(), fillMin);
        filled.close();
        return filled;
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getLineData().getDataSets();
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleRadius() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
                float[] positions = trans.generateTransformedValuesLine(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), bounds.min, bounds.max);
                for (int j = 0; j < positions.length; j += 2) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    Object entry = dataSet.getEntryForIndex(j / 2 + bounds.min);
                    this.drawValue(c, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, x, y - (float)valOffset, dataSet.getValueTextColor(j / 2));
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawCircles(c);
    }

    protected void drawCircles(Canvas c) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float phaseY = this.mAnimator.getPhaseY();
        float[] circlesBuffer = new float[2];
        List dataSets = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < dataSets.size(); ++i) {
            Object e;
            ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
            if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled() || dataSet.getEntryCount() == 0) continue;
            this.mCirclePaintInner.setColor(dataSet.getCircleHoleColor());
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            BarLineScatterCandleBubbleRenderer.XBounds bounds = this.getXBounds(this.mChart, dataSet);
            float circleRadius = dataSet.getCircleRadius();
            float circleHoleRadius = dataSet.getCircleHoleRadius();
            boolean drawCircleHole = dataSet.isDrawCircleHoleEnabled() && circleHoleRadius < circleRadius && circleHoleRadius > 0.0f;
            boolean drawTransparentCircleHole = drawCircleHole && dataSet.getCircleHoleColor() == 0x112233;
            for (int j = bounds.min; j <= bounds.range + bounds.min && (e = dataSet.getEntryForIndex(j)) != null; ++j) {
                circlesBuffer[0] = ((Entry)e).getX();
                circlesBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                trans.pointValuesToPixel(circlesBuffer);
                if (!this.mViewPortHandler.isInBoundsRight(circlesBuffer[0])) continue block0;
                if (!this.mViewPortHandler.isInBoundsLeft(circlesBuffer[0]) || !this.mViewPortHandler.isInBoundsY(circlesBuffer[1])) continue;
                this.mRenderPaint.setColor(dataSet.getCircleColor(j));
                if (drawTransparentCircleHole) {
                    this.mCirclePathBuffer.reset();
                    this.mCirclePathBuffer.addCircle(circlesBuffer[0], circlesBuffer[1], circleRadius, Path.Direction.CW);
                    this.mCirclePathBuffer.addCircle(circlesBuffer[0], circlesBuffer[1], circleHoleRadius, Path.Direction.CCW);
                    c.drawPath(this.mCirclePathBuffer, this.mRenderPaint);
                    continue;
                }
                c.drawCircle(circlesBuffer[0], circlesBuffer[1], circleRadius, this.mRenderPaint);
                if (!drawCircleHole) continue;
                c.drawCircle(circlesBuffer[0], circlesBuffer[1], circleHoleRadius, this.mCirclePaintInner);
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        LineData lineData = this.mChart.getLineData();
        for (Highlight high : indices) {
            Object e;
            ILineDataSet set = (ILineDataSet)lineData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXPos(high.getX())), set)) continue;
            PointD pix = this.mChart.getTransformer(set.getAxisDependency()).getPixelsForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.mAnimator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }

    public void setBitmapConfig(Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public void releaseBitmap() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            ((Bitmap)this.mDrawBitmap.get()).recycle();
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

