/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.BubbleChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CombinedChartRenderer
extends DataRenderer {
    protected List<DataRenderer> mRenderers;
    protected WeakReference<Chart> mChart;

    public CombinedChartRenderer(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = new WeakReference<CombinedChart>(chart);
        this.createRenderers(chart, animator, viewPortHandler);
    }

    protected void createRenderers(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        CombinedChart.DrawOrder[] orders;
        this.mRenderers = new ArrayList<DataRenderer>();
        block7: for (CombinedChart.DrawOrder order : orders = chart.getDrawOrder()) {
            switch (order) {
                case BAR: {
                    if (chart.getBarData() == null) continue block7;
                    this.mRenderers.add(new BarChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case BUBBLE: {
                    if (chart.getBubbleData() == null) continue block7;
                    this.mRenderers.add(new BubbleChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case LINE: {
                    if (chart.getLineData() == null) continue block7;
                    this.mRenderers.add(new LineChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case CANDLE: {
                    if (chart.getCandleData() == null) continue block7;
                    this.mRenderers.add(new CandleStickChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case SCATTER: {
                    if (chart.getScatterData() == null) continue block7;
                    this.mRenderers.add(new ScatterChartRenderer(chart, animator, viewPortHandler));
                }
            }
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawData(c);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawExtras(c);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        Chart chart = (Chart)this.mChart.get();
        if (chart == null) {
            return;
        }
        for (DataRenderer renderer : this.mRenderers) {
            BarLineScatterCandleBubbleData data = null;
            if (renderer instanceof BarChartRenderer) {
                data = ((BarChartRenderer)renderer).mChart.getBarData();
            } else if (renderer instanceof LineChartRenderer) {
                data = ((LineChartRenderer)renderer).mChart.getLineData();
            } else if (renderer instanceof CandleStickChartRenderer) {
                data = ((CandleStickChartRenderer)renderer).mChart.getCandleData();
            } else if (renderer instanceof ScatterChartRenderer) {
                data = ((ScatterChartRenderer)renderer).mChart.getScatterData();
            } else if (renderer instanceof BubbleChartRenderer) {
                data = ((BubbleChartRenderer)renderer).mChart.getBubbleData();
            }
            int dataIndex = data == null ? -1 : ((CombinedData)chart.getData()).getAllData().indexOf(data);
            ArrayList<Highlight> dataIndices = new ArrayList<Highlight>();
            for (Highlight h : indices) {
                if (h.getDataIndex() != dataIndex && h.getDataIndex() != -1) continue;
                dataIndices.add(h);
            }
            renderer.drawHighlighted(c, dataIndices.toArray(new Highlight[dataIndices.size()]));
        }
    }

    @Override
    public void calcXBounds(BarLineScatterCandleBubbleDataProvider chart, int xAxisModulus) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.calcXBounds(chart, xAxisModulus);
        }
    }

    public DataRenderer getSubRenderer(int index) {
        if (index >= this.mRenderers.size() || index < 0) {
            return null;
        }
        return this.mRenderers.get(index);
    }

    public List<DataRenderer> getSubRenderers() {
        return this.mRenderers;
    }

    public void setSubRenderers(List<DataRenderer> renderers) {
        this.mRenderers = renderers;
    }
}

