/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.data.realm.base.RealmBaseDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;

public class RealmPieDataSet<T extends RealmObject>
extends RealmBaseDataSet<T, Entry>
implements IPieDataSet {
    private float mSliceSpace = 0.0f;
    private float mShift = 18.0f;
    private PieDataSet.ValuePosition mXValuePosition = PieDataSet.ValuePosition.INSIDE_SLICE;
    private PieDataSet.ValuePosition mYValuePosition = PieDataSet.ValuePosition.INSIDE_SLICE;
    private int mValueLineColor = -16777216;
    private float mValueLineWidth = 1.0f;
    private float mValueLinePart1OffsetPercentage = 75.0f;
    private float mValueLinePart1Length = 0.3f;
    private float mValueLinePart2Length = 0.4f;
    private boolean mValueLineVariableLength = true;

    public RealmPieDataSet(RealmResults<T> result, String yValuesField) {
        super(result, yValuesField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmPieDataSet(RealmResults<T> result, String yValuesField, String xIndexField) {
        super(result, yValuesField, xIndexField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public void setSliceSpace(float spaceDp) {
        if (spaceDp > 20.0f) {
            spaceDp = 20.0f;
        }
        if (spaceDp < 0.0f) {
            spaceDp = 0.0f;
        }
        this.mSliceSpace = Utils.convertDpToPixel(spaceDp);
    }

    @Override
    public float getSliceSpace() {
        return this.mSliceSpace;
    }

    public void setSelectionShift(float shift) {
        this.mShift = Utils.convertDpToPixel(shift);
    }

    @Override
    public float getSelectionShift() {
        return this.mShift;
    }

    @Override
    public PieDataSet.ValuePosition getXValuePosition() {
        return this.mXValuePosition;
    }

    public void setXValuePosition(PieDataSet.ValuePosition xValuePosition) {
        this.mXValuePosition = xValuePosition;
    }

    @Override
    public PieDataSet.ValuePosition getYValuePosition() {
        return this.mYValuePosition;
    }

    public void setYValuePosition(PieDataSet.ValuePosition yValuePosition) {
        this.mYValuePosition = yValuePosition;
    }

    @Override
    public int getValueLineColor() {
        return this.mValueLineColor;
    }

    public void setValueLineColor(int valueLineColor) {
        this.mValueLineColor = valueLineColor;
    }

    @Override
    public float getValueLineWidth() {
        return this.mValueLineWidth;
    }

    public void setValueLineWidth(float valueLineWidth) {
        this.mValueLineWidth = valueLineWidth;
    }

    @Override
    public float getValueLinePart1OffsetPercentage() {
        return this.mValueLinePart1OffsetPercentage;
    }

    public void setValueLinePart1OffsetPercentage(float valueLinePart1OffsetPercentage) {
        this.mValueLinePart1OffsetPercentage = valueLinePart1OffsetPercentage;
    }

    @Override
    public float getValueLinePart1Length() {
        return this.mValueLinePart1Length;
    }

    public void setValueLinePart1Length(float valueLinePart1Length) {
        this.mValueLinePart1Length = valueLinePart1Length;
    }

    @Override
    public float getValueLinePart2Length() {
        return this.mValueLinePart2Length;
    }

    public void setValueLinePart2Length(float valueLinePart2Length) {
        this.mValueLinePart2Length = valueLinePart2Length;
    }

    @Override
    public boolean isValueLineVariableLength() {
        return this.mValueLineVariableLength;
    }

    public void setValueLineVariableLength(boolean valueLineVariableLength) {
        this.mValueLineVariableLength = valueLineVariableLength;
    }
}

