/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.utils.SelectionDetail;

public class HorizontalBarHighlighter
extends BarHighlighter {
    public HorizontalBarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        int setCount;
        BarData barData = ((BarDataProvider)this.mChart).getBarData();
        int xIndex = this.getXIndex(x);
        float baseNoSpace = this.getBase(x);
        int dataSetIndex = (int)baseNoSpace % (setCount = barData.getDataSetCount());
        if (dataSetIndex < 0) {
            dataSetIndex = 0;
        } else if (dataSetIndex >= setCount) {
            dataSetIndex = setCount - 1;
        }
        SelectionDetail selectionDetail = this.getSelectionDetail(xIndex, y, dataSetIndex);
        if (selectionDetail == null) {
            return null;
        }
        IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(dataSetIndex);
        if (set.isStacked()) {
            float[] pts = new float[2];
            pts[0] = y;
            ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).pixelsToValue(pts);
            return this.getStackedHighlight(selectionDetail, set, xIndex, pts[0]);
        }
        return new Highlight(xIndex, selectionDetail.value, selectionDetail.dataIndex, selectionDetail.dataSetIndex, -1);
    }

    @Override
    protected int getXIndex(float x) {
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            float[] pts = new float[2];
            pts[1] = x;
            ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
            return Math.round(pts[1]);
        }
        float baseNoSpace = this.getBase(x);
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int xIndex = (int)baseNoSpace / setCount;
        int valCount = ((BarDataProvider)this.mChart).getData().getXValCount();
        if (xIndex < 0) {
            xIndex = 0;
        } else if (xIndex >= valCount) {
            xIndex = valCount - 1;
        }
        return xIndex;
    }

    @Override
    protected float getBase(float y) {
        float[] pts = new float[2];
        pts[1] = y;
        ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        float yVal = pts[1];
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int steps = (int)(yVal / ((float)setCount + ((BarDataProvider)this.mChart).getBarData().getGroupSpace()));
        float groupSpaceSum = ((BarDataProvider)this.mChart).getBarData().getGroupSpace() * (float)steps;
        float baseNoSpace = yVal - groupSpaceSum;
        return baseNoSpace;
    }
}

