/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.realm.base.RealmBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import io.realm.DynamicRealmObject;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmResults;

public class RealmBarDataSet<T extends RealmObject>
extends RealmBarLineScatterCandleBubbleDataSet<T, BarEntry>
implements IBarDataSet {
    private String mStackValueFieldName;
    private float mBarSpace = 0.15f;
    private int mStackSize = 1;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private float mBarBorderWidth = 0.0f;
    private int mBarBorderColor = -16777216;
    private int mHighLightAlpha = 120;
    private String[] mStackLabels = new String[]{"Stack"};

    public RealmBarDataSet(RealmResults<T> results, String yValuesField, String xIndexField) {
        super(results, yValuesField, xIndexField);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.build(this.results);
        this.calcMinMax(0, results.size());
    }

    public RealmBarDataSet(RealmResults<T> results, String yValuesField, String xIndexField, String stackValueFieldName) {
        super(results, yValuesField, xIndexField);
        this.mStackValueFieldName = stackValueFieldName;
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.build(this.results);
        this.calcMinMax(0, results.size());
    }

    @Override
    public void build(RealmResults<T> results) {
        super.build(results);
        this.calcStackSize();
    }

    @Override
    public BarEntry buildEntryFromResultObject(T realmObject, int xIndex) {
        DynamicRealmObject dynamicObject = new DynamicRealmObject(realmObject);
        if (dynamicObject.getFieldType(this.mValuesField) == RealmFieldType.LIST) {
            RealmList list = dynamicObject.getList(this.mValuesField);
            float[] values = new float[list.size()];
            int i = 0;
            for (DynamicRealmObject o : list) {
                values[i] = o.getFloat(this.mStackValueFieldName);
                ++i;
            }
            return new BarEntry(values, this.mIndexField == null ? xIndex : dynamicObject.getInt(this.mIndexField));
        }
        float value = dynamicObject.getFloat(this.mValuesField);
        return new BarEntry(value, this.mIndexField == null ? xIndex : dynamicObject.getInt(this.mIndexField));
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mValues == null) {
            return;
        }
        int yValCount = this.mValues.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            BarEntry e = (BarEntry)this.mValues.get(i);
            if (e == null || Float.isNaN(e.getVal())) continue;
            if (e.getVals() == null) {
                if (e.getVal() < this.mYMin) {
                    this.mYMin = e.getVal();
                }
                if (!(e.getVal() > this.mYMax)) continue;
                this.mYMax = e.getVal();
                continue;
            }
            if (-e.getNegativeSum() < this.mYMin) {
                this.mYMin = -e.getNegativeSum();
            }
            if (!(e.getPositiveSum() > this.mYMax)) continue;
            this.mYMax = e.getPositiveSum();
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    private void calcStackSize() {
        for (int i = 0; i < this.mValues.size(); ++i) {
            float[] vals = ((BarEntry)this.mValues.get(i)).getVals();
            if (vals == null || vals.length <= this.mStackSize) continue;
            this.mStackSize = vals.length;
        }
    }

    @Override
    public int getStackSize() {
        return this.mStackSize;
    }

    @Override
    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    public float getBarSpacePercent() {
        return this.mBarSpace * 100.0f;
    }

    @Override
    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setBarSpacePercent(float percent) {
        this.mBarSpace = percent / 100.0f;
    }

    public void setBarShadowColor(int color) {
        this.mBarShadowColor = color;
    }

    @Override
    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public void setBarBorderWidth(float width) {
        this.mBarBorderWidth = width;
    }

    @Override
    public float getBarBorderWidth() {
        return this.mBarBorderWidth;
    }

    public void setBarBorderColor(int color) {
        this.mBarBorderColor = color;
    }

    @Override
    public int getBarBorderColor() {
        return this.mBarBorderColor;
    }

    public void setHighLightAlpha(int alpha) {
        this.mHighLightAlpha = alpha;
    }

    @Override
    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    public void setStackLabels(String[] labels) {
        this.mStackLabels = labels;
    }

    @Override
    public String[] getStackLabels() {
        return this.mStackLabels;
    }
}

