/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Legend mLegend;

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public void computeLegend(ChartData<?> data) {
        Typeface tf;
        if (!this.mLegend.isLegendCustom()) {
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (int i = 0; i < data.getDataSetCount(); ++i) {
                int j;
                Object dataSet = data.getDataSetByIndex(i);
                List<Integer> clrs = dataSet.getColors();
                int entryCount = dataSet.getEntryCount();
                if (dataSet instanceof IBarDataSet && ((IBarDataSet)dataSet).isStacked()) {
                    IBarDataSet bds = (IBarDataSet)dataSet;
                    String[] sLabels = bds.getStackLabels();
                    for (j = 0; j < clrs.size() && j < bds.getStackSize(); ++j) {
                        labels.add(sLabels[j % sLabels.length]);
                        colors.add(clrs.get(j));
                    }
                    if (bds.getLabel() == null) continue;
                    colors.add(1122868);
                    labels.add(bds.getLabel());
                    continue;
                }
                if (dataSet instanceof IPieDataSet) {
                    List<String> xVals = data.getXVals();
                    IPieDataSet pds = (IPieDataSet)dataSet;
                    for (j = 0; j < clrs.size() && j < entryCount && j < xVals.size(); ++j) {
                        labels.add(xVals.get(j));
                        colors.add(clrs.get(j));
                    }
                    if (pds.getLabel() == null) continue;
                    colors.add(1122868);
                    labels.add(pds.getLabel());
                    continue;
                }
                if (dataSet instanceof ICandleDataSet && ((ICandleDataSet)dataSet).getDecreasingColor() != 0x112233) {
                    colors.add(((ICandleDataSet)dataSet).getDecreasingColor());
                    colors.add(((ICandleDataSet)dataSet).getIncreasingColor());
                    labels.add(null);
                    labels.add(dataSet.getLabel());
                    continue;
                }
                for (int j2 = 0; j2 < clrs.size() && j2 < entryCount; ++j2) {
                    if (j2 < clrs.size() - 1 && j2 < entryCount - 1) {
                        labels.add(null);
                    } else {
                        String label = data.getDataSetByIndex(i).getLabel();
                        labels.add(label);
                    }
                    colors.add(clrs.get(j2));
                }
            }
            if (this.mLegend.getExtraColors() != null && this.mLegend.getExtraLabels() != null) {
                for (int color : this.mLegend.getExtraColors()) {
                    colors.add(color);
                }
                Collections.addAll(labels, this.mLegend.getExtraLabels());
            }
            this.mLegend.setComputedColors(colors);
            this.mLegend.setComputedLabels(labels);
        }
        if ((tf = this.mLegend.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint, this.mViewPortHandler);
    }

    public void renderLegend(Canvas c) {
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float labelLineHeight = Utils.getLineHeight(this.mLegendLabelPaint);
        float labelLineSpacing = Utils.getLineSpacing(this.mLegendLabelPaint) + this.mLegend.getYEntrySpace();
        float formYOffset = labelLineHeight - (float)Utils.calcTextHeight(this.mLegendLabelPaint, "ABC") / 2.0f;
        String[] labels = this.mLegend.getLabels();
        int[] colors = this.mLegend.getColors();
        float formToTextSpace = this.mLegend.getFormToTextSpace();
        float xEntrySpace = this.mLegend.getXEntrySpace();
        Legend.LegendDirection direction = this.mLegend.getDirection();
        float formSize = this.mLegend.getFormSize();
        float stackSpace = this.mLegend.getStackSpace();
        float yoffset = this.mLegend.getYOffset();
        float xoffset = this.mLegend.getXOffset();
        Legend.LegendPosition legendPosition = this.mLegend.getPosition();
        switch (legendPosition) {
            case BELOW_CHART_LEFT: 
            case BELOW_CHART_RIGHT: 
            case BELOW_CHART_CENTER: 
            case ABOVE_CHART_LEFT: 
            case ABOVE_CHART_RIGHT: 
            case ABOVE_CHART_CENTER: {
                float originPosX;
                float contentWidth = this.mViewPortHandler.contentWidth();
                if (legendPosition == Legend.LegendPosition.BELOW_CHART_LEFT || legendPosition == Legend.LegendPosition.ABOVE_CHART_LEFT) {
                    originPosX = this.mViewPortHandler.contentLeft() + xoffset;
                    if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                        originPosX += this.mLegend.mNeededWidth;
                    }
                } else if (legendPosition == Legend.LegendPosition.BELOW_CHART_RIGHT || legendPosition == Legend.LegendPosition.ABOVE_CHART_RIGHT) {
                    originPosX = this.mViewPortHandler.contentRight() - xoffset;
                    if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                        originPosX -= this.mLegend.mNeededWidth;
                    }
                } else {
                    originPosX = this.mViewPortHandler.contentLeft() + contentWidth / 2.0f - this.mLegend.mNeededWidth / 2.0f;
                }
                FSize[] calculatedLineSizes = this.mLegend.getCalculatedLineSizes();
                FSize[] calculatedLabelSizes = this.mLegend.getCalculatedLabelSizes();
                Boolean[] calculatedLabelBreakPoints = this.mLegend.getCalculatedLabelBreakPoints();
                float posX = originPosX;
                float posY = legendPosition == Legend.LegendPosition.ABOVE_CHART_LEFT || legendPosition == Legend.LegendPosition.ABOVE_CHART_RIGHT || legendPosition == Legend.LegendPosition.ABOVE_CHART_CENTER ? 0.0f : this.mViewPortHandler.getChartHeight() - yoffset - this.mLegend.mNeededHeight;
                int lineIndex = 0;
                int count = labels.length;
                for (int i = 0; i < count; ++i) {
                    boolean isStacked;
                    if (i < calculatedLabelBreakPoints.length && calculatedLabelBreakPoints[i].booleanValue()) {
                        posX = originPosX;
                        posY += labelLineHeight + labelLineSpacing;
                    }
                    if (posX == originPosX && legendPosition == Legend.LegendPosition.BELOW_CHART_CENTER && lineIndex < calculatedLineSizes.length) {
                        posX += (direction == Legend.LegendDirection.RIGHT_TO_LEFT ? calculatedLineSizes[lineIndex].width : -calculatedLineSizes[lineIndex].width) / 2.0f;
                        ++lineIndex;
                    }
                    boolean drawingForm = colors[i] != 1122868;
                    boolean bl = isStacked = labels[i] == null;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        this.drawForm(c, posX, posY + formYOffset, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (!isStacked) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= calculatedLabelSizes[i].width;
                        }
                        this.drawLabel(c, posX, posY + labelLineHeight, labels[i]);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += calculatedLabelSizes[i].width;
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case PIECHART_CENTER: 
            case RIGHT_OF_CHART: 
            case RIGHT_OF_CHART_CENTER: 
            case RIGHT_OF_CHART_INSIDE: 
            case LEFT_OF_CHART: 
            case LEFT_OF_CHART_CENTER: 
            case LEFT_OF_CHART_INSIDE: {
                float posY;
                float posX;
                float stack = 0.0f;
                boolean wasStacked = false;
                if (legendPosition == Legend.LegendPosition.PIECHART_CENTER) {
                    posX = this.mViewPortHandler.getChartWidth() / 2.0f + (direction == Legend.LegendDirection.LEFT_TO_RIGHT ? -this.mLegend.mTextWidthMax / 2.0f : this.mLegend.mTextWidthMax / 2.0f);
                    posY = this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f + this.mLegend.getYOffset();
                } else {
                    boolean isRightAligned;
                    boolean bl = isRightAligned = legendPosition == Legend.LegendPosition.RIGHT_OF_CHART || legendPosition == Legend.LegendPosition.RIGHT_OF_CHART_CENTER || legendPosition == Legend.LegendPosition.RIGHT_OF_CHART_INSIDE;
                    if (isRightAligned) {
                        posX = this.mViewPortHandler.getChartWidth() - xoffset;
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX -= this.mLegend.mTextWidthMax;
                        }
                    } else {
                        posX = xoffset;
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX += this.mLegend.mTextWidthMax;
                        }
                    }
                    posY = legendPosition == Legend.LegendPosition.RIGHT_OF_CHART || legendPosition == Legend.LegendPosition.LEFT_OF_CHART ? this.mViewPortHandler.contentTop() + yoffset : (legendPosition == Legend.LegendPosition.RIGHT_OF_CHART_CENTER || legendPosition == Legend.LegendPosition.LEFT_OF_CHART_CENTER ? this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f : this.mViewPortHandler.contentTop() + yoffset);
                }
                for (int i = 0; i < labels.length; ++i) {
                    Boolean drawingForm = colors[i] != 1122868;
                    float x = posX;
                    if (drawingForm.booleanValue()) {
                        x = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (x += stack) : (x -= formSize - stack);
                        this.drawForm(c, x, posY + formYOffset, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            x += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm.booleanValue() && !wasStacked) {
                            x += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            x = posX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            x -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        if (!wasStacked) {
                            this.drawLabel(c, x, posY + labelLineHeight, labels[i]);
                        } else {
                            this.drawLabel(c, x, (posY += labelLineHeight + labelLineSpacing) + labelLineHeight, labels[i]);
                        }
                        posY += labelLineHeight + labelLineSpacing;
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas c, float x, float y, int index, Legend legend) {
        if (legend.getColors()[index] == 1122868) {
            return;
        }
        this.mLegendFormPaint.setColor(legend.getColors()[index]);
        float formsize = legend.getFormSize();
        float half = formsize / 2.0f;
        switch (legend.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y, half, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y - half, x + formsize, y + half, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                c.drawLine(x, y, x + formsize, y, this.mLegendFormPaint);
            }
        }
    }

    protected void drawLabel(Canvas c, float x, float y, String label) {
        c.drawText(label, x, y, this.mLegendLabelPaint);
    }
}

