/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Paint;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.LineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class CandleDataSet
extends LineScatterCandleRadarDataSet<CandleEntry>
implements ICandleDataSet {
    private float mShadowWidth = 3.0f;
    private boolean mShowCandleBar = true;
    private float mBarSpace = 0.1f;
    private boolean mShadowColorSameAsCandle = false;
    protected Paint.Style mIncreasingPaintStyle = Paint.Style.STROKE;
    protected Paint.Style mDecreasingPaintStyle = Paint.Style.FILL;
    protected int mNeutralColor = -1;
    protected int mIncreasingColor = -1;
    protected int mDecreasingColor = -1;
    protected int mShadowColor = -1;

    public CandleDataSet(List<CandleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<CandleEntry> copy() {
        ArrayList<CandleEntry> yVals = new ArrayList<CandleEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((CandleEntry)this.mYVals.get(i)).copy());
        }
        CandleDataSet copied = new CandleDataSet((List<CandleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mShadowWidth = this.mShadowWidth;
        copied.mShowCandleBar = this.mShowCandleBar;
        copied.mBarSpace = this.mBarSpace;
        copied.mHighLightColor = this.mHighLightColor;
        copied.mIncreasingPaintStyle = this.mIncreasingPaintStyle;
        copied.mDecreasingPaintStyle = this.mDecreasingPaintStyle;
        copied.mShadowColor = this.mShadowColor;
        return copied;
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mYVals == null) {
            return;
        }
        if (this.mYVals.size() == 0) {
            return;
        }
        int endValue = end == 0 || end >= this.mYVals.size() ? this.mYVals.size() - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            CandleEntry e = (CandleEntry)this.mYVals.get(i);
            if (e.getLow() < this.mYMin) {
                this.mYMin = e.getLow();
            }
            if (!(e.getHigh() > this.mYMax)) continue;
            this.mYMax = e.getHigh();
        }
    }

    public void setBarSpace(float space) {
        if (space < 0.0f) {
            space = 0.0f;
        }
        if (space > 0.45f) {
            space = 0.45f;
        }
        this.mBarSpace = space;
    }

    @Override
    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setShadowWidth(float width) {
        this.mShadowWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setShadowWidth(boolean showCandleBar) {
        this.mShowCandleBar = showCandleBar;
    }

    @Override
    public boolean getShowCandleBar() {
        return this.mShowCandleBar;
    }

    public void setNeutralColor(int color) {
        this.mNeutralColor = color;
    }

    @Override
    public int getNeutralColor() {
        return this.mNeutralColor;
    }

    public void setIncreasingColor(int color) {
        this.mIncreasingColor = color;
    }

    @Override
    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    public void setDecreasingColor(int color) {
        this.mDecreasingColor = color;
    }

    @Override
    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    @Override
    public Paint.Style getIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    public void setIncreasingPaintStyle(Paint.Style paintStyle) {
        this.mIncreasingPaintStyle = paintStyle;
    }

    @Override
    public Paint.Style getDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    public void setDecreasingPaintStyle(Paint.Style decreasingPaintStyle) {
        this.mDecreasingPaintStyle = decreasingPaintStyle;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
    }

    @Override
    public boolean getShadowColorSameAsCandle() {
        return this.mShadowColorSameAsCandle;
    }

    public void setShadowColorSameAsCandle(boolean shadowColorSameAsCandle) {
        this.mShadowColorSameAsCandle = shadowColorSameAsCandle;
    }
}

