/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.formatter.DefaultValueFormatter;
import com.github.mikephil.charting.formatter.DefaultYAxisValueFormatter;
import com.github.mikephil.charting.formatter.YAxisValueFormatter;
import com.github.mikephil.charting.utils.Utils;

public class YAxis
extends AxisBase {
    protected YAxisValueFormatter mYAxisValueFormatter;
    public float[] mEntries = new float[0];
    public int mEntryCount;
    public int mDecimals;
    private int mLabelCount = 6;
    private boolean mDrawTopYLabelEntry = true;
    protected boolean mShowOnlyMinMax = false;
    protected boolean mInverted = false;
    protected boolean mStartAtZero = true;
    protected boolean mForceLabels = false;
    protected boolean mDrawZeroLine = true;
    protected int mZeroLineColor = -7829368;
    protected float mZeroLineWidth = 1.0f;
    protected float mCustomAxisMin = Float.NaN;
    protected float mCustomAxisMax = Float.NaN;
    protected float mSpacePercentTop = 10.0f;
    protected float mSpacePercentBottom = 10.0f;
    public float mAxisMaximum = 0.0f;
    public float mAxisMinimum = 0.0f;
    public float mAxisRange = 0.0f;
    private YAxisLabelPosition mPosition = YAxisLabelPosition.OUTSIDE_CHART;
    private AxisDependency mAxisDependency;

    public YAxis() {
        this.mAxisDependency = AxisDependency.LEFT;
        this.mYOffset = 0.0f;
    }

    public YAxis(AxisDependency position) {
        this.mAxisDependency = position;
        this.mYOffset = 0.0f;
    }

    public AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    public YAxisLabelPosition getLabelPosition() {
        return this.mPosition;
    }

    public void setPosition(YAxisLabelPosition pos) {
        this.mPosition = pos;
    }

    public boolean isDrawTopYLabelEntryEnabled() {
        return this.mDrawTopYLabelEntry;
    }

    public void setDrawTopYLabelEntry(boolean enabled) {
        this.mDrawTopYLabelEntry = enabled;
    }

    public void setLabelCount(int count, boolean force) {
        if (count > 25) {
            count = 25;
        }
        if (count < 2) {
            count = 2;
        }
        this.mLabelCount = count;
        this.mForceLabels = force;
    }

    public int getLabelCount() {
        return this.mLabelCount;
    }

    public boolean isForceLabelsEnabled() {
        return this.mForceLabels;
    }

    public void setShowOnlyMinMax(boolean enabled) {
        this.mShowOnlyMinMax = enabled;
    }

    public boolean isShowOnlyMinMaxEnabled() {
        return this.mShowOnlyMinMax;
    }

    public void setInverted(boolean enabled) {
        this.mInverted = enabled;
    }

    public boolean isInverted() {
        return this.mInverted;
    }

    public void setStartAtZero(boolean enabled) {
        this.mStartAtZero = enabled;
    }

    public boolean isStartAtZeroEnabled() {
        return this.mStartAtZero;
    }

    public float getAxisMinValue() {
        return this.mCustomAxisMin;
    }

    public void setAxisMinValue(float min) {
        this.mCustomAxisMin = min;
    }

    public void resetAxisMinValue() {
        this.mCustomAxisMin = Float.NaN;
    }

    public float getAxisMaxValue() {
        return this.mCustomAxisMax;
    }

    public void setAxisMaxValue(float max) {
        this.mCustomAxisMax = max;
    }

    public void resetAxisMaxValue() {
        this.mCustomAxisMax = Float.NaN;
    }

    public void setSpaceTop(float percent) {
        this.mSpacePercentTop = percent;
    }

    public float getSpaceTop() {
        return this.mSpacePercentTop;
    }

    public void setSpaceBottom(float percent) {
        this.mSpacePercentBottom = percent;
    }

    public float getSpaceBottom() {
        return this.mSpacePercentBottom;
    }

    public boolean isDrawZeroLineEnabled() {
        return this.mDrawZeroLine;
    }

    public void setDrawZeroLine(boolean mDrawZeroLine) {
        this.mDrawZeroLine = mDrawZeroLine;
    }

    public int getZeroLineColor() {
        return this.mZeroLineColor;
    }

    public void setZeroLineColor(int color) {
        this.mZeroLineColor = color;
    }

    public float getZeroLineWidth() {
        return this.mZeroLineWidth;
    }

    public void setZeroLineWidth(float width) {
        this.mZeroLineWidth = Utils.convertDpToPixel(width);
    }

    public float getRequiredWidthSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel();
        return (float)Utils.calcTextWidth(p, label) + this.getXOffset() * 2.0f;
    }

    public float getRequiredHeightSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel();
        return (float)Utils.calcTextHeight(p, label) + this.getYOffset() * 2.0f;
    }

    @Override
    public String getLongestLabel() {
        String longest = "";
        for (int i = 0; i < this.mEntries.length; ++i) {
            String text = this.getFormattedLabel(i);
            if (longest.length() >= text.length()) continue;
            longest = text;
        }
        return longest;
    }

    public String getFormattedLabel(int index) {
        if (index < 0 || index >= this.mEntries.length) {
            return "";
        }
        return this.getValueFormatter().getFormattedValue(this.mEntries[index], this);
    }

    public void setValueFormatter(YAxisValueFormatter f) {
        this.mYAxisValueFormatter = f == null ? new DefaultYAxisValueFormatter(this.mDecimals) : f;
    }

    public YAxisValueFormatter getValueFormatter() {
        if (this.mYAxisValueFormatter == null) {
            this.mYAxisValueFormatter = new DefaultYAxisValueFormatter(this.mDecimals);
        }
        return this.mYAxisValueFormatter;
    }

    public boolean needsDefaultFormatter() {
        if (this.mYAxisValueFormatter == null) {
            return true;
        }
        return this.mYAxisValueFormatter instanceof DefaultValueFormatter;
    }

    public boolean needsOffset() {
        return this.isEnabled() && this.isDrawLabelsEnabled() && this.getLabelPosition() == YAxisLabelPosition.OUTSIDE_CHART;
    }

    public static enum AxisDependency {
        LEFT,
        RIGHT;

    }

    public static enum YAxisLabelPosition {
        OUTSIDE_CHART,
        INSIDE_CHART;

    }
}

