/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class Legend
extends ComponentBase {
    private int[] mColors;
    private String[] mLabels;
    private int[] mExtraColors;
    private String[] mExtraLabels;
    private boolean mIsLegendCustom = false;
    private LegendPosition mPosition = LegendPosition.BELOW_CHART_LEFT;
    private LegendDirection mDirection = LegendDirection.LEFT_TO_RIGHT;
    private LegendForm mShape = LegendForm.SQUARE;
    private float mFormSize = 8.0f;
    private float mXEntrySpace = 6.0f;
    private float mYEntrySpace = 0.0f;
    private float mFormToTextSpace = 5.0f;
    private float mStackSpace = 3.0f;
    private float mMaxSizePercent = 0.95f;
    public float mNeededWidth = 0.0f;
    public float mNeededHeight = 0.0f;
    public float mTextHeightMax = 0.0f;
    public float mTextWidthMax = 0.0f;
    private boolean mWordWrapEnabled = false;
    private FSize[] mCalculatedLabelSizes = new FSize[0];
    private Boolean[] mCalculatedLabelBreakPoints = new Boolean[0];
    private FSize[] mCalculatedLineSizes = new FSize[0];

    public Legend() {
        this.mFormSize = Utils.convertDpToPixel(8.0f);
        this.mXEntrySpace = Utils.convertDpToPixel(6.0f);
        this.mYEntrySpace = Utils.convertDpToPixel(0.0f);
        this.mFormToTextSpace = Utils.convertDpToPixel(5.0f);
        this.mTextSize = Utils.convertDpToPixel(10.0f);
        this.mStackSpace = Utils.convertDpToPixel(3.0f);
        this.mXOffset = Utils.convertDpToPixel(5.0f);
        this.mYOffset = Utils.convertDpToPixel(4.0f);
    }

    public Legend(int[] colors, String[] labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = colors;
        this.mLabels = labels;
    }

    public Legend(List<Integer> colors, List<String> labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = Utils.convertIntegers(colors);
        this.mLabels = Utils.convertStrings(labels);
    }

    public void setComputedColors(List<Integer> colors) {
        this.mColors = Utils.convertIntegers(colors);
    }

    public void setComputedLabels(List<String> labels) {
        this.mLabels = Utils.convertStrings(labels);
    }

    public float getMaximumEntryWidth(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextWidth(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max + this.mFormSize + this.mFormToTextSpace;
    }

    public float getMaximumEntryHeight(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextHeight(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public String[] getLabels() {
        return this.mLabels;
    }

    public String getLabel(int index) {
        return this.mLabels[index];
    }

    public int[] getExtraColors() {
        return this.mExtraColors;
    }

    public String[] getExtraLabels() {
        return this.mExtraLabels;
    }

    public void setExtra(List<Integer> colors, List<String> labels) {
        this.mExtraColors = Utils.convertIntegers(colors);
        this.mExtraLabels = Utils.convertStrings(labels);
    }

    public void setExtra(int[] colors, String[] labels) {
        this.mExtraColors = colors;
        this.mExtraLabels = labels;
    }

    public void setCustom(int[] colors, String[] labels) {
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mLabels = labels;
        this.mColors = colors;
        this.mIsLegendCustom = true;
    }

    public void setCustom(List<Integer> colors, List<String> labels) {
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = Utils.convertIntegers(colors);
        this.mLabels = Utils.convertStrings(labels);
        this.mIsLegendCustom = true;
    }

    public void resetCustom() {
        this.mIsLegendCustom = false;
    }

    public boolean isLegendCustom() {
        return this.mIsLegendCustom;
    }

    public LegendPosition getPosition() {
        return this.mPosition;
    }

    public void setPosition(LegendPosition pos) {
        this.mPosition = pos;
    }

    public LegendDirection getDirection() {
        return this.mDirection;
    }

    public void setDirection(LegendDirection pos) {
        this.mDirection = pos;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public void setForm(LegendForm shape) {
        this.mShape = shape;
    }

    public void setFormSize(float size) {
        this.mFormSize = Utils.convertDpToPixel(size);
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getXEntrySpace() {
        return this.mXEntrySpace;
    }

    public void setXEntrySpace(float space) {
        this.mXEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getYEntrySpace() {
        return this.mYEntrySpace;
    }

    public void setYEntrySpace(float space) {
        this.mYEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public void setFormToTextSpace(float space) {
        this.mFormToTextSpace = Utils.convertDpToPixel(space);
    }

    public float getStackSpace() {
        return this.mStackSpace;
    }

    public void setStackSpace(float space) {
        this.mStackSpace = space;
    }

    public float getFullWidth(Paint labelpaint) {
        float width = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] != null) {
                if (this.mColors[i] != -2) {
                    width += this.mFormSize + this.mFormToTextSpace;
                }
                width += (float)Utils.calcTextWidth(labelpaint, this.mLabels[i]);
                if (i >= this.mLabels.length - 1) continue;
                width += this.mXEntrySpace;
                continue;
            }
            width += this.mFormSize;
            if (i >= this.mLabels.length - 1) continue;
            width += this.mStackSpace;
        }
        return width;
    }

    public float getFullHeight(Paint labelpaint) {
        float height = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] == null) continue;
            height += (float)Utils.calcTextHeight(labelpaint, this.mLabels[i]);
            if (i >= this.mLabels.length - 1) continue;
            height += this.mYEntrySpace;
        }
        return height;
    }

    public void setWordWrapEnabled(boolean enabled) {
        this.mWordWrapEnabled = enabled;
    }

    public boolean isWordWrapEnabled() {
        return this.mWordWrapEnabled;
    }

    public float getMaxSizePercent() {
        return this.mMaxSizePercent;
    }

    public void setMaxSizePercent(float maxSize) {
        this.mMaxSizePercent = maxSize;
    }

    public FSize[] getCalculatedLabelSizes() {
        return this.mCalculatedLabelSizes;
    }

    public Boolean[] getCalculatedLabelBreakPoints() {
        return this.mCalculatedLabelBreakPoints;
    }

    public FSize[] getCalculatedLineSizes() {
        return this.mCalculatedLineSizes;
    }

    public void calculateDimensions(Paint labelpaint, ViewPortHandler viewPortHandler) {
        if (this.mPosition == LegendPosition.RIGHT_OF_CHART || this.mPosition == LegendPosition.RIGHT_OF_CHART_CENTER || this.mPosition == LegendPosition.LEFT_OF_CHART || this.mPosition == LegendPosition.LEFT_OF_CHART_CENTER || this.mPosition == LegendPosition.PIECHART_CENTER) {
            this.mNeededWidth = this.getMaximumEntryWidth(labelpaint);
            this.mNeededHeight = this.getFullHeight(labelpaint);
            this.mTextWidthMax = this.mNeededWidth;
            this.mTextHeightMax = this.getMaximumEntryHeight(labelpaint);
        } else if (this.mPosition == LegendPosition.BELOW_CHART_LEFT || this.mPosition == LegendPosition.BELOW_CHART_RIGHT || this.mPosition == LegendPosition.BELOW_CHART_CENTER || this.mPosition == LegendPosition.ABOVE_CHART_LEFT || this.mPosition == LegendPosition.ABOVE_CHART_RIGHT || this.mPosition == LegendPosition.ABOVE_CHART_CENTER) {
            int labelCount = this.mLabels.length;
            float labelLineHeight = Utils.getLineHeight(labelpaint);
            float labelLineSpacing = Utils.getLineSpacing(labelpaint) + this.mYEntrySpace;
            float contentWidth = viewPortHandler.contentWidth();
            ArrayList<FSize> calculatedLabelSizes = new ArrayList<FSize>(labelCount);
            ArrayList<Boolean> calculatedLabelBreakPoints = new ArrayList<Boolean>(labelCount);
            ArrayList<FSize> calculatedLineSizes = new ArrayList<FSize>();
            float maxLineWidth = 0.0f;
            float currentLineWidth = 0.0f;
            float requiredWidth = 0.0f;
            int stackedStartIndex = -1;
            for (int i = 0; i < labelCount; ++i) {
                boolean drawingForm = this.mColors[i] != -2;
                calculatedLabelBreakPoints.add(false);
                requiredWidth = stackedStartIndex == -1 ? 0.0f : (requiredWidth += this.mStackSpace);
                if (this.mLabels[i] != null) {
                    calculatedLabelSizes.add(Utils.calcTextSize(labelpaint, this.mLabels[i]));
                    requiredWidth += drawingForm ? this.mFormToTextSpace + this.mFormSize : 0.0f;
                    requiredWidth += ((FSize)calculatedLabelSizes.get((int)i)).width;
                } else {
                    calculatedLabelSizes.add(new FSize(0.0f, 0.0f));
                    requiredWidth += drawingForm ? this.mFormSize : 0.0f;
                    if (stackedStartIndex == -1) {
                        stackedStartIndex = i;
                    }
                }
                if (this.mLabels[i] != null || i == labelCount - 1) {
                    float requiredSpacing;
                    float f = requiredSpacing = currentLineWidth == 0.0f ? 0.0f : this.mXEntrySpace;
                    if (!this.mWordWrapEnabled || currentLineWidth == 0.0f || contentWidth - currentLineWidth >= requiredSpacing + requiredWidth) {
                        currentLineWidth += requiredSpacing + requiredWidth;
                    } else {
                        calculatedLineSizes.add(new FSize(currentLineWidth, labelLineHeight));
                        maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                        calculatedLabelBreakPoints.set(stackedStartIndex > -1 ? stackedStartIndex : i, true);
                        currentLineWidth = requiredWidth;
                    }
                    if (i == labelCount - 1) {
                        calculatedLineSizes.add(new FSize(currentLineWidth, labelLineHeight));
                        maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                    }
                }
                stackedStartIndex = this.mLabels[i] != null ? -1 : stackedStartIndex;
            }
            this.mCalculatedLabelSizes = calculatedLabelSizes.toArray(new FSize[calculatedLabelSizes.size()]);
            this.mCalculatedLabelBreakPoints = calculatedLabelBreakPoints.toArray(new Boolean[calculatedLabelBreakPoints.size()]);
            this.mCalculatedLineSizes = calculatedLineSizes.toArray(new FSize[calculatedLineSizes.size()]);
            this.mTextWidthMax = this.getMaximumEntryWidth(labelpaint);
            this.mTextHeightMax = this.getMaximumEntryHeight(labelpaint);
            this.mNeededWidth = maxLineWidth;
            this.mNeededHeight = labelLineHeight * (float)this.mCalculatedLineSizes.length + labelLineSpacing * (float)(this.mCalculatedLineSizes.length == 0 ? 0 : this.mCalculatedLineSizes.length - 1);
        } else {
            this.mNeededWidth = this.getFullWidth(labelpaint);
            this.mNeededHeight = this.getMaximumEntryHeight(labelpaint);
            this.mTextWidthMax = this.getMaximumEntryWidth(labelpaint);
            this.mTextHeightMax = this.mNeededHeight;
        }
    }

    public static enum LegendDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    public static enum LegendForm {
        SQUARE,
        CIRCLE,
        LINE;

    }

    public static enum LegendPosition {
        RIGHT_OF_CHART,
        RIGHT_OF_CHART_CENTER,
        RIGHT_OF_CHART_INSIDE,
        LEFT_OF_CHART,
        LEFT_OF_CHART_CENTER,
        LEFT_OF_CHART_INSIDE,
        BELOW_CHART_LEFT,
        BELOW_CHART_RIGHT,
        BELOW_CHART_CENTER,
        ABOVE_CHART_LEFT,
        ABOVE_CHART_RIGHT,
        ABOVE_CHART_CENTER,
        PIECHART_CENTER;

    }
}

