/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import android.graphics.Paint;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.realm.base.RealmLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.dynamic.DynamicRealmObject;

public class RealmCandleDataSet<T extends RealmObject>
extends RealmLineScatterCandleRadarDataSet<T, CandleEntry>
implements ICandleDataSet {
    private String mHighField;
    private String mLowField;
    private String mOpenField;
    private String mCloseField;
    private float mShadowWidth = 3.0f;
    private float mBodySpace = 0.1f;
    private boolean mShadowColorSameAsCandle = false;
    protected Paint.Style mIncreasingPaintStyle = Paint.Style.FILL;
    protected Paint.Style mDecreasingPaintStyle = Paint.Style.STROKE;
    protected int mIncreasingColor = -1;
    protected int mDecreasingColor = -1;
    protected int mShadowColor = -1;

    public RealmCandleDataSet(RealmResults<T> result, String highField, String lowField, String openField, String closeField) {
        super(result, null);
        this.mHighField = highField;
        this.mLowField = lowField;
        this.mOpenField = openField;
        this.mCloseField = closeField;
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmCandleDataSet(RealmResults<T> result, String highField, String lowField, String openField, String closeField, String xIndexField) {
        super(result, null, xIndexField);
        this.mHighField = highField;
        this.mLowField = lowField;
        this.mOpenField = openField;
        this.mCloseField = closeField;
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    @Override
    public void build(RealmResults<T> results) {
        if (this.mIndexField == null) {
            int xIndex = 0;
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new CandleEntry(xIndex, dynamicObject.getFloat(this.mHighField), dynamicObject.getFloat(this.mLowField), dynamicObject.getFloat(this.mOpenField), dynamicObject.getFloat(this.mCloseField)));
                ++xIndex;
            }
        } else {
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new CandleEntry(dynamicObject.getInt(this.mIndexField), dynamicObject.getFloat(this.mHighField), dynamicObject.getFloat(this.mLowField), dynamicObject.getFloat(this.mOpenField), dynamicObject.getFloat(this.mCloseField)));
            }
        }
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mValues == null) {
            return;
        }
        if (this.mValues.size() == 0) {
            return;
        }
        int endValue = end == 0 || end >= this.mValues.size() ? this.mValues.size() - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            CandleEntry e = (CandleEntry)this.mValues.get(i);
            if (e.getLow() < this.mYMin) {
                this.mYMin = e.getLow();
            }
            if (!(e.getHigh() > this.mYMax)) continue;
            this.mYMax = e.getHigh();
        }
    }

    public void setBodySpace(float space) {
        if (space < 0.0f) {
            space = 0.0f;
        }
        if (space > 0.45f) {
            space = 0.45f;
        }
        this.mBodySpace = space;
    }

    @Override
    public float getBodySpace() {
        return this.mBodySpace;
    }

    public void setShadowWidth(float width) {
        this.mShadowWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setDecreasingColor(int color) {
        this.mDecreasingColor = color;
    }

    @Override
    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    public void setIncreasingColor(int color) {
        this.mIncreasingColor = color;
    }

    @Override
    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    @Override
    public Paint.Style getDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    public void setDecreasingPaintStyle(Paint.Style decreasingPaintStyle) {
        this.mDecreasingPaintStyle = decreasingPaintStyle;
    }

    @Override
    public Paint.Style getIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    public void setIncreasingPaintStyle(Paint.Style paintStyle) {
        this.mIncreasingPaintStyle = paintStyle;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
    }

    @Override
    public boolean getShadowColorSameAsCandle() {
        return this.mShadowColorSameAsCandle;
    }

    public void setShadowColorSameAsCandle(boolean shadowColorSameAsCandle) {
        this.mShadowColorSameAsCandle = shadowColorSameAsCandle;
    }
}

