/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.realm.base.RealmBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.dynamic.DynamicRealmObject;

public class RealmBubbleDataSet<T extends RealmObject>
extends RealmBarLineScatterCandleBubbleDataSet<T, BubbleEntry>
implements IBubbleDataSet {
    private String mSizeField;
    protected float mXMax;
    protected float mXMin;
    protected float mMaxSize;
    private float mHighlightCircleWidth = 2.5f;

    public RealmBubbleDataSet(RealmResults<T> result, String yValuesField, String sizeField) {
        super(result, yValuesField);
        this.mSizeField = sizeField;
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmBubbleDataSet(RealmResults<T> result, String yValuesField, String xIndexField, String sizeField) {
        super(result, yValuesField, xIndexField);
        this.mSizeField = sizeField;
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    @Override
    public void build(RealmResults<T> results) {
        if (this.mIndexField == null) {
            int xIndex = 0;
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new BubbleEntry(xIndex, dynamicObject.getFloat(this.mValuesField), dynamicObject.getFloat(this.mSizeField)));
                ++xIndex;
            }
        } else {
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new BubbleEntry(dynamicObject.getInt(this.mIndexField), dynamicObject.getFloat(this.mValuesField), dynamicObject.getFloat(this.mSizeField)));
            }
        }
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mValues == null) {
            return;
        }
        if (this.mValues.size() == 0) {
            return;
        }
        int endValue = end == 0 || end >= this.mValues.size() ? this.mValues.size() - 1 : end;
        this.mYMin = this.yMin((BubbleEntry)this.mValues.get(start));
        this.mYMax = this.yMax((BubbleEntry)this.mValues.get(start));
        for (int i = start; i < endValue; ++i) {
            float size;
            BubbleEntry entry = (BubbleEntry)this.mValues.get(i);
            float ymin = this.yMin(entry);
            float ymax = this.yMax(entry);
            if (ymin < this.mYMin) {
                this.mYMin = ymin;
            }
            if (ymax > this.mYMax) {
                this.mYMax = ymax;
            }
            float xmin = this.xMin(entry);
            float xmax = this.xMax(entry);
            if (xmin < this.mXMin) {
                this.mXMin = xmin;
            }
            if (xmax > this.mXMax) {
                this.mXMax = xmax;
            }
            if (!((size = this.largestSize(entry)) > this.mMaxSize)) continue;
            this.mMaxSize = size;
        }
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getMaxSize() {
        return this.mMaxSize;
    }

    private float yMin(BubbleEntry entry) {
        return entry.getVal();
    }

    private float yMax(BubbleEntry entry) {
        return entry.getVal();
    }

    private float xMin(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float xMax(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float largestSize(BubbleEntry entry) {
        return entry.getSize();
    }

    @Override
    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    public void setSizeField(String sizeField) {
        this.mSizeField = sizeField;
    }

    public String getSizeField() {
        return this.mSizeField;
    }
}

