/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.base;

import android.graphics.Color;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.realm.base.RealmLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineRadarDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.dynamic.DynamicRealmObject;

public abstract class RealmLineRadarDataSet<T extends RealmObject>
extends RealmLineScatterCandleRadarDataSet<T, Entry>
implements ILineRadarDataSet<Entry> {
    private int mFillColor = Color.rgb((int)140, (int)234, (int)255);
    private int mFillAlpha = 85;
    private float mLineWidth = 2.5f;
    private boolean mDrawFilled = false;

    public RealmLineRadarDataSet(RealmResults<T> results, String yValuesField) {
        super(results, yValuesField);
    }

    public RealmLineRadarDataSet(RealmResults<T> results, String yValuesField, String xIndexField) {
        super(results, yValuesField, xIndexField);
    }

    @Override
    public void build(RealmResults<T> results) {
        if (this.mIndexField == null) {
            int xIndex = 0;
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), xIndex));
                ++xIndex;
            }
        } else {
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), dynamicObject.getInt(this.mIndexField)));
            }
        }
    }

    @Override
    public int getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(int color) {
        this.mFillColor = color;
    }

    @Override
    public int getFillAlpha() {
        return this.mFillAlpha;
    }

    public void setFillAlpha(int alpha) {
        this.mFillAlpha = alpha;
    }

    public void setLineWidth(float width) {
        if (width < 0.2f) {
            width = 0.2f;
        }
        if (width > 10.0f) {
            width = 10.0f;
        }
        this.mLineWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    public void setDrawFilled(boolean filled) {
        this.mDrawFilled = filled;
    }

    @Override
    public boolean isDrawFilledEnabled() {
        return this.mDrawFilled;
    }
}

