/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.utils.SelInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class Utils {
    private static DisplayMetrics mMetrics;
    private static final int[] POW_10;

    public static void init(Resources res) {
        mMetrics = res.getDisplayMetrics();
    }

    public static String formatDecimal(double number, int digits) {
        StringBuffer a = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            if (i == 0) {
                a.append(".");
            }
            a.append("0");
        }
        DecimalFormat nf = new DecimalFormat("###,###,###,##0" + a.toString());
        String formatted = nf.format(number);
        return formatted;
    }

    public static float convertDpToPixel(float dp) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.");
            return dp;
        }
        DisplayMetrics metrics = mMetrics;
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertPixelsToDp(...). Otherwise conversion does not take place.");
            return px;
        }
        DisplayMetrics metrics = mMetrics;
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static int calcTextWidth(Paint paint, String demoText) {
        return (int)paint.measureText(demoText);
    }

    public static int calcTextHeight(Paint paint, String demoText) {
        Rect r = new Rect();
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public static int getLegendFormatDigits(float step, int bonus) {
        if ((double)step < 9.9E-6) {
            return 6 + bonus;
        }
        if ((double)step < 9.9E-5) {
            return 5 + bonus;
        }
        if ((double)step < 9.9E-4) {
            return 4 + bonus;
        }
        if ((double)step < 0.0099) {
            return 3 + bonus;
        }
        if ((double)step < 0.099) {
            return 2 + bonus;
        }
        if ((double)step < 0.99) {
            return 1 + bonus;
        }
        return 0 + bonus;
    }

    public static String formatNumber(float number, int digitCount, boolean separateThousands) {
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean zero = false;
        if (number < 1.0f && number > -1.0f) {
            zero = true;
        }
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount > POW_10.length) {
            digitCount = POW_10.length - 1;
        }
        long lval = Math.round(number *= (float)POW_10[digitCount]);
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        while (lval != 0L || charCount < digitCount + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            out[ind--] = (char)(digit + 48);
            if (++charCount == digitCount) {
                out[ind--] = 44;
                ++charCount;
                decimalPointAdded = true;
                continue;
            }
            if (!separateThousands || lval == 0L || charCount <= digitCount) continue;
            if (decimalPointAdded) {
                if ((charCount - digitCount) % 4 != 0) continue;
                out[ind--] = 46;
                ++charCount;
                continue;
            }
            if ((charCount - digitCount) % 4 != 3) continue;
            out[ind--] = 46;
            ++charCount;
        }
        if (zero) {
            out[ind--] = 48;
            ++charCount;
        }
        if (neg) {
            out[ind--] = 45;
            ++charCount;
        }
        int start = out.length - charCount;
        return String.valueOf(out, start, out.length - start);
    }

    public static float roundToNextSignificant(double number) {
        float d = (float)Math.ceil((float)Math.log10(number < 0.0 ? -number : number));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        long shifted = Math.round(number * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public static int getDecimals(float number) {
        float i = Utils.roundToNextSignificant(number);
        return (int)Math.ceil(-Math.log10(i)) + 2;
    }

    public static int[] convertIntegers(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    public static String[] convertStrings(ArrayList<String> strings) {
        String[] ret = new String[strings.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = strings.get(i);
        }
        return ret;
    }

    public static double nextUp(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static int getClosestDataSetIndex(ArrayList<SelInfo> valsAtIndex, float val, YAxis.AxisDependency axis) {
        int index = -1;
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < valsAtIndex.size(); ++i) {
            float cdistance;
            SelInfo sel = valsAtIndex.get(i);
            if (axis != null && sel.dataSet.getAxisDependency() != axis || !((cdistance = Math.abs(sel.val - val)) < distance)) continue;
            index = valsAtIndex.get((int)i).dataSetIndex;
            distance = cdistance;
        }
        return index;
    }

    public static float getMinimumDistance(ArrayList<SelInfo> valsAtIndex, float val, YAxis.AxisDependency axis) {
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < valsAtIndex.size(); ++i) {
            float cdistance;
            SelInfo sel = valsAtIndex.get(i);
            if (sel.dataSet.getAxisDependency() != axis || !((cdistance = Math.abs(sel.val - val)) < distance)) continue;
            distance = cdistance;
        }
        return distance;
    }

    public static PointF getPosition(PointF center, float dist, float angle) {
        PointF p = new PointF((float)((double)center.x + (double)dist * Math.cos(Math.toRadians(angle))), (float)((double)center.y + (double)dist * Math.sin(Math.toRadians(angle))));
        return p;
    }

    static {
        POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

