/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class YAxisRenderer
extends AxisRenderer {
    protected Paint mLimitLinePaint;
    protected YAxis mYAxis;

    public YAxisRenderer(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer trans) {
        super(viewPortHandler, trans);
        this.mYAxis = yAxis;
        this.mAxisPaint.setColor(-16777216);
        this.mAxisPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mLimitLinePaint = new Paint(1);
        this.mLimitLinePaint.setStyle(Paint.Style.FILL_AND_STROKE);
    }

    public void computeAxis(float yMin, float yMax) {
        if (this.mViewPortHandler.contentWidth() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutY()) {
            PointD p1 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            PointD p2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom());
            if (!this.mYAxis.isInverted()) {
                yMin = (float)p2.y;
                yMax = (float)p1.y;
            } else {
                yMin = !this.mYAxis.isStartAtZeroEnabled() ? (float)Math.min(p1.y, p2.y) : 0.0f;
                yMax = (float)Math.max(p1.y, p2.y);
            }
        }
        this.computeAxisValues(yMin, yMax);
    }

    protected void computeAxisValues(float min, float max) {
        double intervalMagnitude;
        float yMin = min;
        float yMax = max;
        int labelCount = this.mYAxis.getLabelCount();
        double range = Math.abs(yMax - yMin);
        if (labelCount == 0 || range <= 0.0) {
            this.mYAxis.mEntries = new float[0];
            this.mYAxis.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        if (this.mYAxis.isShowOnlyMinMaxEnabled()) {
            this.mYAxis.mEntryCount = 2;
            this.mYAxis.mEntries = new float[2];
            this.mYAxis.mEntries[0] = yMin;
            this.mYAxis.mEntries[1] = yMax;
        } else {
            double f;
            double first = Math.ceil((double)yMin / interval) * interval;
            double last = Utils.nextUp(Math.floor((double)yMax / interval) * interval);
            int n = 0;
            for (f = first; f <= last; f += interval) {
                ++n;
            }
            this.mYAxis.mEntryCount = n;
            if (this.mYAxis.mEntries.length < n) {
                this.mYAxis.mEntries = new float[n];
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                this.mYAxis.mEntries[i] = (float)f;
                f += interval;
            }
        }
        this.mYAxis.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = new float[this.mYAxis.mEntryCount * 2];
        for (int i = 0; i < positions.length; i += 2) {
            positions[i + 1] = this.mYAxis.mEntries[i / 2];
        }
        this.mTrans.pointValuesToPixel(positions);
        this.mAxisPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisPaint.setColor(this.mYAxis.getTextColor());
        float xoffset = this.mYAxis.getXOffset();
        float yoffset = (float)Utils.calcTextHeight(this.mAxisPaint, "A") / 2.5f;
        YAxis.AxisDependency dependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.mYAxis.getLabelPosition();
        float xPos = 0.0f;
        if (dependency == YAxis.AxisDependency.LEFT) {
            if (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
                this.mAxisPaint.setTextAlign(Paint.Align.RIGHT);
                xPos = this.mViewPortHandler.offsetLeft() - xoffset;
            } else {
                this.mAxisPaint.setTextAlign(Paint.Align.LEFT);
                xPos = this.mViewPortHandler.offsetLeft() + xoffset;
            }
        } else if (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
            this.mAxisPaint.setTextAlign(Paint.Align.LEFT);
            xPos = this.mViewPortHandler.contentRight() + xoffset;
        } else {
            this.mAxisPaint.setTextAlign(Paint.Align.RIGHT);
            xPos = this.mViewPortHandler.contentRight() - xoffset;
        }
        this.drawYLabels(c, xPos, positions, yoffset);
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        } else {
            c.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    protected void drawYLabels(Canvas c, float fixedPosition, float[] positions, float offset) {
        for (int i = 0; i < this.mYAxis.mEntryCount; ++i) {
            String text = this.mYAxis.getFormattedLabel(i);
            if (!this.mYAxis.isDrawTopYLabelEntryEnabled() && i >= this.mYAxis.mEntryCount - 1) {
                return;
            }
            c.drawText(text, fixedPosition, positions[i * 2 + 1] + offset, this.mAxisPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mYAxis.isDrawGridLinesEnabled() || !this.mYAxis.isEnabled()) {
            return;
        }
        float[] position = new float[2];
        this.mGridPaint.setColor(this.mYAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
        for (int i = 0; i < this.mYAxis.mEntryCount; ++i) {
            position[1] = this.mYAxis.mEntries[i];
            this.mTrans.pointValuesToPixel(position);
            c.drawLine(this.mViewPortHandler.offsetLeft(), position[1], this.mViewPortHandler.contentRight(), position[1], this.mGridPaint);
        }
    }

    public void renderLimitLines(Canvas c) {
        ArrayList<LimitLine> limitLines = this.mYAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = new float[4];
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            pts[1] = l.getLimit();
            pts[3] = l.getLimit();
            this.mTrans.pointValuesToPixel(pts);
            pts[0] = this.mViewPortHandler.contentLeft();
            pts[2] = this.mViewPortHandler.contentRight();
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            c.drawLines(pts, this.mLimitLinePaint);
            String label = l.getLabel();
            if (label == null || label.equals("")) continue;
            float xOffset = Utils.convertDpToPixel(4.0f);
            float yOffset = l.getLineWidth() + (float)Utils.calcTextHeight(this.mLimitLinePaint, label) / 2.0f;
            this.mLimitLinePaint.setPathEffect(null);
            this.mLimitLinePaint.setColor(l.getTextColor());
            this.mLimitLinePaint.setStrokeWidth(0.5f);
            this.mLimitLinePaint.setTextSize(l.getTextSize());
            if (l.getLabelPosition() == LimitLine.LimitLabelPosition.POS_RIGHT) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                c.drawText(label, this.mViewPortHandler.contentRight() - xOffset, pts[1] - yOffset, this.mLimitLinePaint);
                continue;
            }
            this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
            c.drawText(label, this.mViewPortHandler.offsetLeft() + xOffset, pts[1] - yOffset, this.mLimitLinePaint);
        }
    }
}

