/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class XAxisRendererHorizontalBarChart
extends XAxisRendererBarChart {
    public XAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer trans, BarChart chart) {
        super(viewPortHandler, xAxis, trans, chart);
    }

    @Override
    public void computeAxis(float xValAverageLength, ArrayList<String> xValues) {
        this.mAxisPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mXAxis.getTextSize());
        this.mXAxis.setValues(xValues);
        String longest = this.mXAxis.getLongestLabel();
        this.mXAxis.mLabelWidth = (int)((float)Utils.calcTextWidth(this.mAxisPaint, longest) + this.mXAxis.getXOffset() * 3.5f);
        this.mXAxis.mLabelHeight = Utils.calcTextHeight(this.mAxisPaint, longest);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float xoffset = this.mXAxis.getXOffset();
        this.mAxisPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.mAxisPaint.setTextAlign(Paint.Align.LEFT);
            this.drawLabels(c, this.mViewPortHandler.contentRight() + xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.mAxisPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawLabels(c, this.mViewPortHandler.contentLeft() - xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.mAxisPaint.setTextAlign(Paint.Align.LEFT);
            this.drawLabels(c, this.mViewPortHandler.contentLeft() + xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.mAxisPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawLabels(c, this.mViewPortHandler.contentRight() - xoffset);
        } else {
            this.drawLabels(c, this.mViewPortHandler.contentLeft());
            this.drawLabels(c, this.mViewPortHandler.contentRight());
        }
    }

    @Override
    protected void drawLabels(Canvas c, float pos) {
        float[] position = new float[]{0.0f, 0.0f};
        BarData bd = (BarData)this.mChart.getData();
        int step = bd.getDataSetCount();
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[1] = (float)(i * step) + (float)i * bd.getGroupSpace() + bd.getGroupSpace() / 2.0f;
            if (step > 1) {
                position[1] = position[1] + ((float)step - 1.0f) / 2.0f;
            }
            this.mTrans.pointValuesToPixel(position);
            if (!this.mViewPortHandler.isInBoundsY(position[1])) continue;
            String label = this.mXAxis.getValues().get(i);
            c.drawText(label, pos, position[1] + (float)this.mXAxis.mLabelHeight / 2.0f, this.mAxisPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        BarData bd = (BarData)this.mChart.getData();
        int step = bd.getDataSetCount();
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[1] = (float)(i * step) + (float)i * bd.getGroupSpace() - 0.5f;
            this.mTrans.pointValuesToPixel(position);
            if (!this.mViewPortHandler.isInBoundsY(position[1])) continue;
            c.drawLine(this.mViewPortHandler.contentLeft(), position[1], this.mViewPortHandler.contentRight(), position[1], this.mGridPaint);
        }
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }
}

