/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.data.ScatterDataSet;
import com.github.mikephil.charting.interfaces.ScatterDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Transformer;
import java.util.ArrayList;

public class ScatterChartRenderer
extends DataRenderer {
    protected ScatterDataProvider mChart;

    public ScatterChartRenderer(ScatterDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void drawData(Canvas c) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (ScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, ScatterDataSet dataSet) {
        ArrayList entries = dataSet.getYVals();
        float shapeHalf = dataSet.getScatterShapeSize() / 2.0f;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float[] valuePoints = trans.generateTransformedValuesScatter(entries, this.mAnimator.getPhaseY());
        ScatterChart.ScatterShape shape = dataSet.getScatterShape();
        int j = 0;
        while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(valuePoints[j])) {
            if (j == 0 || this.mViewPortHandler.isInBoundsLeft(valuePoints[j - 1]) || this.mViewPortHandler.isInBoundsY(valuePoints[j + 1])) {
                this.mRenderPaint.setColor(dataSet.getColor(j));
                if (shape == ScatterChart.ScatterShape.SQUARE) {
                    c.drawRect(valuePoints[j] - shapeHalf, valuePoints[j + 1] - shapeHalf, valuePoints[j] + shapeHalf, valuePoints[j + 1] + shapeHalf, this.mRenderPaint);
                } else if (shape == ScatterChart.ScatterShape.CIRCLE) {
                    c.drawCircle(valuePoints[j], valuePoints[j + 1], shapeHalf, this.mRenderPaint);
                } else if (shape == ScatterChart.ScatterShape.CROSS) {
                    c.drawLine(valuePoints[j] - shapeHalf, valuePoints[j + 1], valuePoints[j] + shapeHalf, valuePoints[j + 1], this.mRenderPaint);
                    c.drawLine(valuePoints[j], valuePoints[j + 1] - shapeHalf, valuePoints[j], valuePoints[j + 1] + shapeHalf, this.mRenderPaint);
                } else if (shape == ScatterChart.ScatterShape.TRIANGLE) {
                    Path tri = new Path();
                    tri.moveTo(valuePoints[j], valuePoints[j + 1] - shapeHalf);
                    tri.lineTo(valuePoints[j] + shapeHalf, valuePoints[j + 1] + shapeHalf);
                    tri.lineTo(valuePoints[j] - shapeHalf, valuePoints[j + 1] + shapeHalf);
                    tri.close();
                    c.drawPath(tri, this.mRenderPaint);
                } else if (shape == ScatterChart.ScatterShape.CUSTOM) {
                    Path customShape = dataSet.getCustomScatterShape();
                    if (customShape == null) {
                        return;
                    }
                    trans.pathValueToPixel(customShape);
                    c.drawPath(customShape, this.mRenderPaint);
                }
            }
            j += 2;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getScatterData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            ArrayList dataSets = this.mChart.getScatterData().getDataSets();
            for (int i = 0; i < this.mChart.getScatterData().getDataSetCount(); ++i) {
                ScatterDataSet dataSet = (ScatterDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                ArrayList entries = dataSet.getYVals();
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesScatter(entries, this.mAnimator.getPhaseY());
                float shapeSize = dataSet.getScatterShapeSize();
                int j = 0;
                while ((float)j < (float)positions.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(positions[j])) {
                    if (j == 0 || this.mViewPortHandler.isInBoundsLeft(positions[j]) && this.mViewPortHandler.isInBoundsY(positions[j + 1])) {
                        float val = ((Entry)entries.get(j / 2)).getVal();
                        c.drawText(dataSet.getValueFormatter().getFormattedValue(val), positions[j], positions[j + 1] - shapeSize, this.mValuePaint);
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            ScatterDataSet set = (ScatterDataSet)this.mChart.getScatterData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null) continue;
            this.mHighlightPaint.setColor(set.getHighLightColor());
            int xIndex = indices[i].getXIndex();
            if ((float)xIndex > this.mChart.getXChartMax() * this.mAnimator.getPhaseX()) continue;
            float y = set.getYValForXIndex(xIndex) * this.mAnimator.getPhaseY();
            float[] pts = new float[]{xIndex, this.mChart.getYChartMax(), xIndex, this.mChart.getYChartMin(), 0.0f, y, this.mChart.getXChartMax(), y};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
            c.drawLines(pts, this.mHighlightPaint);
        }
    }
}

