/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.LineDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Transformer;
import java.util.ArrayList;

public class LineChartRenderer
extends DataRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;

    public LineChartRenderer(LineDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void drawData(Canvas c) {
        LineData lineData = this.mChart.getLineData();
        for (LineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, LineDataSet dataSet) {
        ArrayList<Entry> entries = dataSet.getYVals();
        if (entries.size() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
        if (dataSet.isDrawCubicEnabled()) {
            this.drawCubic(c, dataSet, entries);
        } else {
            this.drawLinear(c, dataSet, entries);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubic(Canvas c, LineDataSet dataSet, ArrayList<Entry> entries) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setColor(dataSet.getColor());
        float intensity = dataSet.getCubicIntensity();
        Path spline = new Path();
        ArrayList<CPoint> points = new ArrayList<CPoint>();
        for (Entry e : entries) {
            if (e == null) continue;
            points.add(new CPoint(e.getXIndex(), e.getVal()));
        }
        if (points.size() > 1) {
            int j = 0;
            while ((float)j < (float)points.size() * phaseX) {
                CPoint prev;
                CPoint next;
                CPoint point = (CPoint)points.get(j);
                if (j == 0) {
                    next = (CPoint)points.get(j + 1);
                    point.dx = (next.x - point.x) * intensity;
                    point.dy = (next.y - point.y) * intensity;
                } else if (j == points.size() - 1) {
                    prev = (CPoint)points.get(j - 1);
                    point.dx = (point.x - prev.x) * intensity;
                    point.dy = (point.y - prev.y) * intensity;
                } else {
                    next = (CPoint)points.get(j + 1);
                    CPoint prev2 = (CPoint)points.get(j - 1);
                    point.dx = (next.x - prev2.x) * intensity;
                    point.dy = (next.y - prev2.y) * intensity;
                }
                if (j == 0) {
                    spline.moveTo(point.x, point.y * phaseY);
                } else {
                    prev = (CPoint)points.get(j - 1);
                    spline.cubicTo(prev.x + prev.dx, (prev.y + prev.dy) * phaseY, point.x - point.dx, (point.y - point.dy) * phaseY, point.x, point.y * phaseY);
                }
                ++j;
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.drawCubicFill(dataSet, spline);
        } else {
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
        }
        trans.pathValueToPixel(spline);
        c.drawPath(spline, this.mRenderPaint);
    }

    protected void drawCubicFill(LineDataSet dataSet, Path spline) {
        float fillMin = this.mChart.getFillFormatter().getFillLinePosition(dataSet, this.mChart.getLineData(), this.mChart.getYChartMax(), this.mChart.getYChartMin());
        spline.lineTo((float)((Entry)dataSet.getYVals().get((int)((float)(dataSet.getYVals().size() - 1) * this.mAnimator.getPhaseX()))).getXIndex(), fillMin);
        spline.lineTo(this.mChart.getXChartMin(), fillMin);
        spline.close();
        this.mRenderPaint.setStyle(Paint.Style.FILL);
    }

    protected void drawLinear(Canvas c, LineDataSet dataSet, ArrayList<Entry> entries) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (dataSet.getColors() == null || dataSet.getColors().size() > 1) {
            float[] positions = trans.generateTransformedValuesLine(entries, phaseY);
            int j = 0;
            while ((float)j < (float)(positions.length - 2) * phaseX && this.mViewPortHandler.isInBoundsRight(positions[j])) {
                if (j == 0 || this.mViewPortHandler.isInBoundsLeft(positions[j - 1]) || this.mViewPortHandler.isInBoundsY(positions[j + 1])) {
                    this.mRenderPaint.setColor(dataSet.getColor(j / 2));
                    c.drawLine(positions[j], positions[j + 1], positions[j + 2], positions[j + 3], this.mRenderPaint);
                }
                j += 2;
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            Path line = this.generateLinePath(entries);
            trans.pathValueToPixel(line);
            c.drawPath(line, this.mRenderPaint);
        }
        this.mRenderPaint.setPathEffect(null);
        if (dataSet.isDrawFilledEnabled() && entries.size() > 0) {
            this.drawLinearFill(c, dataSet, entries, trans);
        }
    }

    protected void drawLinearFill(Canvas c, LineDataSet dataSet, ArrayList<Entry> entries, Transformer trans) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mRenderPaint.setColor(dataSet.getFillColor());
        this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
        Path filled = this.generateFilledPath(entries, this.mChart.getFillFormatter().getFillLinePosition(dataSet, this.mChart.getLineData(), this.mChart.getYChartMax(), this.mChart.getYChartMin()));
        trans.pathValueToPixel(filled);
        c.drawPath(filled, this.mRenderPaint);
        this.mRenderPaint.setAlpha(255);
    }

    private Path generateFilledPath(ArrayList<Entry> entries, float fillMin) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        Path filled = new Path();
        filled.moveTo((float)entries.get(0).getXIndex(), entries.get(0).getVal() * phaseY);
        int x = 1;
        while ((float)x < (float)entries.size() * phaseX) {
            Entry e = entries.get(x);
            filled.lineTo((float)e.getXIndex(), e.getVal() * phaseY);
            ++x;
        }
        filled.lineTo((float)entries.get((int)((float)(entries.size() - 1) * phaseX)).getXIndex(), fillMin);
        filled.lineTo((float)entries.get(0).getXIndex(), fillMin);
        filled.close();
        return filled;
    }

    private Path generateLinePath(ArrayList<Entry> entries) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        Path line = new Path();
        line.moveTo((float)entries.get(0).getXIndex(), entries.get(0).getVal() * phaseY);
        int x = 1;
        while ((float)x < (float)entries.size() * phaseX) {
            Entry e = entries.get(x);
            line.lineTo((float)e.getXIndex(), e.getVal() * phaseY);
            ++x;
        }
        return line;
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getLineData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            ArrayList dataSets = this.mChart.getLineData().getDataSets();
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                LineDataSet dataSet = (LineDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleSize() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                ArrayList entries = dataSet.getYVals();
                float[] positions = trans.generateTransformedValuesLine(entries, this.mAnimator.getPhaseY());
                int j = 0;
                while ((float)j < (float)positions.length * this.mAnimator.getPhaseX()) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (this.mViewPortHandler.isInBoundsLeft(x) && this.mViewPortHandler.isInBoundsY(y)) {
                        float val = ((Entry)entries.get(j / 2)).getVal();
                        c.drawText(dataSet.getValueFormatter().getFormattedValue(val), x, y - (float)valOffset, this.mValuePaint);
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawCircles(c);
    }

    protected void drawCircles(Canvas c) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        ArrayList dataSets = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < this.mChart.getLineData().getDataSetCount(); ++i) {
            LineDataSet dataSet = (LineDataSet)dataSets.get(i);
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            if (!dataSet.isDrawCirclesEnabled()) continue;
            ArrayList entries = dataSet.getYVals();
            float[] positions = trans.generateTransformedValuesLine(entries, this.mAnimator.getPhaseY());
            int j = 0;
            while ((float)j < (float)positions.length * this.mAnimator.getPhaseX()) {
                this.mRenderPaint.setColor(dataSet.getCircleColor(j / 2));
                float x = positions[j];
                float y = positions[j + 1];
                if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                if (this.mViewPortHandler.isInBoundsLeft(x) && this.mViewPortHandler.isInBoundsY(y)) {
                    c.drawCircle(x, y, dataSet.getCircleSize(), this.mRenderPaint);
                    c.drawCircle(x, y, dataSet.getCircleSize() / 2.0f, this.mCirclePaintInner);
                }
                j += 2;
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            LineDataSet set = (LineDataSet)this.mChart.getLineData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null) continue;
            this.mHighlightPaint.setColor(set.getHighLightColor());
            int xIndex = indices[i].getXIndex();
            if ((float)xIndex > this.mChart.getXChartMax() * this.mAnimator.getPhaseX()) continue;
            float y = set.getYValForXIndex(xIndex) * this.mAnimator.getPhaseY();
            float[] pts = new float[]{xIndex, this.mChart.getYChartMax(), xIndex, this.mChart.getYChartMin(), 0.0f, y, this.mChart.getXChartMax(), y};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
            c.drawLines(pts, this.mHighlightPaint);
        }
    }

    protected class CPoint {
        public float x = 0.0f;
        public float y = 0.0f;
        public float dx = 0.0f;
        public float dy = 0.0f;

        public CPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

