/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint = new Paint(1);
    protected Paint mLegendFormPaint;

    public LegendRenderer(ViewPortHandler viewPortHandler) {
        super(viewPortHandler);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public Legend computeLegend(ChartData<?> data, Legend legend) {
        Typeface tf;
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < data.getDataSetCount(); ++i) {
            int j;
            Object dataSet = data.getDataSetByIndex(i);
            ArrayList<Integer> clrs = ((DataSet)dataSet).getColors();
            int entryCount = ((DataSet)dataSet).getEntryCount();
            if (dataSet instanceof BarDataSet && ((BarDataSet)dataSet).getStackSize() > 1) {
                BarDataSet bds = (BarDataSet)dataSet;
                String[] sLabels = bds.getStackLabels();
                for (j = 0; j < clrs.size() && j < bds.getStackSize(); ++j) {
                    labels.add(sLabels[j % sLabels.length]);
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(bds.getLabel());
                continue;
            }
            if (dataSet instanceof PieDataSet) {
                ArrayList<String> xVals = data.getXVals();
                PieDataSet pds = (PieDataSet)dataSet;
                for (j = 0; j < clrs.size() && j < entryCount && j < xVals.size(); ++j) {
                    labels.add(xVals.get(j));
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(pds.getLabel());
                continue;
            }
            for (int j2 = 0; j2 < clrs.size() && j2 < entryCount; ++j2) {
                if (j2 < clrs.size() - 1 && j2 < entryCount - 1) {
                    labels.add(null);
                } else {
                    String label = ((DataSet)data.getDataSetByIndex(i)).getLabel();
                    labels.add(label);
                }
                colors.add(clrs.get(j2));
            }
        }
        Legend l = new Legend(colors, labels);
        if (legend != null) {
            l.apply(legend);
        }
        if ((tf = l.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(l.getTextSize());
        this.mLegendLabelPaint.setColor(l.getTextColor());
        l.calculateDimensions(this.mLegendLabelPaint);
        return l;
    }

    public void renderLegend(Canvas c, Legend legend) {
        if (legend == null || !legend.isEnabled()) {
            return;
        }
        Typeface tf = legend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(legend.getTextSize());
        this.mLegendLabelPaint.setColor(legend.getTextColor());
        String[] labels = legend.getLegendLabels();
        float formSize = legend.getFormSize();
        float formTextSpaceAndForm = legend.getFormToTextSpace() + formSize;
        float stackSpace = legend.getStackSpace();
        float textDrop = ((float)Utils.calcTextHeight(this.mLegendLabelPaint, "AQJ") + formSize) / 2.0f;
        float stack = 0.0f;
        boolean wasStacked = false;
        float yoffset = legend.getYOffset();
        float xoffset = legend.getXOffset();
        switch (legend.getPosition()) {
            case BELOW_CHART_LEFT: {
                float posX = this.mViewPortHandler.contentLeft() + xoffset;
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX, posY - legend.mTextHeightMax / 2.0f, i, legend);
                    if (labels[i] != null) {
                        if (legend.getColors()[i] != -2) {
                            posX += formTextSpaceAndForm;
                        }
                        this.drawLabel(c, posX, posY, legend.getLabel(i));
                        posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + legend.getXEntrySpace();
                        continue;
                    }
                    posX += formSize + stackSpace;
                }
                break;
            }
            case BELOW_CHART_RIGHT: {
                float posX = this.mViewPortHandler.contentRight() - xoffset;
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                for (int i = labels.length - 1; i >= 0; --i) {
                    if (labels[i] != null) {
                        this.drawLabel(c, posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + legend.getXEntrySpace(), posY, legend.getLabel(i));
                        if (legend.getColors()[i] != -2) {
                            posX -= formTextSpaceAndForm;
                        }
                    } else {
                        posX -= stackSpace + formSize;
                    }
                    this.drawForm(c, posX, posY - legend.mTextHeightMax / 2.0f, i, legend);
                }
                break;
            }
            case RIGHT_OF_CHART: {
                float posX = this.mViewPortHandler.getChartWidth() - legend.mTextWidthMax - xoffset;
                float posY = this.mViewPortHandler.contentTop() + yoffset;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX + stack, posY, i, legend);
                    if (labels[i] != null) {
                        if (!wasStacked) {
                            float x = posX;
                            if (legend.getColors()[i] != -2) {
                                x += formTextSpaceAndForm;
                            }
                            this.drawLabel(c, x, posY + legend.mTextHeightMax / 2.0f, legend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, posX, (posY += legend.mTextHeightMax * 3.0f) - legend.mTextHeightMax, legend.getLabel(i));
                        }
                        posY += legend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            case RIGHT_OF_CHART_CENTER: {
                float posX = this.mViewPortHandler.getChartWidth() - legend.mTextWidthMax - xoffset;
                float posY = this.mViewPortHandler.getChartHeight() / 2.0f - legend.mNeededHeight / 2.0f;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX + stack, posY, i, legend);
                    if (labels[i] != null) {
                        if (!wasStacked) {
                            float x = posX;
                            if (legend.getColors()[i] != -2) {
                                x += formTextSpaceAndForm;
                            }
                            this.drawLabel(c, x, posY + legend.mTextHeightMax / 2.0f, legend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, posX, (posY += legend.mTextHeightMax * 3.0f) - legend.mTextHeightMax, legend.getLabel(i));
                        }
                        posY += legend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            case BELOW_CHART_CENTER: {
                float posX = this.mViewPortHandler.getChartWidth() / 2.0f - legend.mNeededWidth / 2.0f;
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX, posY - legend.mTextHeightMax / 2.0f, i, legend);
                    if (labels[i] != null) {
                        if (legend.getColors()[i] != -2) {
                            posX += formTextSpaceAndForm;
                        }
                        this.drawLabel(c, posX, posY, legend.getLabel(i));
                        posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + legend.getXEntrySpace();
                        continue;
                    }
                    posX += formSize + stackSpace;
                }
                break;
            }
            case PIECHART_CENTER: {
                float posX = this.mViewPortHandler.getChartWidth() / 2.0f - legend.mTextWidthMax / 2.0f;
                float posY = this.mViewPortHandler.getChartHeight() / 2.0f - legend.mNeededHeight / 2.0f;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX + stack, posY, i, legend);
                    if (labels[i] != null) {
                        if (!wasStacked) {
                            float x = posX;
                            if (legend.getColors()[i] != -2) {
                                x += formTextSpaceAndForm;
                            }
                            this.drawLabel(c, x, posY + legend.mTextHeightMax / 2.0f, legend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, posX, (posY += legend.mTextHeightMax * 3.0f) - legend.mTextHeightMax, legend.getLabel(i));
                        }
                        posY += legend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            case RIGHT_OF_CHART_INSIDE: {
                float posX = this.mViewPortHandler.getChartWidth() - legend.mTextWidthMax - xoffset;
                float posY = this.mViewPortHandler.contentTop() + yoffset;
                for (int i = 0; i < labels.length; ++i) {
                    this.drawForm(c, posX + stack, posY, i, legend);
                    if (labels[i] != null) {
                        if (!wasStacked) {
                            float x = posX;
                            if (legend.getColors()[i] != -2) {
                                x += formTextSpaceAndForm;
                            }
                            this.drawLabel(c, x, posY + legend.mTextHeightMax / 2.0f, legend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, posX, (posY += legend.mTextHeightMax * 3.0f) - legend.mTextHeightMax, legend.getLabel(i));
                        }
                        posY += legend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas c, float x, float y, int index, Legend legend) {
        if (legend.getColors()[index] == -2) {
            return;
        }
        this.mLegendFormPaint.setColor(legend.getColors()[index]);
        float formsize = legend.getFormSize();
        float half = formsize / 2.0f;
        switch (legend.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y, half, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y - half, x + formsize, y + half, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                c.drawLine(x, y, x + formsize, y, this.mLegendFormPaint);
            }
        }
    }

    protected void drawLabel(Canvas c, float x, float y, String label) {
        c.drawText(label, x, y, this.mLegendLabelPaint);
    }
}

