/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import java.util.ArrayList;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    private float mYOffset = 0.0f;

    public HorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    protected void drawDataSet(Canvas c, BarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float space = this.mChart.getBarData().getGroupSpace();
        boolean noStacks = dataSet.getStackSize() == 1;
        ArrayList entries = dataSet.getYVals();
        int j = 0;
        while ((float)j < (float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()) {
            BarEntry e = (BarEntry)entries.get(j);
            float x = (float)(e.getXIndex() + j * (this.mChart.getBarData().getDataSetCount() - 1) + index) + space * (float)j + space / 2.0f;
            float y = e.getVal();
            if (noStacks) {
                this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                if (!this.mViewPortHandler.isInBoundsTop(this.mBarRect.bottom)) break;
                if (this.mViewPortHandler.isInBoundsBottom(this.mBarRect.top)) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    c.drawRect(this.mBarRect, this.mRenderPaint);
                }
            } else {
                float[] vals = e.getVals();
                if (vals == null) {
                    this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(0));
                    c.drawRect(this.mBarRect, this.mRenderPaint);
                } else {
                    float all = e.getVal();
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    for (int k = 0; k < vals.length; ++k) {
                        this.prepareBar(x, vals[k] + (all -= vals[k]), dataSet.getBarSpace(), trans);
                        this.mRenderPaint.setColor(dataSet.getColor(k));
                        c.drawRect(this.mBarRect, this.mRenderPaint);
                    }
                }
                if (!this.mViewPortHandler.isInBoundsTop(this.mBarRect.bottom)) break;
            }
            ++j;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        block10: {
            if (!this.passesCheck()) break block10;
            ArrayList dataSets = this.mChart.getBarData().getDataSets();
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            negOffset = drawValueAboveBar ? -Utils.convertDpToPixel(5.0f) : Utils.convertDpToPixel(5.0f);
            float f = posOffset = drawValueAboveBar ? Utils.convertDpToPixel(5.0f) : -Utils.convertDpToPixel(5.0f);
            if (drawValueAboveBar) {
                this.mValuePaint.setTextAlign(Paint.Align.LEFT);
            } else {
                this.mValuePaint.setTextAlign(Paint.Align.RIGHT);
            }
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                int j;
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                this.mYOffset = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                ValueFormatter formatter = dataSet.getValueFormatter();
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                ArrayList<BarEntry> entries = dataSet.getYVals();
                float[] valuePoints = this.getTransformedValues(trans, entries, i);
                if (!this.mChart.isDrawValuesForWholeStackEnabled()) {
                    j = 0;
                    while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX()) {
                        if (this.mViewPortHandler.isInBoundsX(valuePoints[j])) {
                            if (!this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) continue block0;
                            if (this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) {
                                float val = entries.get(j / 2).getVal();
                                this.drawValue(c, val, valuePoints[j] + (val >= 0.0f ? posOffset : negOffset), valuePoints[j + 1], formatter);
                            }
                        }
                        j += 2;
                    }
                    continue;
                }
                j = 0;
                while ((float)j < (float)(valuePoints.length - 1) * this.mAnimator.getPhaseX()) {
                    block12: {
                        int k;
                        float[] vals;
                        BarEntry e;
                        block11: {
                            e = entries.get(j / 2);
                            vals = e.getVals();
                            if (vals != null) break block11;
                            if (!this.mViewPortHandler.isInBoundsX(valuePoints[j])) break block12;
                            if (!this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) continue block0;
                            if (!this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) break block12;
                            this.drawValue(c, e.getVal(), valuePoints[j] + (e.getVal() >= 0.0f ? posOffset : negOffset), valuePoints[j + 1], formatter);
                            break block12;
                        }
                        float[] transformed = new float[vals.length * 2];
                        int cnt = 0;
                        float add = e.getVal();
                        for (k = 0; k < transformed.length; k += 2) {
                            transformed[k] = (vals[cnt] + (add -= vals[cnt])) * this.mAnimator.getPhaseY();
                            ++cnt;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float x = transformed[k] + (vals[k / 2] >= 0.0f ? posOffset : negOffset);
                            float y = valuePoints[j + 1];
                            if (!this.mViewPortHandler.isInBoundsX(x)) continue;
                            if (!this.mViewPortHandler.isInBoundsTop(y)) break;
                            if (!this.mViewPortHandler.isInBoundsBottom(y)) continue;
                            this.drawValue(c, vals[k / 2], x, y, formatter);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    protected void prepareBar(float x, float y, float barspace, Transformer trans) {
        float spaceHalf = barspace / 2.0f;
        float top = x - 0.5f + spaceHalf;
        float bottom = x + 0.5f - spaceHalf;
        float left = y >= 0.0f ? y : 0.0f;
        float right = y <= 0.0f ? y : 0.0f;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixelHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mBarShadow.set(this.mViewPortHandler.contentLeft(), this.mBarRect.top, this.mViewPortHandler.contentRight(), this.mBarRect.bottom);
        }
    }

    @Override
    protected void prepareBarHighlight(float x, float y, float barspace, float from, Transformer trans) {
        float spaceHalf = barspace / 2.0f;
        float top = x - 0.5f + spaceHalf;
        float bottom = x + 0.5f - spaceHalf;
        float left = y >= from ? y : from;
        float right = y <= from ? y : from;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixel(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public float[] getTransformedValues(Transformer trans, ArrayList<BarEntry> entries, int dataSetIndex) {
        return trans.generateTransformedValuesHorizontalBarChart(entries, dataSetIndex, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    @Override
    protected void drawValue(Canvas c, float val, float xPos, float yPos, ValueFormatter formatter) {
        super.drawValue(c, val, xPos, yPos + this.mYOffset, formatter);
    }

    @Override
    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

