/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.interfaces.CandleDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class CandleStickChartRenderer
extends DataRenderer {
    protected CandleDataProvider mChart;

    public CandleStickChartRenderer(CandleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void drawData(Canvas c) {
        CandleData candleData = this.mChart.getCandleData();
        for (CandleDataSet set : candleData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, CandleDataSet dataSet) {
        float[] shadowPoints = new float[4];
        float[] bodyPoints = new float[4];
        ArrayList entries = dataSet.getYVals();
        this.mRenderPaint.setStrokeWidth(dataSet.getShadowWidth());
        int j = 0;
        while ((float)j < (float)entries.size() * this.mAnimator.getPhaseX()) {
            this.mRenderPaint.setColor(dataSet.getColor(j));
            CandleEntry e = (CandleEntry)entries.get(j);
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            this.transformShadow(shadowPoints, e, trans);
            this.transformBody(bodyPoints, e, dataSet.getBodySpace(), trans);
            float xShadow = shadowPoints[0];
            float leftBody = bodyPoints[0];
            float rightBody = bodyPoints[2];
            float high = shadowPoints[1];
            float low = shadowPoints[3];
            float open = bodyPoints[1];
            float close = bodyPoints[3];
            if (!this.mViewPortHandler.isInBoundsRight(leftBody)) break;
            if (j == 0 || this.mViewPortHandler.isInBoundsLeft(rightBody) || this.mViewPortHandler.isInBoundsTop(low) || this.mViewPortHandler.isInBoundsBottom(high)) {
                c.drawLine(xShadow, low, xShadow, high, this.mRenderPaint);
                if (open > close) {
                    this.mRenderPaint.setStyle(Paint.Style.FILL);
                    c.drawRect(leftBody, close, rightBody, open, this.mRenderPaint);
                } else {
                    this.mRenderPaint.setStyle(Paint.Style.STROKE);
                    c.drawRect(leftBody, open, rightBody, close, this.mRenderPaint);
                }
            }
            ++j;
        }
    }

    private void transformBody(float[] bodyPoints, CandleEntry e, float bodySpace, Transformer trans) {
        float phase = this.mAnimator.getPhaseY();
        bodyPoints[0] = (float)e.getXIndex() - 0.5f + bodySpace;
        bodyPoints[1] = e.getClose() * phase;
        bodyPoints[2] = (float)e.getXIndex() + 0.5f - bodySpace;
        bodyPoints[3] = e.getOpen() * phase;
        trans.pointValuesToPixel(bodyPoints);
    }

    private void transformShadow(float[] shadowPoints, CandleEntry e, Transformer trans) {
        float phase = this.mAnimator.getPhaseY();
        shadowPoints[0] = e.getXIndex();
        shadowPoints[1] = e.getHigh() * phase;
        shadowPoints[2] = e.getXIndex();
        shadowPoints[3] = e.getLow() * phase;
        trans.pointValuesToPixel(shadowPoints);
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getCandleData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            ArrayList dataSets = this.mChart.getCandleData().getDataSets();
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                CandleDataSet dataSet = (CandleDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                ArrayList<CandleEntry> entries = dataSet.getYVals();
                float[] positions = trans.generateTransformedValuesCandle(entries, this.mAnimator.getPhaseY());
                float yOffset = Utils.convertDpToPixel(5.0f);
                int j = 0;
                while ((float)j < (float)positions.length * this.mAnimator.getPhaseX()) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (this.mViewPortHandler.isInBoundsLeft(x) && this.mViewPortHandler.isInBoundsY(y)) {
                        float val = entries.get(j / 2).getHigh();
                        c.drawText(dataSet.getValueFormatter().getFormattedValue(val), x, y - yOffset, this.mValuePaint);
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            int xIndex = indices[i].getXIndex();
            CandleDataSet set = (CandleDataSet)this.mChart.getCandleData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null) continue;
            this.mHighlightPaint.setColor(set.getHighLightColor());
            CandleEntry e = (CandleEntry)set.getEntryForXIndex(xIndex);
            if (e == null) continue;
            float low = e.getLow() * this.mAnimator.getPhaseY();
            float high = e.getHigh() * this.mAnimator.getPhaseY();
            float min = this.mChart.getYChartMin();
            float max = this.mChart.getYChartMax();
            float[] vertPts = new float[]{(float)xIndex - 0.5f, max, (float)xIndex - 0.5f, min, (float)xIndex + 0.5f, max, (float)xIndex + 0.5f, min};
            float[] horPts = new float[]{0.0f, low, this.mChart.getXChartMax(), low, 0.0f, high, this.mChart.getXChartMax(), high};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(vertPts);
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(horPts);
            c.drawLines(vertPts, this.mHighlightPaint);
            c.drawLines(horPts, this.mHighlightPaint);
        }
    }
}

