/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BarLineScatterCandleDataSet;
import com.github.mikephil.charting.data.DataSet;
import java.util.ArrayList;

public class BarDataSet
extends BarLineScatterCandleDataSet<BarEntry> {
    private float mBarSpace = 0.15f;
    private int mStackSize = 1;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private int mHighLightAlpha = 120;
    private int mEntryCountStacks = 0;
    private String[] mStackLabels = new String[]{"Stack"};

    public BarDataSet(ArrayList<BarEntry> yVals, String label) {
        super(yVals, label);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.calcStackSize(yVals);
        this.calcEntryCountIncludingStacks(yVals);
    }

    @Override
    public DataSet<BarEntry> copy() {
        ArrayList<BarEntry> yVals = new ArrayList<BarEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((BarEntry)this.mYVals.get(i)).copy());
        }
        BarDataSet copied = new BarDataSet(yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mStackSize = this.mStackSize;
        copied.mBarSpace = this.mBarSpace;
        copied.mBarShadowColor = this.mBarShadowColor;
        copied.mStackLabels = this.mStackLabels;
        copied.mHighLightColor = this.mHighLightColor;
        copied.mHighLightAlpha = this.mHighLightAlpha;
        return copied;
    }

    private void calcEntryCountIncludingStacks(ArrayList<BarEntry> yVals) {
        this.mEntryCountStacks = 0;
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getVals();
            if (vals == null) {
                ++this.mEntryCountStacks;
                continue;
            }
            this.mEntryCountStacks += vals.length;
        }
    }

    private void calcStackSize(ArrayList<BarEntry> yVals) {
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getVals();
            if (vals == null || vals.length <= this.mStackSize) continue;
            this.mStackSize = vals.length;
        }
    }

    public int getStackSize() {
        return this.mStackSize;
    }

    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    public int getEntryCountStacks() {
        return this.mEntryCountStacks;
    }

    public float getBarSpacePercent() {
        return this.mBarSpace * 100.0f;
    }

    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setBarSpacePercent(float percent) {
        this.mBarSpace = percent / 100.0f;
    }

    public void setBarShadowColor(int color) {
        this.mBarShadowColor = color;
    }

    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public void setHighLightAlpha(int alpha) {
        this.mHighLightAlpha = alpha;
    }

    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    public void setStackLabels(String[] labels) {
        this.mStackLabels = labels;
    }

    public String[] getStackLabels() {
        return this.mStackLabels;
    }
}

