/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.interfaces.CandleDataProvider;
import com.github.mikephil.charting.interfaces.LineDataProvider;
import com.github.mikephil.charting.interfaces.ScatterDataProvider;
import com.github.mikephil.charting.renderer.CombinedChartRenderer;
import com.github.mikephil.charting.utils.FillFormatter;

public class CombinedChart
extends BarLineChartBase<CombinedData>
implements LineDataProvider,
BarDataProvider,
ScatterDataProvider,
CandleDataProvider {
    private FillFormatter mFillFormatter;

    public CombinedChart(Context context) {
        super(context);
    }

    public CombinedChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CombinedChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mFillFormatter = new BarLineChartBase.DefaultFillFormatter();
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        if (this.getBarData() != null) {
            this.mXChartMin = -0.5f;
            this.mXChartMax = (float)((CombinedData)this.mData).getXVals().size() - 0.5f;
            this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        }
    }

    @Override
    public void setData(CombinedData data) {
        super.setData(data);
        this.mRenderer = new CombinedChartRenderer(this, this.mAnimator, this.mViewPortHandler);
    }

    @Override
    public void setFillFormatter(FillFormatter formatter) {
        if (formatter == null) {
            formatter = new BarLineChartBase.DefaultFillFormatter();
        } else {
            this.mFillFormatter = formatter;
        }
    }

    @Override
    public FillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }

    @Override
    public LineData getLineData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getLineData();
    }

    @Override
    public BarData getBarData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBarData();
    }

    @Override
    public ScatterData getScatterData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getScatterData();
    }

    @Override
    public CandleData getCandleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getCandleData();
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return false;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return true;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return false;
    }

    @Override
    public boolean isDrawValuesForWholeStackEnabled() {
        return false;
    }
}

