/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;
import com.github.mikephil.charting.utils.Highlight;

public class BarChart
extends BarLineChartBase<BarData>
implements BarDataProvider {
    private boolean mDrawHighlightArrow = false;
    private boolean mDrawValueAboveBar = true;
    private boolean mDrawValuesForWholeStack = true;
    protected boolean mDrawBarShadow = true;

    public BarChart(Context context) {
        super(context);
    }

    public BarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new BarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mXAxisRenderer = new XAxisRendererBarChart(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer, this);
        this.mXChartMin = -0.5f;
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        this.mDeltaX += 0.5f;
        this.mDeltaX *= (float)((BarData)this.mData).getDataSetCount();
        int maxEntry = 0;
        for (int i = 0; i < ((BarData)this.mData).getDataSetCount(); ++i) {
            Object set = ((BarData)this.mData).getDataSetByIndex(i);
            if (maxEntry >= ((DataSet)set).getEntryCount()) continue;
            maxEntry = ((DataSet)set).getEntryCount();
        }
        float groupSpace = ((BarData)this.mData).getGroupSpace();
        this.mDeltaX += (float)maxEntry * groupSpace;
        this.mXChartMax = this.mDeltaX - this.mXChartMin;
    }

    @Override
    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.mDataNotSet || this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        float[] pts = new float[]{x, y};
        this.mLeftAxisTransformer.pixelsToValue(pts);
        if (pts[0] < this.mXChartMin || pts[0] > this.mXChartMax) {
            return null;
        }
        return this.getHighlight(pts[0], pts[1]);
    }

    protected Highlight getHighlight(double xPosition, double yPosition) {
        int setCount = ((BarData)this.mData).getDataSetCount();
        int valCount = ((BarData)this.mData).getXValCount();
        int dataSetIndex = 0;
        int xIndex = 0;
        if (!((BarData)this.mData).isGrouped()) {
            xIndex = (int)Math.round(xPosition);
            if (xIndex < 0) {
                xIndex = 0;
            } else if (xIndex >= valCount) {
                xIndex = valCount - 1;
            }
        } else {
            int steps = (int)((float)xPosition / ((float)setCount + ((BarData)this.mData).getGroupSpace()));
            float groupSpaceSum = ((BarData)this.mData).getGroupSpace() * (float)steps;
            float baseNoSpace = (float)xPosition - groupSpaceSum;
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("base: " + xPosition + ", steps: " + steps + ", groupSpaceSum: " + groupSpaceSum + ", baseNoSpace: " + baseNoSpace));
            }
            dataSetIndex = (int)baseNoSpace % setCount;
            xIndex = (int)baseNoSpace / setCount;
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("xIndex: " + xIndex + ", dataSet: " + dataSetIndex));
            }
            if (xIndex < 0) {
                xIndex = 0;
                dataSetIndex = 0;
            } else if (xIndex >= valCount) {
                xIndex = valCount - 1;
                dataSetIndex = setCount - 1;
            }
            if (dataSetIndex < 0) {
                dataSetIndex = 0;
            } else if (dataSetIndex >= setCount) {
                dataSetIndex = setCount - 1;
            }
        }
        if (!((BarDataSet)((BarData)this.mData).getDataSetByIndex(dataSetIndex)).isStacked()) {
            return new Highlight(xIndex, dataSetIndex);
        }
        return this.getStackedHighlight(xIndex, dataSetIndex, yPosition);
    }

    protected Highlight getStackedHighlight(int xIndex, int dataSet, double yValue) {
        BarEntry entry = (BarEntry)((BarDataSet)((BarData)this.mData).getDataSetByIndex(dataSet)).getEntryForXIndex(xIndex);
        if (entry != null) {
            int stackIndex = entry.getClosestIndexAbove((float)yValue);
            Highlight h = new Highlight(xIndex, dataSet, stackIndex);
            return h;
        }
        return null;
    }

    public RectF getBarBounds(BarEntry e) {
        BarDataSet set = (BarDataSet)((BarData)this.mData).getDataSetForEntry(e);
        if (set == null) {
            return null;
        }
        float barspace = set.getBarSpace();
        float y = e.getVal();
        float x = e.getXIndex();
        float barWidth = 0.5f;
        float spaceHalf = barspace / 2.0f;
        float left = x - barWidth + spaceHalf;
        float right = x + barWidth - spaceHalf;
        float top = y >= 0.0f ? y : 0.0f;
        float bottom = y <= 0.0f ? y : 0.0f;
        RectF bounds = new RectF(left, top, right, bottom);
        this.getTransformer(set.getAxisDependency()).rectValueToPixel(bounds);
        return bounds;
    }

    public void setDrawHighlightArrow(boolean enabled) {
        this.mDrawHighlightArrow = enabled;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return this.mDrawHighlightArrow;
    }

    public void setDrawValueAboveBar(boolean enabled) {
        this.mDrawValueAboveBar = enabled;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    public void setDrawValuesForWholeStack(boolean enabled) {
        this.mDrawValuesForWholeStack = enabled;
    }

    @Override
    public boolean isDrawValuesForWholeStackEnabled() {
        return this.mDrawValuesForWholeStack;
    }

    public void setDrawBarShadow(boolean enabled) {
        this.mDrawBarShadow = enabled;
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    public BarData getBarData() {
        return (BarData)this.mData;
    }
}

