/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.data.BarLineScatterCandleData;
import com.github.mikephil.charting.data.BarLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;

public class BarLineChartTouchListener<T extends BarLineChartBase<? extends BarLineScatterCandleData<? extends BarLineScatterCandleRadarDataSet<? extends Entry>>>>
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private Matrix mMatrix = new Matrix();
    private Matrix mSavedMatrix = new Matrix();
    private PointF mTouchStartPoint = new PointF();
    private PointF mTouchPointCenter = new PointF();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int X_ZOOM = 2;
    private static final int Y_ZOOM = 3;
    private static final int PINCH_ZOOM = 4;
    private static final int POST_ZOOM = 5;
    private int mTouchMode = 0;
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private float mSavedDist = 1.0f;
    private Highlight mLastHighlighted;
    private T mChart;
    private GestureDetector mGestureDetector;

    public BarLineChartTouchListener(T chart, Matrix start) {
        this.mChart = chart;
        this.mMatrix = start;
        this.mGestureDetector = new GestureDetector(chart.getContext(), (GestureDetector.OnGestureListener)this);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        if (this.mTouchMode == 0) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (!((BarLineChartBase)((Object)this.mChart)).isDragScaleEnabled()) {
            return true;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.saveTouchStart(event);
                break;
            }
            case 5: {
                if (event.getPointerCount() != 2) break;
                this.saveTouchStart(event);
                this.mSavedXDist = BarLineChartTouchListener.getXDist(event);
                this.mSavedYDist = BarLineChartTouchListener.getYDist(event);
                this.mSavedDist = BarLineChartTouchListener.spacing(event);
                if (this.mSavedDist > 10.0f) {
                    this.mTouchMode = ((BarLineChartBase)((Object)this.mChart)).isPinchZoomEnabled() ? 4 : (this.mSavedXDist > this.mSavedYDist ? 2 : 3);
                }
                BarLineChartTouchListener.midPoint(this.mTouchPointCenter, event);
                break;
            }
            case 2: {
                if (this.mTouchMode == 1) {
                    this.performDrag(event);
                    break;
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) {
                    this.performZoom(event);
                    break;
                }
                if (this.mTouchMode != 0 && (this.mTouchMode == 1 || event.getPointerCount() != 3) || !(Math.abs(BarLineChartTouchListener.distance(event.getX(), this.mTouchStartPoint.x, event.getY(), this.mTouchStartPoint.y)) > 25.0f)) break;
                this.mTouchMode = 1;
                break;
            }
            case 1: {
                this.mTouchMode = 0;
                break;
            }
            case 6: {
                this.mTouchMode = 5;
            }
        }
        this.mMatrix = ((BarLineChartBase)((Object)this.mChart)).refreshTouch(this.mMatrix);
        return true;
    }

    private void saveTouchStart(MotionEvent event) {
        this.mSavedMatrix.set(this.mMatrix);
        this.mTouchStartPoint.set(event.getX(), event.getY());
    }

    private void performDrag(MotionEvent event) {
        this.mMatrix.set(this.mSavedMatrix);
        PointF dragPoint = new PointF(event.getX(), event.getY());
        if (!((BarLineChartBase)((Object)this.mChart)).isInvertYAxisEnabled()) {
            this.mMatrix.postTranslate(dragPoint.x - this.mTouchStartPoint.x, dragPoint.y - this.mTouchStartPoint.y);
        } else {
            this.mMatrix.postTranslate(dragPoint.x - this.mTouchStartPoint.x, -(dragPoint.y - this.mTouchStartPoint.y));
        }
    }

    private void performZoom(MotionEvent event) {
        float totalDist = BarLineChartTouchListener.spacing(event);
        if (totalDist > 10.0f) {
            PointF t = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
            if (this.mTouchMode == 4) {
                float scale = totalDist / this.mSavedDist;
                this.mMatrix.set(this.mSavedMatrix);
                this.mMatrix.postScale(scale, scale, t.x, t.y);
            } else if (this.mTouchMode == 2) {
                float xDist = BarLineChartTouchListener.getXDist(event);
                float scaleX = xDist / this.mSavedXDist;
                this.mMatrix.set(this.mSavedMatrix);
                this.mMatrix.postScale(scaleX, 1.0f, t.x, t.y);
            } else if (this.mTouchMode == 3) {
                float yDist = BarLineChartTouchListener.getYDist(event);
                float scaleY = yDist / this.mSavedYDist;
                this.mMatrix.set(this.mSavedMatrix);
                this.mMatrix.postScale(1.0f, scaleY, t.x, t.y);
            }
        }
    }

    private static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    private static void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    private static float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float getXDist(MotionEvent e) {
        float x = Math.abs(e.getX(0) - e.getX(1));
        return x;
    }

    private static float getYDist(MotionEvent e) {
        float y = Math.abs(e.getY(0) - e.getY(1));
        return y;
    }

    public PointF getTrans(float x, float y) {
        float xTrans = x - ((Chart)((Object)this.mChart)).getOffsetLeft();
        float yTrans = 0.0f;
        yTrans = !((BarLineChartBase)((Object)this.mChart)).isInvertYAxisEnabled() ? -((float)this.mChart.getMeasuredHeight() - y - ((Chart)((Object)this.mChart)).getOffsetBottom()) : -(y - ((Chart)((Object)this.mChart)).getOffsetTop());
        return new PointF(xTrans, yTrans);
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (((BarLineChartBase)((Object)this.mChart)).isDoubleTapToZoomEnabled()) {
            PointF trans = this.getTrans(e.getX(), e.getY());
            ((BarLineChartBase)((Object)this.mChart)).zoomIn(trans.x, trans.y);
            Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + trans.x + ", y: " + trans.y));
        }
        return super.onDoubleTap(e);
    }

    public void onLongPress(MotionEvent e) {
        ((BarLineChartBase)((Object)this.mChart)).fitScreen();
        Log.i((String)"BarlineChartTouch", (String)"Longpress, resetting zoom and drag, adjusting chart bounds to screen.");
    }

    public boolean onSingleTapUp(MotionEvent e) {
        Highlight h = ((BarLineChartBase)((Object)this.mChart)).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h == null || h.equalTo(this.mLastHighlighted)) {
            ((Chart)((Object)this.mChart)).highlightTouch(null);
            this.mLastHighlighted = null;
        } else {
            this.mLastHighlighted = h;
            ((Chart)((Object)this.mChart)).highlightTouch(h);
        }
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return super.onSingleTapConfirmed(e);
    }
}

