/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;
import java.util.ArrayList;

public abstract class ChartData<T extends DataSet<? extends Entry>> {
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    private int mYValCount = 0;
    private float mXValAverageLength = 0.0f;
    protected ArrayList<String> mXVals;
    protected ArrayList<T> mDataSets;

    public ChartData(ArrayList<String> xVals, ArrayList<T> sets) {
        this.mXVals = xVals;
        this.mDataSets = sets;
        this.init();
    }

    public ChartData(String[] xVals, ArrayList<T> sets) {
        ArrayList<String> newXVals = new ArrayList<String>();
        for (int i = 0; i < xVals.length; ++i) {
            newXVals.add(xVals[i]);
        }
        this.mXVals = newXVals;
        this.mDataSets = sets;
        this.init();
    }

    private void init() {
        this.isLegal(this.mDataSets);
        this.calcMinMax(this.mDataSets);
        this.calcYValueSum(this.mDataSets);
        this.calcYValueCount(this.mDataSets);
        this.calcXValAverageLength();
    }

    private void calcXValAverageLength() {
        if (this.mXVals.size() == 0) {
            this.mXValAverageLength = 1.0f;
            return;
        }
        float sum = 0.0f;
        for (int i = 0; i < this.mXVals.size(); ++i) {
            sum += (float)this.mXVals.get(i).length();
        }
        this.mXValAverageLength = sum / (float)this.mXVals.size();
    }

    private void isLegal(ArrayList<T> dataSets) {
        for (int i = 0; i < dataSets.size(); ++i) {
            if (((DataSet)dataSets.get(i)).getYVals().size() <= this.mXVals.size()) continue;
            throw new IllegalArgumentException("One or more of the DataSet Entry arrays are longer than the x-values array of this ChartData object.");
        }
    }

    public void notifyDataChanged() {
        this.init();
    }

    protected void calcMinMax(ArrayList<T> dataSets) {
        if (dataSets == null || dataSets.size() < 1) {
            this.mYMax = 0.0f;
            this.mYMin = 0.0f;
        } else {
            this.mYMin = ((DataSet)dataSets.get(0)).getYMin();
            this.mYMax = ((DataSet)dataSets.get(0)).getYMax();
            for (int i = 0; i < dataSets.size(); ++i) {
                if (((DataSet)dataSets.get(i)).getYMin() < this.mYMin) {
                    this.mYMin = ((DataSet)dataSets.get(i)).getYMin();
                }
                if (!(((DataSet)dataSets.get(i)).getYMax() > this.mYMax)) continue;
                this.mYMax = ((DataSet)dataSets.get(i)).getYMax();
            }
        }
    }

    protected void calcYValueSum(ArrayList<T> dataSets) {
        this.mYValueSum = 0.0f;
        for (int i = 0; i < dataSets.size(); ++i) {
            this.mYValueSum += Math.abs(((DataSet)dataSets.get(i)).getYValueSum());
        }
    }

    protected void calcYValueCount(ArrayList<T> dataSets) {
        int count = 0;
        for (int i = 0; i < dataSets.size(); ++i) {
            count += ((DataSet)dataSets.get(i)).getEntryCount();
        }
        this.mYValCount = count;
    }

    public void notifyDataForNewEntry(Entry entry) {
        this.mYValueSum += Math.abs(entry.getVal());
        if (this.mYMin > entry.getVal()) {
            this.mYMin = entry.getVal();
        }
        if (this.mYMax < entry.getVal()) {
            this.mYMax = entry.getVal();
        }
    }

    public int getDataSetCount() {
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getXValAverageLength() {
        return this.mXValAverageLength;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public int getYValCount() {
        return this.mYValCount;
    }

    public boolean isValid() {
        if (this.mXVals == null || this.mXVals.size() < 1) {
            return false;
        }
        return this.mDataSets != null && this.mDataSets.size() >= 1;
    }

    public ArrayList<String> getXVals() {
        return this.mXVals;
    }

    public ArrayList<T> getDataSets() {
        return this.mDataSets;
    }

    protected int getDataSetIndexByLabel(ArrayList<T> dataSets, String label, boolean ignorecase) {
        if (ignorecase) {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equalsIgnoreCase(((DataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        } else {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equals(((DataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getXValCount() {
        return this.mXVals.size();
    }

    protected String[] getDataSetLabels() {
        String[] types = new String[this.mDataSets.size()];
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            types[i] = ((DataSet)this.mDataSets.get(i)).getLabel();
        }
        return types;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        return ((DataSet)this.mDataSets.get(highlight.getDataSetIndex())).getEntryForXIndex(highlight.getXIndex());
    }

    public T getDataSetByLabel(String label, boolean ignorecase) {
        int index = this.getDataSetIndexByLabel(this.mDataSets, label, ignorecase);
        if (index <= 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((DataSet)this.mDataSets.get(index));
    }

    public T getDataSetByIndex(int index) {
        if (this.mDataSets == null || index < 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((DataSet)this.mDataSets.get(index));
    }

    public void addDataSet(T d) {
        if (this.mDataSets == null) {
            this.mDataSets = new ArrayList();
        }
        this.mDataSets.add(d);
        this.mYValCount += ((DataSet)d).getEntryCount();
        this.mYValueSum += ((DataSet)d).getYValueSum();
        if (this.mYMax < ((DataSet)d).getYMax()) {
            this.mYMax = ((DataSet)d).getYMax();
        }
        if (this.mYMin > ((DataSet)d).getYMin()) {
            this.mYMin = ((DataSet)d).getYMin();
        }
    }

    public boolean removeDataSet(T d) {
        if (this.mDataSets == null || d == null) {
            return false;
        }
        boolean removed = this.mDataSets.remove(d);
        if (removed) {
            this.mYValCount -= ((DataSet)d).getEntryCount();
            this.mYValueSum -= ((DataSet)d).getYValueSum();
            this.calcMinMax(this.mDataSets);
        }
        return removed;
    }

    public boolean removeDataSet(int index) {
        if (this.mDataSets == null || index >= this.mDataSets.size() || index < 0) {
            return false;
        }
        DataSet set = (DataSet)this.mDataSets.get(index);
        return this.removeDataSet(set);
    }

    public void addEntry(Entry e, int dataSetIndex) {
        float val = e.getVal();
        ++this.mYValCount;
        this.mYValueSum += val;
        if (this.mYMax < val) {
            this.mYMax = val;
        }
        if (this.mYMin > val) {
            this.mYMin = val;
        }
        ((DataSet)this.mDataSets.get(dataSetIndex)).addEntry(e);
    }

    public boolean removeEntry(Entry e, int dataSetIndex) {
        if (e == null || dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        boolean removed = ((DataSet)this.mDataSets.get(dataSetIndex)).removeEntry(e.getXIndex());
        if (removed) {
            float val = e.getVal();
            --this.mYValCount;
            this.mYValueSum -= val;
            this.calcMinMax(this.mDataSets);
        }
        return removed;
    }

    public boolean removeEntry(int xIndex, int dataSetIndex) {
        if (dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        DataSet dataSet = (DataSet)this.mDataSets.get(dataSetIndex);
        Object e = dataSet.getEntryForXIndex(xIndex);
        return this.removeEntry((Entry)e, dataSetIndex);
    }

    public T getDataSetForEntry(Entry e) {
        if (e == null) {
            return null;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            DataSet set = (DataSet)this.mDataSets.get(i);
            for (int j = 0; j < set.getEntryCount(); ++j) {
                if (!e.equalTo((Entry)set.getEntryForXIndex(e.getXIndex()))) continue;
                return (T)set;
            }
        }
        return null;
    }

    public int[] getColors() {
        int clrcnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            clrcnt += ((DataSet)this.mDataSets.get(i)).getColors().size();
        }
        int[] colors = new int[clrcnt];
        int cnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            ArrayList<Integer> clrs = ((DataSet)this.mDataSets.get(i)).getColors();
            for (Integer clr : clrs) {
                colors[cnt] = clr;
                ++cnt;
            }
        }
        return colors;
    }

    public static ArrayList<String> generateXVals(int from, int to) {
        ArrayList<String> xvals = new ArrayList<String>();
        for (int i = from; i < to; ++i) {
            xvals.add("" + i);
        }
        return xvals;
    }
}

