/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.data.RadarDataSet;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.LimitLine;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.XLabels;
import com.github.mikephil.charting.utils.YLabels;
import java.util.ArrayList;

public class RadarChart
extends PieRadarChartBase<RadarData> {
    private Paint mWebPaint;
    private float mWebLineWidth = 2.5f;
    private float mInnerWebLineWidth = 1.5f;
    private int mWebColor = Color.rgb((int)122, (int)122, (int)122);
    private int mWebColorInner = Color.rgb((int)122, (int)122, (int)122);
    private int mWebAlpha = 150;
    private boolean mDrawYLabels = true;
    private boolean mDrawXLabels = true;
    private boolean mDrawWeb = true;
    private YLabels mYLabels = new YLabels();
    private XLabels mXLabels = new XLabels();

    public RadarChart(Context context) {
        super(context);
    }

    public RadarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RadarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mWebLineWidth = Utils.convertDpToPixel(1.5f);
        this.mInnerWebLineWidth = Utils.convertDpToPixel(0.75f);
        this.mWebPaint = new Paint(1);
        this.mWebPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.mYChartMin = 0.0f;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.prepareXLabels();
    }

    @Override
    protected void calculateOffsets() {
        if (this.mDrawLegend) {
            float legendRight = 0.0f;
            float legendBottom = 0.0f;
            if (this.mLegend == null) {
                return;
            }
            if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
                float spacing = Utils.convertDpToPixel(7.0f);
                legendRight = (float)this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace() + spacing;
                this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                legendBottom = this.mLegendLabelPaint.getTextSize() * 5.5f;
            }
            this.mLegend.setOffsetBottom(legendBottom);
            this.mLegend.setOffsetRight(legendRight);
            float min = Utils.convertDpToPixel(11.0f);
            this.mOffsetBottom = Math.max((float)this.mXLabels.mLabelWidth, min);
            this.mOffsetTop = Math.max((float)this.mXLabels.mLabelWidth, min);
            this.mOffsetRight = Math.max((float)this.mXLabels.mLabelWidth, min);
            this.mOffsetLeft = Math.max((float)this.mXLabels.mLabelWidth, min);
            this.mOffsetBottom = Math.max(this.mOffsetBottom, legendBottom);
            this.mOffsetRight = Math.max(this.mOffsetRight, legendRight / 3.0f * 2.0f);
            this.mLegend.setOffsetTop(min);
            this.mLegend.setOffsetLeft(min);
            this.applyCalculatedOffsets();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.prepareYLabels();
        this.drawXLabels();
        this.drawWeb();
        this.drawLimitLines();
        this.drawData();
        this.drawAdditional();
        this.drawHighlights();
        this.drawYLabels();
        this.drawValues();
        this.drawLegend();
        this.drawDescription();
        this.drawMarkers();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("RadarChart DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    private void drawWeb() {
        if (!this.mDrawWeb) {
            return;
        }
        float sliceangle = this.getSliceAngle();
        float factor = this.getFactor();
        PointF c = this.getCenterOffsets();
        this.mWebPaint.setStrokeWidth(this.mWebLineWidth);
        this.mWebPaint.setColor(this.mWebColor);
        this.mWebPaint.setAlpha(this.mWebAlpha);
        for (int i = 0; i < ((RadarData)this.mCurrentData).getXValCount(); ++i) {
            PointF p = this.getPosition(c, this.mYChartMax * factor, sliceangle * (float)i + this.mRotationAngle);
            this.mDrawCanvas.drawLine(c.x, c.y, p.x, p.y, this.mWebPaint);
        }
        this.mWebPaint.setStrokeWidth(this.mInnerWebLineWidth);
        this.mWebPaint.setColor(this.mWebColorInner);
        this.mWebPaint.setAlpha(this.mWebAlpha);
        int labelCount = this.mYLabels.mEntryCount;
        for (int j = 0; j < labelCount; ++j) {
            for (int i = 0; i < ((RadarData)this.mCurrentData).getXValCount(); ++i) {
                float r = this.mYChartMax / (float)labelCount * (float)(j + 1) * factor;
                PointF p1 = this.getPosition(c, r, sliceangle * (float)i + this.mRotationAngle);
                PointF p2 = this.getPosition(c, r, sliceangle * (float)(i + 1) + this.mRotationAngle);
                this.mDrawCanvas.drawLine(p1.x, p1.y, p2.x, p2.y, this.mWebPaint);
            }
        }
    }

    @Override
    protected void drawData() {
        ArrayList dataSets = ((RadarData)this.mCurrentData).getDataSets();
        float sliceangle = this.getSliceAngle();
        float factor = this.getFactor();
        PointF c = this.getCenterOffsets();
        for (int i = 0; i < ((RadarData)this.mCurrentData).getDataSetCount(); ++i) {
            RadarDataSet dataSet = (RadarDataSet)dataSets.get(i);
            ArrayList entries = dataSet.getYVals();
            Path surface = new Path();
            for (int j = 0; j < entries.size(); ++j) {
                this.mRenderPaint.setColor(dataSet.getColor(j));
                Entry e = (Entry)entries.get(j);
                PointF p = this.getPosition(c, e.getVal() * factor, sliceangle * (float)j + this.mRotationAngle);
                if (j == 0) {
                    surface.moveTo(p.x, p.y);
                    continue;
                }
                surface.lineTo(p.x, p.y);
            }
            surface.close();
            if (dataSet.isDrawFilledEnabled()) {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
                this.mDrawCanvas.drawPath(surface, this.mRenderPaint);
                this.mRenderPaint.setAlpha(255);
            }
            this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
            if (dataSet.isDrawFilledEnabled() && dataSet.getFillAlpha() >= 255) continue;
            this.mDrawCanvas.drawPath(surface, this.mRenderPaint);
        }
    }

    private void drawLimitLines() {
        ArrayList<LimitLine> limitLines = ((RadarData)this.mOriginalData).getLimitLines();
        if (limitLines == null) {
            return;
        }
        float sliceangle = this.getSliceAngle();
        float factor = this.getFactor();
        PointF c = this.getCenterOffsets();
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            float r = l.getLimit() * factor;
            Path limitPath = new Path();
            for (int j = 0; j < ((RadarData)this.mCurrentData).getXValCount(); ++j) {
                PointF p = this.getPosition(c, r, sliceangle * (float)j + this.mRotationAngle);
                if (j == 0) {
                    limitPath.moveTo(p.x, p.y);
                    continue;
                }
                limitPath.lineTo(p.x, p.y);
            }
            limitPath.close();
            this.mDrawCanvas.drawPath(limitPath, this.mLimitLinePaint);
        }
    }

    private void prepareYLabels() {
        double intervalMagnitude;
        int labelCount = this.mYLabels.getLabelCount();
        double range = ((RadarData)this.mCurrentData).getYMax() - this.mYChartMin;
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        double first = Math.ceil((double)this.mYChartMin / interval) * interval;
        double last = Utils.nextUp(Math.floor((double)((RadarData)this.mCurrentData).getYMax() / interval) * interval);
        int n = 0;
        for (double f = first; f <= last; f += interval) {
            ++n;
        }
        this.mYLabels.mEntryCount = n;
        this.mYChartMax = (float)interval * (float)n;
        this.mDeltaY = Math.abs(this.mYChartMax - this.mYChartMin);
    }

    private void drawYLabels() {
        if (!this.mDrawYLabels) {
            return;
        }
        this.mYLabelPaint.setTypeface(this.mYLabels.getTypeface());
        this.mYLabelPaint.setTextSize(this.mYLabels.getTextSize());
        this.mYLabelPaint.setColor(this.mYLabels.getTextColor());
        PointF c = this.getCenterOffsets();
        float factor = this.getFactor();
        int labelCount = this.mYLabels.mEntryCount;
        for (int j = 0; j < labelCount && (j != labelCount - 1 || this.mYLabels.isDrawTopYLabelEntryEnabled()); ++j) {
            float r = this.mYChartMax / (float)labelCount * (float)j * factor;
            PointF p = this.getPosition(c, r, this.mRotationAngle);
            float val = r / factor;
            String label = Utils.formatNumber(val, this.mYLabels.mDecimals, this.mYLabels.isSeparateThousandsEnabled());
            if (this.mYLabels.isDrawUnitsInYLabelEnabled()) {
                this.mDrawCanvas.drawText(label + this.mUnit, p.x + 10.0f, p.y - 5.0f, this.mYLabelPaint);
                continue;
            }
            this.mDrawCanvas.drawText(label, p.x + 10.0f, p.y - 5.0f, this.mYLabelPaint);
        }
    }

    private void prepareXLabels() {
        StringBuffer a = new StringBuffer();
        int max = Math.round(((RadarData)this.mCurrentData).getXValAverageLength());
        for (int i = 0; i < max; ++i) {
            a.append("h");
        }
        this.mXLabels.mLabelWidth = Utils.calcTextWidth(this.mXLabelPaint, a.toString());
        this.mXLabels.mLabelHeight = Utils.calcTextWidth(this.mXLabelPaint, "Q");
    }

    private void drawXLabels() {
        if (!this.mDrawXLabels) {
            return;
        }
        this.mXLabelPaint.setTypeface(this.mXLabels.getTypeface());
        this.mXLabelPaint.setTextSize(this.mXLabels.getTextSize());
        this.mXLabelPaint.setColor(this.mXLabels.getTextColor());
        float sliceangle = this.getSliceAngle();
        float factor = this.getFactor();
        PointF c = this.getCenterOffsets();
        for (int i = 0; i < ((RadarData)this.mCurrentData).getXValCount(); ++i) {
            String text = ((RadarData)this.mCurrentData).getXVals().get(i);
            float angle = (sliceangle * (float)i + this.mRotationAngle) % 360.0f;
            PointF p = this.getPosition(c, this.mYChartMax * factor + (float)this.mXLabels.mLabelWidth / 2.0f, angle);
            this.mDrawCanvas.drawText(text, p.x, p.y + (float)this.mXLabels.mLabelHeight / 2.0f, this.mXLabelPaint);
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues) {
            float sliceangle = this.getSliceAngle();
            float factor = this.getFactor();
            PointF c = this.getCenterOffsets();
            float yoffset = Utils.convertDpToPixel(5.0f);
            for (int i = 0; i < ((RadarData)this.mCurrentData).getDataSetCount(); ++i) {
                RadarDataSet dataSet = (RadarDataSet)((RadarData)this.mCurrentData).getDataSetByIndex(i);
                ArrayList entries = dataSet.getYVals();
                for (int j = 0; j < entries.size(); ++j) {
                    Entry e = (Entry)entries.get(j);
                    PointF p = this.getPosition(c, e.getVal() * factor, sliceangle * (float)j + this.mRotationAngle);
                    if (this.mDrawUnitInChart) {
                        this.mDrawCanvas.drawText(this.mValueFormat.format(e.getVal()) + this.mUnit, p.x, p.y - yoffset, this.mValuePaint);
                        continue;
                    }
                    this.mDrawCanvas.drawText(this.mValueFormat.format(e.getVal()), p.x, p.y - yoffset, this.mValuePaint);
                }
            }
        }
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            float sliceangle = this.getSliceAngle();
            float factor = this.getFactor();
            PointF c = this.getCenterOffsets();
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                RadarDataSet set = (RadarDataSet)((RadarData)this.mCurrentData).getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                this.mHighlightPaint.setColor(set.getHighLightColor());
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                Object e = set.getEntryForXIndex(xIndex);
                int j = set.getEntryPosition((Entry)e);
                float y = ((Entry)e).getVal();
                PointF p = this.getPosition(c, y * factor, sliceangle * (float)j + this.mRotationAngle);
                float[] pts = new float[]{p.x, 0.0f, p.x, this.getHeight(), 0.0f, p.y, this.getWidth(), p.y};
                this.mDrawCanvas.drawLines(pts, this.mHighlightPaint);
            }
        }
    }

    private PointF getPosition(PointF c, float val, float angle) {
        PointF p = new PointF((float)((double)c.x + (double)val * Math.cos(Math.toRadians(angle))), (float)((double)c.y + (double)val * Math.sin(Math.toRadians(angle))));
        return p;
    }

    public float getFactor() {
        return Math.min(this.mContentRect.width() / 2.0f, this.mContentRect.height() / 2.0f) / this.mYChartMax;
    }

    public float getSliceAngle() {
        return 360.0f / (float)((RadarData)this.mCurrentData).getXValCount();
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = (angle - this.mRotationAngle + 360.0f) % 360.0f;
        float sliceangle = this.getSliceAngle();
        for (int i = 0; i < ((RadarData)this.mCurrentData).getXValCount(); ++i) {
            if (!(sliceangle * (float)(i + 1) - sliceangle / 2.0f > a)) continue;
            return i;
        }
        return 0;
    }

    public YLabels getYLabels() {
        return this.mYLabels;
    }

    public XLabels getXLabels() {
        return this.mXLabels;
    }

    public void setWebLineWidth(float width) {
        this.mWebLineWidth = Utils.convertDpToPixel(width);
    }

    public void setWebLineWidthInner(float width) {
        this.mInnerWebLineWidth = Utils.convertDpToPixel(width);
    }

    public void setWebAlpha(int alpha) {
        this.mWebAlpha = alpha;
    }

    public void setWebColor(int color) {
        this.mWebColor = color;
    }

    public void setWebColorInner(int color) {
        this.mWebColorInner = color;
    }

    public void setDrawWeb(boolean enabled) {
        this.mDrawWeb = enabled;
    }

    public void setDrawYLabels(boolean enabled) {
        this.mDrawYLabels = enabled;
    }

    public void setDrawXLabels(boolean enabled) {
        this.mDrawXLabels = enabled;
    }

    public boolean isDrawYLabelsEnabled() {
        return this.mDrawYLabels;
    }

    public boolean isDrawXLabelsEnabled() {
        return this.mDrawXLabels;
    }

    @Override
    public float getRadius() {
        if (this.mContentRect == null) {
            return 0.0f;
        }
        return Math.min(this.mContentRect.width() / 2.0f, this.mContentRect.height() / 2.0f);
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 16: {
                this.mWebPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 16: {
                return this.mWebPaint;
            }
        }
        return null;
    }
}

