/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;

public abstract class PieRadarChartBase<T extends ChartData<? extends DataSet<? extends Entry>>>
extends Chart<T> {
    protected float mRotationAngle = 270.0f;
    private boolean mRotateEnabled = true;
    private View.OnTouchListener mListener;
    private float mStartAngle = 0.0f;
    private ObjectAnimator mSpinAnimator;

    public PieRadarChartBase(Context context) {
        super(context);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mListener = new PieRadarChartTouchListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mTouchEnabled && this.mListener != null) {
            return this.mListener.onTouch((View)this, event);
        }
        return super.onTouchEvent(event);
    }

    @Override
    public void prepare() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax(false);
        this.prepareLegend();
        this.calculateOffsets();
    }

    @Override
    public void notifyDataSetChanged() {
    }

    @Override
    protected void drawAdditional() {
    }

    protected void applyCalculatedOffsets() {
        this.prepareContentRect();
        float scaleX = ((float)this.getWidth() - this.mOffsetLeft - this.mOffsetRight) / this.mDeltaX;
        float scaleY = ((float)this.getHeight() - this.mOffsetBottom - this.mOffsetTop) / this.mDeltaY;
        Matrix val = new Matrix();
        val.postTranslate(0.0f, -this.mYChartMin);
        val.postScale(scaleX, -scaleY);
        this.mMatrixValueToPx.set(val);
        Matrix offset = new Matrix();
        offset.postTranslate(this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom);
        this.mMatrixOffset.set(offset);
    }

    public void setStartAngle(float x, float y) {
        this.mStartAngle = this.getAngleForPoint(x, y);
        this.mStartAngle -= this.mRotationAngle;
    }

    public void updateRotation(float x, float y) {
        this.mRotationAngle = this.getAngleForPoint(x, y);
        this.mRotationAngle -= this.mStartAngle;
        this.mRotationAngle = (this.mRotationAngle + 360.0f) % 360.0f;
    }

    public float getAngleForPoint(float x, float y) {
        PointF c = this.getCenterOffsets();
        double tx = x - c.x;
        double ty = y - c.y;
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.x) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public float distanceToCenter(float x, float y) {
        PointF c = this.getCenterOffsets();
        float dist = 0.0f;
        float xDist = 0.0f;
        float yDist = 0.0f;
        xDist = x > c.x ? x - c.x : c.x - x;
        yDist = y > c.y ? y - c.y : c.y - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        return dist;
    }

    public abstract int getIndexForAngle(float var1);

    public void setRotationAngle(float angle) {
        this.mRotationAngle = angle = (float)((int)Math.abs(angle % 360.0f));
    }

    public float getRotationAngle() {
        return this.mRotationAngle;
    }

    public void setRotationEnabled(boolean enabled) {
        this.mRotateEnabled = enabled;
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    public float getDiameter() {
        if (this.mContentRect == null) {
            return 0.0f;
        }
        return Math.min(this.mContentRect.width(), this.mContentRect.height());
    }

    public abstract float getRadius();

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mListener = l;
    }

    public void spin(int durationmillis, float fromangle, float toangle) {
        this.mRotationAngle = fromangle;
        this.mSpinAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"rotationAngle", (float[])new float[]{fromangle, toangle});
        this.mSpinAnimator.setDuration((long)durationmillis);
        this.mSpinAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mSpinAnimator.start();
    }
}

