/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class Utils {
    private static Resources mRes;
    private static final int[] POW_10;

    public static void init(Resources res) {
        mRes = res;
    }

    public static String formatDecimal(double number, int digits) {
        StringBuffer a = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            if (i == 0) {
                a.append(".");
            }
            a.append("0");
        }
        DecimalFormat nf = new DecimalFormat("###,###,###,##0" + a.toString());
        String formatted = nf.format(number);
        return formatted;
    }

    public static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = mRes.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px) {
        DisplayMetrics metrics = mRes.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static int calcTextWidth(Paint paint, String demoText) {
        Rect r = new Rect();
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.width();
    }

    public static int calcTextHeight(Paint paint, String demoText) {
        Rect r = new Rect();
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public static int getFormatDigits(float delta) {
        if ((double)delta < 0.1) {
            return 6;
        }
        if (delta <= 1.0f) {
            return 4;
        }
        if (delta < 20.0f) {
            return 2;
        }
        if (delta < 100.0f) {
            return 1;
        }
        return 0;
    }

    public static int getPieFormatDigits(float delta) {
        if ((double)delta < 0.01) {
            return 4;
        }
        if ((double)delta < 0.1) {
            return 3;
        }
        if (delta < 1.0f) {
            return 2;
        }
        if (delta < 10.0f) {
            return 1;
        }
        return 0;
    }

    public static int getLegendFormatDigits(float step, int bonus) {
        if ((double)step < 9.9E-6) {
            return 6 + bonus;
        }
        if ((double)step < 9.9E-5) {
            return 5 + bonus;
        }
        if ((double)step < 9.9E-4) {
            return 4 + bonus;
        }
        if ((double)step < 0.0099) {
            return 3 + bonus;
        }
        if ((double)step < 0.099) {
            return 2 + bonus;
        }
        if ((double)step < 0.99) {
            return 1 + bonus;
        }
        return 0 + bonus;
    }

    public static String formatNumber(float number, int digitCount, boolean separateThousands) {
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean zero = false;
        if (number < 1.0f && number > -1.0f) {
            zero = true;
        }
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount > POW_10.length) {
            digitCount = POW_10.length - 1;
        }
        long lval = Math.round(number *= (float)POW_10[digitCount]);
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        while (lval != 0L || charCount < digitCount + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            out[ind--] = (char)(digit + 48);
            if (++charCount == digitCount) {
                out[ind--] = 44;
                ++charCount;
                decimalPointAdded = true;
                continue;
            }
            if (!separateThousands || lval == 0L || charCount <= digitCount) continue;
            if (decimalPointAdded) {
                if ((charCount - digitCount) % 4 != 0) continue;
                out[ind--] = 46;
                ++charCount;
                continue;
            }
            if ((charCount - digitCount) % 4 != 3) continue;
            out[ind--] = 46;
            ++charCount;
        }
        if (zero) {
            out[ind--] = 48;
        }
        if (neg) {
            out[ind--] = 45;
        }
        return new String(out);
    }

    public static float roundToNextSignificant(double number) {
        float d = (float)Math.ceil((float)Math.log10(number < 0.0 ? -number : number));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        long shifted = Math.round(number * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public static int[] convertIntegers(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    public static String[] convertStrings(ArrayList<String> strings) {
        String[] ret = new String[strings.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = strings.get(i);
        }
        return ret;
    }

    static {
        POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

