/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.filter;

import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;

public class Approximator {
    private ApproximatorType mType = ApproximatorType.DOUGLAS_PEUCKER;
    private double mTolerance = 0.0;
    private float mScaleRatio = 1.0f;
    private float mDeltaRatio = 1.0f;
    private boolean[] keep;

    public Approximator() {
        this.mType = ApproximatorType.NONE;
    }

    public Approximator(ApproximatorType type, double tolerance) {
        this.setup(type, tolerance);
    }

    public void setup(ApproximatorType type, double tolerance) {
        this.mType = type;
        this.mTolerance = tolerance;
    }

    public void setTolerance(double tolerance) {
        this.mTolerance = tolerance;
    }

    public void setType(ApproximatorType type) {
        this.mType = type;
    }

    public void setRatios(float deltaRatio, float scaleRatio) {
        this.mDeltaRatio = deltaRatio;
        this.mScaleRatio = scaleRatio;
    }

    public ArrayList<Entry> filter(ArrayList<Entry> points) {
        return this.filter(points, this.mTolerance);
    }

    public ArrayList<Entry> filter(ArrayList<Entry> points, double tolerance) {
        if (tolerance <= 0.0) {
            return points;
        }
        this.keep = new boolean[points.size()];
        switch (this.mType) {
            case DOUGLAS_PEUCKER: {
                return this.reduceWithDouglasPeuker(points, tolerance);
            }
            case NONE: {
                return points;
            }
        }
        return points;
    }

    private ArrayList<Entry> reduceWithDouglasPeuker(ArrayList<Entry> entries, double epsilon) {
        if (epsilon <= 0.0 || entries.size() < 3) {
            return entries;
        }
        this.keep[0] = true;
        this.keep[entries.size() - 1] = true;
        this.algorithmDouglasPeucker(entries, epsilon, 0, entries.size() - 1);
        ArrayList<Entry> reducedEntries = new ArrayList<Entry>();
        for (int i = 0; i < entries.size(); ++i) {
            if (!this.keep[i]) continue;
            Entry curEntry = entries.get(i);
            reducedEntries.add(new Entry(curEntry.getVal(), curEntry.getXIndex()));
        }
        return reducedEntries;
    }

    private void algorithmDouglasPeucker(ArrayList<Entry> entries, double epsilon, int start, int end) {
        if (end <= start + 1) {
            return;
        }
        int maxDistIndex = 0;
        double distMax = 0.0;
        Entry firstEntry = entries.get(start);
        Entry lastEntry = entries.get(end);
        for (int i = start + 1; i < end; ++i) {
            double dist = this.calcAngleBetweenLines(firstEntry, lastEntry, firstEntry, entries.get(i));
            if (!(dist > distMax)) continue;
            distMax = dist;
            maxDistIndex = i;
        }
        if (distMax > epsilon) {
            this.keep[maxDistIndex] = true;
            this.algorithmDouglasPeucker(entries, epsilon, start, maxDistIndex);
            this.algorithmDouglasPeucker(entries, epsilon, maxDistIndex, end);
        }
    }

    public double calcPointToLineDistance(Entry startEntry, Entry endEntry, Entry entryPoint) {
        float xDiffEndStart = (float)endEntry.getXIndex() - (float)startEntry.getXIndex();
        float xDiffEntryStart = (float)entryPoint.getXIndex() - (float)startEntry.getXIndex();
        double normalLength = Math.sqrt(xDiffEndStart * xDiffEndStart + (endEntry.getVal() - startEntry.getVal()) * (endEntry.getVal() - startEntry.getVal()));
        return (double)Math.abs(xDiffEntryStart * (endEntry.getVal() - startEntry.getVal()) - (entryPoint.getVal() - startEntry.getVal()) * xDiffEndStart) / normalLength;
    }

    public double calcAngleBetweenLines(Entry start1, Entry end1, Entry start2, Entry end2) {
        double angle1 = this.calcAngleWithRatios(start1, end1);
        double angle2 = this.calcAngleWithRatios(start2, end2);
        return Math.abs(angle1 - angle2);
    }

    public double calcAngleWithRatios(Entry p1, Entry p2) {
        float dx = (float)p2.getXIndex() * this.mDeltaRatio - (float)p1.getXIndex() * this.mDeltaRatio;
        float dy = p2.getVal() * this.mScaleRatio - p1.getVal() * this.mScaleRatio;
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        return angle;
    }

    public double calcAngle(Entry p1, Entry p2) {
        float dx = p2.getXIndex() - p1.getXIndex();
        float dy = p2.getVal() - p1.getVal();
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        return angle;
    }

    public static enum ApproximatorType {
        NONE,
        DOUGLAS_PEUCKER;

    }
}

