/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Path;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;

public class ScatterChart
extends BarLineChartBase {
    private Path mCustomScatterPath = null;
    private ScatterShape[] mScatterShapes = new ScatterShape[]{ScatterShape.SQUARE, ScatterShape.TRIANGLE};
    private float mShapeSize = 12.0f;

    public ScatterChart(Context context) {
        super(context);
    }

    public ScatterChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScatterChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void drawData() {
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        block0: for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<Entry> entries = dataSet.getYVals();
            float[] pos = this.generateTransformedValues(entries, 0.0f);
            ArrayList<Integer> colors = this.mCt.getDataSetColors(i % this.mCt.getColors().size());
            ScatterShape shape = this.mScatterShapes[i % this.mScatterShapes.length];
            for (int j = 0; j < pos.length; j += 2) {
                this.mRenderPaint.setColor(colors.get(j % colors.size()).intValue());
                if (this.isOffContentRight(pos[j])) continue block0;
                float shapeHalf = this.mShapeSize / 2.0f;
                if (j != 0 && this.isOffContentLeft(pos[j - 1]) && this.isOffContentTop(pos[j + 1]) && this.isOffContentBottom(pos[j + 1])) continue;
                if (shape == ScatterShape.SQUARE) {
                    this.mDrawCanvas.drawRect(pos[j] - shapeHalf, pos[j + 1] - shapeHalf, pos[j] + shapeHalf, pos[j + 1] + shapeHalf, this.mRenderPaint);
                    continue;
                }
                if (shape == ScatterShape.CIRCLE) {
                    this.mDrawCanvas.drawCircle(pos[j], pos[j + 1], this.mShapeSize / 2.0f, this.mRenderPaint);
                    continue;
                }
                if (shape == ScatterShape.CROSS) {
                    this.mDrawCanvas.drawLine(pos[j] - shapeHalf, pos[j + 1], pos[j] + shapeHalf, pos[j + 1], this.mRenderPaint);
                    this.mDrawCanvas.drawLine(pos[j], pos[j + 1] - shapeHalf, pos[j], pos[j + 1] + shapeHalf, this.mRenderPaint);
                    continue;
                }
                if (shape == ScatterShape.TRIANGLE) {
                    Path tri = new Path();
                    tri.moveTo(pos[j], pos[j + 1] - shapeHalf);
                    tri.lineTo(pos[j] + shapeHalf, pos[j + 1] + shapeHalf);
                    tri.lineTo(pos[j] - shapeHalf, pos[j + 1] + shapeHalf);
                    tri.close();
                    this.mDrawCanvas.drawPath(tri, this.mRenderPaint);
                    continue;
                }
                if (shape != ScatterShape.CUSTOM) continue;
                if (this.mCustomScatterPath == null) {
                    return;
                }
                this.transformPath(this.mCustomScatterPath);
                this.mDrawCanvas.drawPath(this.mCustomScatterPath, this.mRenderPaint);
            }
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)this.mCurrentData.getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
            for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
                DataSet dataSet = dataSets.get(i);
                ArrayList<Entry> entries = dataSet.getYVals();
                float[] positions = this.generateTransformedValues(entries, 0.0f);
                for (int j = 0; j < positions.length && !this.isOffContentRight(positions[j]); j += 2) {
                    if (this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1])) continue;
                    float val = entries.get(j / 2).getVal();
                    if (this.mDrawUnitInChart) {
                        this.mDrawCanvas.drawText(this.mFormatValue.format(val) + this.mUnit, positions[j], positions[j + 1] - this.mShapeSize, this.mValuePaint);
                        continue;
                    }
                    this.mDrawCanvas.drawText(this.mFormatValue.format(val), positions[j], positions[j + 1] - this.mShapeSize, this.mValuePaint);
                }
            }
        }
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.mHighLightIndicatorEnabled && this.valuesToHighlight()) {
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                DataSet set = this.getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                float y = set.getYValForXIndex(xIndex);
                float[] pts = new float[]{xIndex, this.mYChartMax, xIndex, this.mYChartMin, 0.0f, y, this.mDeltaX, y};
                this.transformPointArray(pts);
                this.mDrawCanvas.drawLines(pts, this.mHighlightPaint);
            }
        }
    }

    @Override
    protected void drawAdditional() {
    }

    public void setScatterShapeSize(float size) {
        this.mShapeSize = size;
    }

    public float getScatterShapeSize() {
        return this.mShapeSize;
    }

    public void setScatterShapes(ScatterShape[] shapes) {
        this.mScatterShapes = shapes;
    }

    public ScatterShape[] getScatterShapes() {
        return this.mScatterShapes;
    }

    public void setCustomScatterShape(Path shape) {
        this.mCustomScatterPath = shape;
    }

    public static enum ScatterShape {
        CROSS,
        TRIANGLE,
        CIRCLE,
        SQUARE,
        CUSTOM;

    }
}

