/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.listener.PieChartTouchListener;
import com.github.mikephil.charting.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class PieChart
extends Chart {
    private RectF mCircleBox;
    private float mChartAngle = 0.0f;
    private float[] mDrawAngles;
    private float[] mAbsoluteAngles;
    private boolean mDrawHole = true;
    private String mCenterText = null;
    private float mShift = 20.0f;
    private boolean mDrawCenterText = true;
    private boolean mDrawXVals = true;
    private boolean mUsePercentValues = false;
    private Paint mHolePaint;
    private Paint mCenterTextPaint;
    protected DecimalFormat mFormatValue = null;
    private float mStartAngle = 0.0f;

    public PieChart(Context context) {
        super(context);
    }

    public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mOffsetTop = 0;
        this.mOffsetBottom = 0;
        this.mOffsetLeft = 0;
        this.mOffsetRight = 0;
        this.mShift = Utils.convertDpToPixel(this.mShift);
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mCenterTextPaint = new Paint(1);
        this.mCenterTextPaint.setColor(this.mColorDarkBlue);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mCenterTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mListener = new PieChartTouchListener(this);
        this.mDrawYValues = true;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.drawHighlights();
        this.drawData();
        this.drawAdditional();
        this.drawValues();
        this.drawDescription();
        this.drawCenterText();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    @Override
    public void prepare() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax(false);
        if (this.mCenterText == null) {
            this.mCenterText = "Total Value\n" + (int)this.getYValueSum();
        }
        this.calcFormats();
        this.prepareMatrix();
    }

    @Override
    public void notifyDataSetChanged() {
    }

    @Override
    public void calculateOffsets() {
    }

    protected void calcFormats() {
        this.mValueFormatDigits = this.mValueDigitsToUse == -1 ? Utils.getPieFormatDigits(this.mDeltaY) : this.mValueDigitsToUse;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.mValueFormatDigits; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.mFormatValue = new DecimalFormat("###,###,###,##0" + b.toString());
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.mListener.onTouch((View)this, event);
    }

    public void setStartAngle(float x, float y) {
        this.mStartAngle = this.getAngleForPoint(x, y);
        this.mStartAngle -= this.mChartAngle;
    }

    public void updateRotation(float x, float y) {
        this.mChartAngle = this.getAngleForPoint(x, y);
        this.mChartAngle -= this.mStartAngle;
        this.mChartAngle = (this.mChartAngle + 360.0f) % 360.0f;
    }

    @Override
    protected void prepareContentRect() {
        super.prepareContentRect();
        int width = this.mContentRect.width() + this.mOffsetLeft + this.mOffsetRight;
        int height = this.mContentRect.height() + this.mOffsetTop + this.mOffsetBottom;
        float diameter = this.getDiameter();
        this.mCircleBox = new RectF((float)(width / 2) - diameter / 2.0f + this.mShift, (float)(height / 2) - diameter / 2.0f + this.mShift + (float)this.mOffsetTop, (float)(width / 2) + diameter / 2.0f - this.mShift, (float)(height / 2) + diameter / 2.0f - (float)this.mOffsetBottom - this.mShift);
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.calcAngles();
    }

    private void calcAngles() {
        this.mDrawAngles = new float[this.mCurrentData.getYValCount()];
        this.mAbsoluteAngles = new float[this.mCurrentData.getYValCount()];
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet set = dataSets.get(i);
            ArrayList<Entry> entries = set.getYVals();
            for (int j = 0; j < entries.size(); ++j) {
                this.mDrawAngles[cnt] = this.calcAngle(entries.get(j).getVal());
                this.mAbsoluteAngles[cnt] = cnt == 0 ? this.mDrawAngles[cnt] : this.mAbsoluteAngles[cnt - 1] + this.mDrawAngles[cnt];
                ++cnt;
            }
        }
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            float angle = 0.0f;
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                if (xIndex >= this.mDrawAngles.length || (float)xIndex > this.mDeltaX) continue;
                angle = xIndex == 0 ? this.mChartAngle : this.mChartAngle + this.mAbsoluteAngles[xIndex - 1];
                float sliceDegrees = this.mDrawAngles[xIndex];
                float shiftangle = (float)Math.toRadians(angle + sliceDegrees / 2.0f);
                float xShift = this.mShift * (float)Math.cos(shiftangle);
                float yShift = this.mShift * (float)Math.sin(shiftangle);
                RectF highlighted = new RectF(this.mCircleBox.left + xShift, this.mCircleBox.top + yShift, this.mCircleBox.right + xShift, this.mCircleBox.bottom + yShift);
                DataSet set = this.mCurrentData.getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                int color2 = this.mCt.getDataSetColor(this.mIndicesToHightlight[i].getDataSetIndex(), set.getIndexInEntries(xIndex));
                this.mRenderPaint.setColor(color2);
                this.mDrawCanvas.drawArc(highlighted, angle, sliceDegrees, true, this.mRenderPaint);
            }
        }
    }

    @Override
    protected void drawData() {
        float angle = this.mChartAngle;
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<Entry> entries = dataSet.getYVals();
            ArrayList<Integer> colors = this.mCt.getDataSetColors(i % this.mCt.getColors().size());
            for (int j = 0; j < entries.size(); ++j) {
                float newangle = this.mDrawAngles[cnt];
                if (!this.needsHighlight(entries.get(j).getXIndex(), i)) {
                    this.mRenderPaint.setColor(colors.get(j % colors.size()).intValue());
                    this.mDrawCanvas.drawArc(this.mCircleBox, angle, newangle, true, this.mRenderPaint);
                }
                angle += newangle;
                ++cnt;
            }
        }
    }

    private void drawHole() {
        if (this.mDrawHole) {
            this.mDrawCanvas.drawCircle((float)(this.mContentRect.width() / 2), (float)(this.mContentRect.height() / 2), this.getDiameter() / 4.0f, this.mHolePaint);
        }
    }

    private void drawCenterText() {
        if (this.mDrawCenterText) {
            PointF c = this.getCenter();
            String[] lines = this.mCenterText.split("\n");
            float lineHeight = (this.mValuePaint.ascent() + this.mValuePaint.descent()) * 1.6f;
            float textheight = (float)lines.length * lineHeight;
            for (int i = 0; i < lines.length; ++i) {
                this.mDrawCanvas.drawText(lines[lines.length - i - 1], c.x, c.y - textheight / 2.0f + lineHeight * (float)i, this.mCenterTextPaint);
            }
        }
    }

    @Override
    protected void drawValues() {
        if (!this.mDrawXVals && !this.mDrawYValues) {
            return;
        }
        PointF center = this.getCenter();
        float off = this.mCircleBox.width() / 8.0f;
        if (!this.mDrawHole) {
            off += off / 2.0f;
        }
        float r = this.mCircleBox.width() / 2.0f - off;
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<Entry> entries = dataSet.getYVals();
            for (int j = 0; j < entries.size(); ++j) {
                float offset = this.mDrawAngles[cnt] / 2.0f;
                float x = (float)((double)r * Math.cos(Math.toRadians(this.mChartAngle + this.mAbsoluteAngles[cnt] - offset)) + (double)center.x);
                float y = (float)((double)r * Math.sin(Math.toRadians(this.mChartAngle + this.mAbsoluteAngles[cnt] - offset)) + (double)center.y);
                String val = "";
                float value = entries.get(j).getVal();
                val = this.mUsePercentValues ? this.mFormatValue.format(this.getPercentOfTotal(value)) + " %" : this.mFormatValue.format(value);
                if (this.mDrawXVals && this.mDrawYValues) {
                    float lineHeight = (this.mValuePaint.ascent() + this.mValuePaint.descent()) * 1.6f;
                    this.mDrawCanvas.drawText(val, x, y -= lineHeight / 2.0f, this.mValuePaint);
                    this.mDrawCanvas.drawText(this.mCurrentData.getXVals().get(j), x, y + lineHeight, this.mValuePaint);
                } else if (this.mDrawXVals && !this.mDrawYValues) {
                    this.mDrawCanvas.drawText(this.mCurrentData.getXVals().get(j), x, y, this.mValuePaint);
                } else if (!this.mDrawXVals && this.mDrawYValues) {
                    this.mDrawCanvas.drawText(val, x, y, this.mValuePaint);
                }
                ++cnt;
            }
        }
    }

    @Override
    protected void drawAdditional() {
        this.drawHole();
    }

    private float calcAngle(float value) {
        return value / this.mCurrentData.getYValueSum() * 360.0f;
    }

    public int getIndexForAngle(float angle) {
        float a = (angle - this.mChartAngle + 360.0f) % 360.0f;
        for (int i = 0; i < this.mAbsoluteAngles.length; ++i) {
            if (!(this.mAbsoluteAngles[i] > a)) continue;
            return i;
        }
        return -1;
    }

    public int getDataSetIndexForIndex(int xIndex) {
        ArrayList<DataSet> sets = this.mCurrentData.getDataSets();
        for (int i = 0; i < sets.size(); ++i) {
            if (sets.get(i).getEntryForXIndex(xIndex) == null) continue;
            return i;
        }
        return -1;
    }

    public float[] getDrawAngles() {
        return this.mDrawAngles;
    }

    public float[] getAbsoluteAngles() {
        return this.mAbsoluteAngles;
    }

    public void setStartAngle(float angle) {
        this.mChartAngle = angle;
    }

    public float getCurrentRotation() {
        return this.mChartAngle;
    }

    public void setShift(float shift) {
        this.mShift = Utils.convertDpToPixel(shift);
    }

    public void setDrawHoleEnabled(boolean enabled) {
        this.mDrawHole = enabled;
    }

    public boolean isDrawHoleEnabled() {
        return this.mDrawHole;
    }

    public void setCenterText(String text) {
        this.mCenterText = text;
    }

    public String getCenterText() {
        return this.mCenterText;
    }

    public void setDrawCenterText(boolean enabled) {
        this.mDrawCenterText = enabled;
    }

    public boolean isDrawCenterTextEnabled() {
        return this.mDrawCenterText;
    }

    public void setUsePercentValues(boolean enabled) {
        this.mUsePercentValues = enabled;
    }

    public boolean isUsePercentValuesEnabled() {
        return this.mUsePercentValues;
    }

    public void setDrawXValues(boolean enabled) {
        this.mDrawXVals = enabled;
    }

    public boolean isDrawXValuesEnabled() {
        return this.mDrawXVals;
    }

    public float getRadius() {
        if (this.mCircleBox == null) {
            return 0.0f;
        }
        return this.mCircleBox.width() / 2.0f;
    }

    public float getDiameter() {
        if (this.mContentRect == null) {
            return 0.0f;
        }
        return Math.min(this.mContentRect.width(), this.mContentRect.height());
    }

    public RectF getCircleBox() {
        return this.mCircleBox;
    }

    public float getAngleForPoint(float x, float y) {
        PointF c = this.getCenter();
        double tx = x - c.x;
        double ty = y - c.y;
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > this.getCenter().x) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public float distanceToCenter(float x, float y) {
        PointF c = this.getCenter();
        float dist = 0.0f;
        float xDist = 0.0f;
        float yDist = 0.0f;
        xDist = x > c.x ? x - c.x : c.x - x;
        yDist = y > c.y ? y - c.y : c.y - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        return dist;
    }

    public void setCenterTextTypeface(Typeface t) {
        this.mCenterTextPaint.setTypeface(t);
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 13: {
                this.mHolePaint = p;
                break;
            }
            case 14: {
                this.mCenterTextPaint = p;
            }
        }
    }
}

