/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class LineChart
extends BarLineChartBase {
    protected float mCircleSize = 4.0f;
    protected float mLineWidth = 1.0f;
    protected float mHighlightWidth = 3.0f;
    protected boolean mDrawFilled = false;
    protected boolean mDrawCircles = true;
    protected Paint mFilledPaint;
    protected Paint mCirclePaintInner;

    public LineChart(Context context) {
        super(context);
    }

    public LineChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LineChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mCircleSize = Utils.convertDpToPixel(this.mCircleSize);
        this.mFilledPaint = new Paint();
        this.mFilledPaint.setStyle(Paint.Style.FILL);
        this.mFilledPaint.setColor(this.mColorDarkBlue);
        this.mFilledPaint.setAlpha(130);
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.mHighLightIndicatorEnabled && this.valuesToHighlight()) {
            for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
                DataSet set = this.getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                float y = set.getYValForXIndex(xIndex);
                float[] pts = new float[]{xIndex, this.mYChartMax, xIndex, this.mYChartMin, 0.0f, y, this.mDeltaX, y};
                this.transformPointArray(pts);
                this.mDrawCanvas.drawLines(pts, this.mHighlightPaint);
            }
        }
    }

    @Override
    protected void drawData() {
        ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<Entry> entries = dataSet.getYVals();
            float[] valuePoints = this.generateTransformedValues(entries, 0.0f);
            ArrayList<Integer> colors = this.mCt.getDataSetColors(i % this.mCt.getColors().size());
            Paint paint = this.mRenderPaint;
            for (int j = 0; j < valuePoints.length - 2; j += 2) {
                paint.setColor(colors.get(j % colors.size()).intValue());
                if (this.isOffContentRight(valuePoints[j])) break;
                if (j != 0 && this.isOffContentLeft(valuePoints[j - 1]) && this.isOffContentTop(valuePoints[j + 1]) && this.isOffContentBottom(valuePoints[j + 1])) continue;
                this.mDrawCanvas.drawLine(valuePoints[j], valuePoints[j + 1], valuePoints[j + 2], valuePoints[j + 3], paint);
            }
            if (!this.mDrawFilled || entries.size() <= 0) continue;
            paint.setAlpha(85);
            Path filled = new Path();
            filled.moveTo((float)entries.get(0).getXIndex(), entries.get(0).getVal());
            for (int x = 1; x < entries.size(); ++x) {
                filled.lineTo((float)entries.get(x).getXIndex(), entries.get(x).getVal());
            }
            filled.lineTo((float)entries.get(entries.size() - 1).getXIndex(), this.mYChartMin);
            filled.lineTo((float)entries.get(0).getXIndex(), this.mYChartMin);
            filled.close();
            this.transformPath(filled);
            this.mDrawCanvas.drawPath(filled, paint);
            paint.setAlpha(255);
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)this.mCurrentData.getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            int valOffset = (int)(this.mCircleSize * 1.7f);
            if (!this.mDrawCircles) {
                valOffset /= 2;
            }
            ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
            for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
                DataSet dataSet = dataSets.get(i);
                ArrayList<Entry> entries = dataSet.getYVals();
                float[] positions = this.generateTransformedValues(entries, 0.0f);
                for (int j = 0; j < positions.length && !this.isOffContentRight(positions[j]); j += 2) {
                    if (this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1])) continue;
                    float val = entries.get(j / 2).getVal();
                    if (this.mDrawUnitInChart) {
                        this.mDrawCanvas.drawText(this.mFormatValue.format(val) + this.mUnit, positions[j], positions[j + 1] - (float)valOffset, this.mValuePaint);
                        continue;
                    }
                    this.mDrawCanvas.drawText(this.mFormatValue.format(val), positions[j], positions[j + 1] - (float)valOffset, this.mValuePaint);
                }
            }
        }
    }

    @Override
    protected void drawAdditional() {
        if (this.mDrawCircles) {
            ArrayList<DataSet> dataSets = this.mCurrentData.getDataSets();
            block0: for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
                DataSet dataSet = dataSets.get(i);
                ArrayList<Entry> entries = dataSet.getYVals();
                ArrayList<Integer> colors = this.mCt.getDataSetColors(i % this.mCt.getColors().size());
                float[] positions = this.generateTransformedValues(entries, 0.0f);
                for (int j = 0; j < positions.length; j += 2) {
                    this.mRenderPaint.setColor(colors.get(j % colors.size()).intValue());
                    if (this.isOffContentRight(positions[j])) continue block0;
                    if (this.isOffContentLeft(positions[j]) || this.isOffContentTop(positions[j + 1]) || this.isOffContentBottom(positions[j + 1])) continue;
                    this.mDrawCanvas.drawCircle(positions[j], positions[j + 1], this.mCircleSize, this.mRenderPaint);
                    this.mDrawCanvas.drawCircle(positions[j], positions[j + 1], this.mCircleSize / 2.0f, this.mCirclePaintInner);
                }
            }
        }
    }

    public void setDrawCircles(boolean enabled) {
        this.mDrawCircles = enabled;
    }

    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    public void setCircleSize(float size) {
        this.mCircleSize = Utils.convertDpToPixel(size);
    }

    public float getCircleSize(float size) {
        return Utils.convertPixelsToDp(this.mCircleSize);
    }

    public void setDrawFilled(boolean filled) {
        this.mDrawFilled = filled;
    }

    public boolean isDrawFilledEnabled() {
        return this.mDrawFilled;
    }

    public void setLineWidth(float width) {
        if (width < 0.5f) {
            width = 0.5f;
        }
        if (width > 10.0f) {
            width = 10.0f;
        }
        this.mLineWidth = width;
        this.mRenderPaint.setStrokeWidth(width);
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setFillColor(int color2) {
        this.mFilledPaint.setColor(color2);
    }

    public void setHighlightLineWidth(float width) {
        this.mHighlightWidth = width;
    }

    public float getHighlightLineWidth() {
        return this.mHighlightWidth;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mRenderPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{lineLength, spaceLength}, phase));
    }

    public void disableDashedLine() {
        this.mRenderPaint.setPathEffect(null);
    }

    public boolean isDashedLineEnabled() {
        return this.mRenderPaint.getPathEffect() != null;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 10: {
                this.mCirclePaintInner = p;
                break;
            }
            case 15: {
                this.mHighlightPaint = p;
            }
        }
    }
}

