/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.OnChartValueSelectedListener;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.MarkerView;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public abstract class Chart
extends View {
    public static final String LOG_TAG = "MPChart";
    protected int mColorDarkBlue = Color.rgb((int)41, (int)128, (int)186);
    protected int mColorDarkRed = Color.rgb((int)232, (int)76, (int)59);
    protected int mValueDigitsToUse = -1;
    protected int mValueFormatDigits = -1;
    protected int mOffsetLeft = 15;
    protected int mOffsetTop = 22;
    protected int mOffsetRight = 15;
    protected int mOffsetBottom = 15;
    protected ChartData mCurrentData = null;
    protected ChartData mOriginalData = null;
    protected Bitmap mDrawBitmap;
    protected Canvas mDrawCanvas;
    protected float mYChartMin = 0.0f;
    protected float mYChartMax = 0.0f;
    protected Paint mDrawPaint;
    protected Paint mDescPaint;
    protected Paint mInfoPaint;
    protected Paint mValuePaint;
    protected Paint mRenderPaint;
    protected ColorTemplate mCt;
    protected String mDescription = "Description.";
    protected boolean mDataNotSet = true;
    protected float mDeltaY = 1.0f;
    protected float mDeltaX = 1.0f;
    protected Matrix mMatrixValueToPx = new Matrix();
    protected Matrix mMatrixOffset = new Matrix();
    protected final Matrix mMatrixTouch = new Matrix();
    protected boolean mTouchEnabled = true;
    protected boolean mDrawYValues = true;
    protected boolean mHighlightEnabled = true;
    protected boolean mSeparateTousands = true;
    protected Rect mContentRect = new Rect();
    protected OnChartValueSelectedListener mSelectionListener;
    protected boolean mOffsetsCalculated = false;
    protected View.OnTouchListener mListener;
    protected Highlight[] mIndicesToHightlight = new Highlight[0];
    protected boolean mDrawMarkerViews = true;
    protected MarkerView mMarkerView;
    public static final int PAINT_GRID = 3;
    public static final int PAINT_GRID_BACKGROUND = 4;
    public static final int PAINT_YLABEL = 5;
    public static final int PAINT_XLABEL = 6;
    public static final int PAINT_INFO = 7;
    public static final int PAINT_VALUES = 8;
    public static final int PAINT_CIRCLES_INNER = 10;
    public static final int PAINT_DESCRIPTION = 11;
    public static final int PAINT_BORDER = 12;
    public static final int PAINT_HOLE = 13;
    public static final int PAINT_CENTER_TEXT = 14;
    public static final int PAINT_HIGHLIGHT_LINE = 15;
    public static final int PAINT_HIGHLIGHT_BAR = 16;
    public static final int PAINT_RENDER = 17;
    public static final int PAINT_LEGEND_LABEL = 18;

    public Chart(Context context) {
        super(context);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        Utils.init(this.getContext().getResources());
        this.mOffsetBottom = (int)Utils.convertDpToPixel(this.mOffsetBottom);
        this.mOffsetLeft = (int)Utils.convertDpToPixel(this.mOffsetLeft);
        this.mOffsetRight = (int)Utils.convertDpToPixel(this.mOffsetRight);
        this.mOffsetTop = (int)Utils.convertDpToPixel(this.mOffsetTop);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mDrawPaint = new Paint();
        this.mDescPaint = new Paint(1);
        this.mDescPaint.setColor(-16777216);
        this.mDescPaint.setTextAlign(Paint.Align.RIGHT);
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mInfoPaint = new Paint(1);
        this.mInfoPaint.setColor(Color.rgb((int)247, (int)189, (int)51));
        this.mInfoPaint.setTextAlign(Paint.Align.CENTER);
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint = new Paint(1);
        this.mValuePaint.setColor(Color.rgb((int)63, (int)63, (int)63));
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mCt = new ColorTemplate();
        this.mCt.addDataSetColors(ColorTemplate.LIBERTY_COLORS, this.getContext());
    }

    public void initWithDummyData() {
        ColorTemplate template = new ColorTemplate();
        template.addColorsForDataSets(ColorTemplate.COLORFUL_COLORS, this.getContext());
        this.setColorTemplate(template);
        this.setDrawYValues(false);
        ArrayList<String> xVals = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < 12; ++i) {
            xVals.add(calendar.getDisplayName(2, 1, Locale.getDefault()));
        }
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (int i = 0; i < 3; ++i) {
            ArrayList<Entry> yVals = new ArrayList<Entry>();
            for (int j = 0; j < 12; ++j) {
                float val = (float)(Math.random() * 100.0);
                yVals.add(new Entry(val, j));
            }
            DataSet set = new DataSet(yVals, "DS " + i);
            dataSets.add(set);
        }
        ChartData data = new ChartData(xVals, dataSets);
        this.setData(data);
        this.invalidate();
    }

    public void setData(ChartData data) {
        if (data == null || !data.isValid()) {
            Log.e((String)LOG_TAG, (String)"Cannot set data for chart. Provided chart values are null or contain less than 2 entries.");
            this.mDataNotSet = true;
            return;
        }
        this.mDataNotSet = false;
        this.mOffsetsCalculated = false;
        this.mCurrentData = data;
        this.mOriginalData = data;
        this.prepare();
        Log.i((String)LOG_TAG, (String)"Data is set.");
    }

    public void setData(ArrayList<String> xVals, ArrayList<Float> yVals) {
        ArrayList<Entry> series = new ArrayList<Entry>();
        for (int i = 0; i < yVals.size(); ++i) {
            series.add(new Entry(yVals.get(i).floatValue(), i));
        }
        DataSet set = new DataSet(series, "DataSet");
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        dataSets.add(set);
        ChartData data = new ChartData(xVals, dataSets);
        this.setData(data);
    }

    public abstract void prepare();

    public abstract void notifyDataSetChanged();

    public abstract void calculateOffsets();

    protected void calcMinMax(boolean fixedValues) {
        if (!fixedValues) {
            this.mYChartMin = this.mCurrentData.getYMin();
            this.mYChartMax = this.mCurrentData.getYMax();
        }
        this.mDeltaY = Math.abs(this.mCurrentData.getYMax() - this.mCurrentData.getYMin());
        this.mDeltaX = this.mCurrentData.getXVals().size() - 1;
    }

    @SuppressLint(value={"NewApi"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.i((String)LOG_TAG, (String)"DRAW-CALLED");
        if (this.mDataNotSet) {
            canvas.drawText("No chart data available.", (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mInfoPaint);
            return;
        }
        if (this.mDrawBitmap == null || this.mDrawCanvas == null) {
            this.mDrawBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            this.mDrawCanvas = new Canvas(this.mDrawBitmap);
        }
        this.mDrawCanvas.drawColor(-1);
    }

    protected void prepareMatrix() {
        float scaleX = (float)(this.getWidth() - this.mOffsetLeft - this.mOffsetRight) / this.mDeltaX;
        float scaleY = (float)(this.getHeight() - this.mOffsetBottom - this.mOffsetTop) / this.mDeltaY;
        this.mMatrixValueToPx.reset();
        this.mMatrixValueToPx.postTranslate(0.0f, -this.mYChartMin);
        this.mMatrixValueToPx.postScale(scaleX, -scaleY);
        this.mMatrixOffset.reset();
        this.mMatrixOffset.postTranslate((float)this.mOffsetLeft, (float)(this.getHeight() - this.mOffsetBottom));
        Log.i((String)LOG_TAG, (String)"Matrices prepared.");
    }

    protected void prepareContentRect() {
        this.mContentRect.set(this.mOffsetLeft, this.mOffsetTop, this.getMeasuredWidth() - this.mOffsetRight, this.getMeasuredHeight() - this.mOffsetBottom);
        Log.i((String)LOG_TAG, (String)("Contentrect prepared. Width: " + this.mContentRect.width() + ", height: " + this.mContentRect.height()));
    }

    protected float[] generateTransformedValues(ArrayList<Entry> entries, float xOffset) {
        float[] valuePoints = new float[entries.size() * 2];
        for (int j = 0; j < valuePoints.length; j += 2) {
            valuePoints[j] = (float)entries.get(j / 2).getXIndex() + xOffset;
            valuePoints[j + 1] = entries.get(j / 2).getVal();
        }
        this.transformPointArray(valuePoints);
        return valuePoints;
    }

    protected void transformPath(Path path) {
        path.transform(this.mMatrixValueToPx);
        path.transform(this.mMatrixTouch);
        path.transform(this.mMatrixOffset);
    }

    protected void transformPaths(ArrayList<Path> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            this.transformPath(paths.get(i));
        }
    }

    protected void transformPointArray(float[] pts) {
        this.mMatrixValueToPx.mapPoints(pts);
        this.mMatrixTouch.mapPoints(pts);
        this.mMatrixOffset.mapPoints(pts);
    }

    protected void transformRect(RectF r) {
        this.mMatrixValueToPx.mapRect(r);
        this.mMatrixTouch.mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    protected void transformRects(ArrayList<RectF> rects) {
        for (int i = 0; i < rects.size(); ++i) {
            this.transformRect(rects.get(i));
        }
    }

    protected void transformRectsTouch(ArrayList<RectF> rects) {
        for (int i = 0; i < rects.size(); ++i) {
            this.mMatrixTouch.mapRect(rects.get(i));
        }
    }

    protected void transformPathsTouch(ArrayList<Path> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            paths.get(i).transform(this.mMatrixTouch);
        }
    }

    protected void drawDescription() {
        this.mDrawCanvas.drawText(this.mDescription, (float)(this.getWidth() - this.mOffsetRight - 10), (float)(this.getHeight() - this.mOffsetBottom - 10), this.mDescPaint);
    }

    protected abstract void drawValues();

    protected abstract void drawData();

    protected abstract void drawAdditional();

    protected abstract void drawHighlights();

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mListener == null) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mListener.onTouch((View)this, event);
    }

    public boolean needsHighlight(int xIndex, int dataSetIndex) {
        if (!this.valuesToHighlight()) {
            return false;
        }
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            if (this.mIndicesToHightlight[i].getXIndex() != xIndex || this.mIndicesToHightlight[i].getDataSetIndex() != dataSetIndex || !((float)xIndex <= this.mDeltaX)) continue;
            return true;
        }
        return false;
    }

    public boolean valuesToHighlight() {
        return this.mIndicesToHightlight != null && this.mIndicesToHightlight.length > 0 && this.mIndicesToHightlight[0] != null;
    }

    public void highlightValues(Highlight[] highs) {
        this.mIndicesToHightlight = highs;
        this.invalidate();
        if (this.mSelectionListener != null) {
            if (!this.valuesToHighlight()) {
                this.mSelectionListener.onNothingSelected();
            } else {
                Entry[] values = new Entry[highs.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.getEntryByDataSetIndex(highs[i].getXIndex(), highs[i].getDataSetIndex());
                }
                this.mSelectionListener.onValuesSelected(values, highs);
            }
        }
    }

    protected void drawMarkers() {
        if (this.mMarkerView == null || !this.mDrawMarkerViews || !this.valuesToHighlight()) {
            return;
        }
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            this.drawMarkerView(xIndex, this.mIndicesToHightlight[i].getDataSetIndex());
        }
    }

    private void drawMarkerView(int xIndex, int dataSetIndex) {
        float value = this.getYValueByDataSetIndex(xIndex, dataSetIndex);
        float xPos = xIndex;
        if (this instanceof BarChart) {
            xPos += 0.5f;
        }
        float[] pts = new float[]{xPos, value};
        this.transformPointArray(pts);
        float posX = pts[0];
        float posY = pts[1];
        this.mMarkerView.refreshContent(xIndex, value, dataSetIndex);
        this.mMarkerView.draw(this.mDrawCanvas, posX, posY);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mListener = l;
    }

    public void setOnChartValueSelectedListener(OnChartValueSelectedListener l) {
        this.mSelectionListener = l;
    }

    public void setHighlightEnabled(boolean enabled) {
        this.mHighlightEnabled = enabled;
    }

    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    public float getYValueSum() {
        return this.mCurrentData.getYValueSum();
    }

    public float getYMax() {
        return this.mCurrentData.getYMax();
    }

    public float getYChartMin() {
        return this.mYChartMin;
    }

    public float getYChartMax() {
        return this.mYChartMax;
    }

    public float getYMin() {
        return this.mCurrentData.getYMin();
    }

    public float getDeltaX() {
        return this.mDeltaX;
    }

    public float getAverage() {
        return this.getYValueSum() / (float)this.mCurrentData.getYValCount();
    }

    public float getAverage(String dataSetLabel) {
        DataSet ds = this.mCurrentData.getDataSetByLabel(dataSetLabel, true);
        return ds.getYValueSum() / (float)ds.getEntryCount();
    }

    public int getValueCount() {
        return this.mCurrentData.getYValCount();
    }

    public PointF getCenter() {
        return new PointF((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
    }

    public void setDescriptionTextSize(float size) {
        if (size > 14.0f) {
            size = 14.0f;
        }
        if (size < 7.0f) {
            size = 7.0f;
        }
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setOffsets(int left, int top, int right, int bottom) {
        this.mOffsetBottom = (int)Utils.convertDpToPixel(bottom);
        this.mOffsetLeft = (int)Utils.convertDpToPixel(left);
        this.mOffsetRight = (int)Utils.convertDpToPixel(right);
        this.mOffsetTop = (int)Utils.convertDpToPixel(top);
    }

    public int getOffsetLeft() {
        return this.mOffsetLeft;
    }

    public int getOffsetBottom() {
        return this.mOffsetBottom;
    }

    public int getOffsetRight() {
        return this.mOffsetRight;
    }

    public int getOffsetTop() {
        return this.mOffsetTop;
    }

    public void setTouchEnabled(boolean enabled) {
        this.mTouchEnabled = enabled;
    }

    public void setDrawYValues(boolean enabled) {
        this.mDrawYValues = enabled;
    }

    public void setColorTemplate(ColorTemplate ct) {
        this.mCt = ct;
    }

    public ColorTemplate getColorTemplate() {
        return this.mCt;
    }

    public void setMarkerView(MarkerView v) {
        this.mMarkerView = v;
    }

    public MarkerView getMarkerView() {
        return this.mMarkerView;
    }

    public void setPaint(Paint p, int which) {
        switch (which) {
            case 7: {
                this.mInfoPaint = p;
                break;
            }
            case 11: {
                this.mDescPaint = p;
                break;
            }
            case 8: {
                this.mValuePaint = p;
                break;
            }
            case 17: {
                this.mRenderPaint = p;
            }
        }
    }

    public boolean isDrawMarkerViewEnabled() {
        return this.mDrawMarkerViews;
    }

    public void setDrawMarkerViews(boolean enabled) {
        this.mDrawMarkerViews = enabled;
    }

    public void setValuePaintColor(int color2) {
        this.mValuePaint.setColor(color2);
    }

    public void setSeparateThousands(boolean enabled) {
        this.mSeparateTousands = enabled;
    }

    public boolean isDrawYValuesEnabled() {
        return this.mDrawYValues;
    }

    public String getXValue(int index) {
        if (this.mCurrentData == null || this.mCurrentData.getXValCount() <= index) {
            return null;
        }
        return this.mCurrentData.getXVals().get(index);
    }

    public float getYValue(int index) {
        return this.mCurrentData.getDataSetByIndex(0).getYVals().get(index).getVal();
    }

    public float getYValue(int index, String dataSetLabel) {
        DataSet set = this.mCurrentData.getDataSetByLabel(dataSetLabel, true);
        return set.getYVals().get(index).getVal();
    }

    public float getYValueByDataSetIndex(int xIndex, int dataSet) {
        DataSet set = this.mCurrentData.getDataSetByIndex(dataSet);
        return set.getYValForXIndex(xIndex);
    }

    public DataSet getDataSetByIndex(int index) {
        return this.mCurrentData.getDataSetByIndex(index);
    }

    public DataSet getDataSetByLabel(String dataSetLabel) {
        return this.mCurrentData.getDataSetByLabel(dataSetLabel, true);
    }

    public Entry getEntry(int index) {
        return this.mCurrentData.getDataSetByIndex(0).getYVals().get(index);
    }

    public Entry getEntry(int index, String dataSetLabel) {
        return this.mCurrentData.getDataSetByLabel(dataSetLabel, true).getYVals().get(index);
    }

    public Entry getEntryByDataSetIndex(int xIndex, int dataSetIndex) {
        return this.mCurrentData.getDataSetByIndex(dataSetIndex).getEntryForXIndex(xIndex);
    }

    protected ArrayList<SelInfo> getYValsAtIndex(int xIndex) {
        ArrayList<SelInfo> vals = new ArrayList<SelInfo>();
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            float yVal = this.mCurrentData.getDataSetByIndex(i).getYValForXIndex(xIndex);
            if (Float.isNaN(yVal)) continue;
            vals.add(new SelInfo(yVal, i));
        }
        return vals;
    }

    public ArrayList<Entry> getEntriesAtIndex(int xIndex) {
        ArrayList<Entry> vals = new ArrayList<Entry>();
        for (int i = 0; i < this.mCurrentData.getDataSetCount(); ++i) {
            DataSet set = this.mCurrentData.getDataSetByIndex(i);
            Entry e = set.getEntryForXIndex(xIndex);
            if (e == null) continue;
            vals.add(e);
        }
        return vals;
    }

    public ChartData getDataCurrent() {
        return this.mCurrentData;
    }

    public ChartData getDataOriginal() {
        return this.mOriginalData;
    }

    public float getPercentOfTotal(float val) {
        return val / this.mCurrentData.getYValueSum() * 100.0f;
    }

    public void setValueTypeface(Typeface t) {
        this.mValuePaint.setTypeface(t);
    }

    public void setDescriptionTypeface(Typeface t) {
        this.mDescPaint.setTypeface(t);
    }

    public void setValueDigits(int digits) {
        this.mValueDigitsToUse = digits;
    }

    public int getValueDigits() {
        return this.mValueDigitsToUse;
    }

    public void saveToGallery(String title) {
        MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (Bitmap)this.mDrawBitmap, (String)title, (String)"");
    }

    public void saveToPath(String title, String pathOnSD) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(Environment.getExternalStorageDirectory().getPath() + pathOnSD + "/" + title + ".png");
            this.mDrawBitmap.compress(Bitmap.CompressFormat.PNG, 40, (OutputStream)stream);
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        Log.i((String)LOG_TAG, (String)"onLayout()");
        this.prepareContentRect();
        if (this instanceof BarLineChartBase) {
            if (!((BarLineChartBase)this).hasFixedYValues()) {
                this.prepareMatrix();
            }
        } else {
            this.prepareMatrix();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            this.initWithDummyData();
        }
    }
}

