/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewParent;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.filter.Approximator;
import com.github.mikephil.charting.interfaces.OnDrawListener;
import com.github.mikephil.charting.listener.BarLineChartTouchListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.YLabels;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class BarLineChartBase
extends Chart {
    protected String mUnit = "";
    protected int mMaxVisibleCount = 100;
    private float mMinScaleY = 1.0f;
    private float mMinScaleX = 1.0f;
    protected float mScaleX = 1.0f;
    protected float mScaleY = 1.0f;
    protected float mMaxScaleY = 7.0f;
    protected int mXLabelWidth = 1;
    protected int mXAxisLabelModulus = 1;
    protected int mYLabelCount = 9;
    protected float mGridWidth = 1.0f;
    protected boolean mDrawUnitInChart = false;
    private boolean mDrawTopYLabelEntry = true;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDrawUnitsInLabels = true;
    protected boolean mCenterXAxisLabels = false;
    protected boolean mAdjustXAxisLabels = true;
    protected boolean mDragEnabled = true;
    protected boolean mFixedYValues = false;
    protected boolean mStartAtZero = true;
    protected boolean mFilterData = false;
    protected Paint mGridPaint;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected Paint mXLabelPaint;
    protected Paint mYLabelPaint;
    protected Paint mHighlightPaint;
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected boolean mHighLightIndicatorEnabled = true;
    protected boolean mAutoFinishDrawing;
    protected boolean mDrawVerticalGrid = true;
    protected boolean mDrawHorizontalGrid = true;
    protected boolean mDrawYLabels = true;
    protected boolean mDrawXLabels = true;
    protected boolean mDrawBorder = true;
    protected boolean mDrawGridBackground = true;
    protected boolean mDrawLegend = true;
    protected OnDrawListener mDrawListener;
    protected YLabels mYLabels = new YLabels();
    private Approximator mApproximator;
    protected Legend mLegend;
    protected DecimalFormat mFormatValue = null;
    protected int mYLabelFormatDigits = -1;
    private BorderStyle[] mBorderStyles = new BorderStyle[]{BorderStyle.BOTTOM};

    public BarLineChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BarLineChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mListener = new BarLineChartTouchListener(this, this.mMatrixTouch);
        this.mXLabelPaint = new Paint(1);
        this.mXLabelPaint.setColor(-16777216);
        this.mXLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mXLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mYLabelPaint = new Paint(1);
        this.mYLabelPaint.setColor(-16777216);
        this.mYLabelPaint.setTextAlign(Paint.Align.RIGHT);
        this.mYLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mGridPaint = new Paint();
        this.mGridPaint.setColor(-7829368);
        this.mGridPaint.setStrokeWidth(this.mGridWidth);
        this.mGridPaint.setStyle(Paint.Style.STROKE);
        this.mGridPaint.setAlpha(90);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(this.mGridWidth * 2.0f);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(Color.rgb((int)240, (int)240, (int)240));
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        if (!this.mOffsetsCalculated) {
            this.calculateOffsets();
            this.mOffsetsCalculated = true;
        }
        if (this.mFilterData) {
            this.mCurrentData = this.getFilteredData();
            Log.i((String)"MPChart", (String)("FilterTime: " + (System.currentTimeMillis() - starttime) + " ms"));
            starttime = System.currentTimeMillis();
        } else {
            this.mCurrentData = this.getDataOriginal();
        }
        if (this.mAdjustXAxisLabels) {
            this.calcModulus();
        }
        this.drawGridBackground();
        this.drawBorder();
        this.prepareYLabels();
        int clipRestoreCount = this.mDrawCanvas.save();
        this.mDrawCanvas.clipRect(this.mContentRect);
        this.drawHorizontalGrid();
        this.drawVerticalGrid();
        this.drawData();
        this.drawHighlights();
        this.mDrawCanvas.restoreToCount(clipRestoreCount);
        this.drawAdditional();
        this.drawXLabels();
        this.drawYLabels();
        this.drawValues();
        this.drawLegend();
        this.drawMarkers();
        this.drawDescription();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    @Override
    public void prepare() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax(this.mFixedYValues);
        this.prepareXLabels();
        this.calcFormats();
        this.prepareLegend();
    }

    @Override
    public void notifyDataSetChanged() {
        if (!this.mFixedYValues) {
            this.prepare();
        } else {
            this.calcMinMax(this.mFixedYValues);
        }
    }

    @Override
    public void calculateOffsets() {
        if (this.mDrawLegend) {
            if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART) {
                this.mOffsetRight = this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint);
            } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART) {
                this.mOffsetBottom = (int)this.mLegendLabelPaint.getTextSize() * 3;
            }
        }
        this.mOffsetLeft = Utils.calcTextWidth(this.mYLabelPaint, (int)this.mDeltaY + ".0000");
        this.prepareContentRect();
        float scaleX = (float)(this.getWidth() - this.mOffsetLeft - this.mOffsetRight) / this.mDeltaX;
        float scaleY = (float)(this.getHeight() - this.mOffsetBottom - this.mOffsetTop) / this.mDeltaY;
        Matrix val = new Matrix();
        val.postTranslate(0.0f, -this.mYChartMin);
        val.postScale(scaleX, -scaleY);
        this.mMatrixValueToPx.set(val);
        Matrix offset = new Matrix();
        offset.postTranslate((float)this.mOffsetLeft, (float)(this.getHeight() - this.mOffsetBottom));
        this.mMatrixOffset.set(offset);
    }

    protected void calcModulus() {
        float[] values = new float[9];
        this.mMatrixTouch.getValues(values);
        this.mXAxisLabelModulus = (int)Math.ceil((float)(this.mCurrentData.getXValCount() * this.mXLabelWidth) / ((float)this.mContentRect.width() * values[0]));
    }

    protected void calcFormats() {
        this.mValueFormatDigits = this.mValueDigitsToUse == -1 ? Utils.getFormatDigits(this.mDeltaY) : this.mValueDigitsToUse;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.mValueFormatDigits; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.mFormatValue = new DecimalFormat("###,###,###,##0" + b.toString());
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        float space = this.mDeltaY / 100.0f * 10.0f;
        this.mYChartMin = this.mStartAtZero ? 0.0f : (this.mYChartMin -= space);
        this.mYChartMax += space;
        this.mDeltaY = Math.abs(this.mYChartMax - this.mYChartMin);
    }

    public void prepareLegend() {
        String[] labels = new String[this.mCt.getColorCount()];
        int cnt = 0;
        for (int i = 0; i < this.mCt.getColors().size(); ++i) {
            for (int j = 0; j < this.mCt.getColors().get(i).size(); ++j) {
                if (i >= this.mOriginalData.getDataSetCount()) continue;
                labels[cnt] = this.mOriginalData.getDataSetByIndex(i).getLabel();
                ++cnt;
            }
        }
        Legend l = new Legend(this.mCt.getColorsAsArray(), labels);
        if (this.mLegend != null) {
            l.apply(this.mLegend);
        }
        this.mLegend = l;
    }

    protected void drawLegend() {
        if (!this.mDrawLegend || this.mLegend == null) {
            return;
        }
        String[] labels = this.mLegend.getLegendLabels();
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        float formSize = this.mLegend.getFormSize();
        float formToTextSpace = this.mLegend.getFormToTextSpace();
        float entrySpace = this.mLegend.getEntrySpace();
        float textSize = Utils.convertPixelsToDp(this.mLegendLabelPaint.getTextSize());
        float textDrop = (textSize + formSize) / 2.0f;
        switch (this.mLegend.getPosition()) {
            case BELOW_CHART: {
                float posX = this.mOffsetLeft;
                float posY = (float)(this.getHeight() - this.mOffsetBottom) + textSize * 2.0f;
                for (int i = 0; i < labels.length && labels[i] != null; ++i) {
                    this.mLegend.drawForm(this.mDrawCanvas, posX, posY, this.mLegendFormPaint, i);
                    this.mLegend.drawLabel(this.mDrawCanvas, posX += formToTextSpace, posY + textDrop, this.mLegendLabelPaint, i);
                    posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]) + entrySpace;
                }
                break;
            }
            case LEFT_OF_CHART: {
                float posX = (float)(this.getWidth() - this.mOffsetRight) + formSize;
                float posY = this.mOffsetTop;
                for (int i = 0; i < labels.length && labels[i] != null; ++i) {
                    this.mLegend.drawForm(this.mDrawCanvas, posX, posY, this.mLegendFormPaint, i);
                    this.mLegend.drawLabel(this.mDrawCanvas, posX + formToTextSpace, posY + textDrop, this.mLegendLabelPaint, i);
                    posY += entrySpace;
                }
                break;
            }
        }
    }

    protected void prepareXLabels() {
        StringBuffer a = new StringBuffer();
        int length = (int)((float)(this.mCurrentData.getXVals().get(0).length() + this.mCurrentData.getXVals().get(this.mCurrentData.getXValCount() - 1).length()));
        if (this.mCurrentData.getXVals().get(0).length() <= 3) {
            length *= 2;
        }
        for (int i = 0; i < length; ++i) {
            a.append("h");
        }
        this.mXLabelWidth = Utils.calcTextWidth(this.mXLabelPaint, a.toString());
    }

    private void prepareYLabels() {
        double f;
        double intervalMagnitude;
        PointD p1 = this.getValuesByTouchPoint(this.mContentRect.left, this.mContentRect.top);
        PointD p2 = this.getValuesByTouchPoint(this.mContentRect.left, this.mContentRect.bottom);
        this.mYChartMin = (float)p2.y;
        this.mYChartMax = (float)p1.y;
        float yMin = this.mYChartMin;
        float yMax = this.mYChartMax;
        double range = yMax - yMin;
        if (this.mYLabelCount == 0 || range <= 0.0) {
            this.mYLabels.mEntries = new float[0];
            this.mYLabels.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)this.mYLabelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        double first = Math.ceil((double)yMin / interval) * interval;
        double last = Math.nextUp(Math.floor((double)yMax / interval) * interval);
        int n = 0;
        for (f = first; f <= last; f += interval) {
            ++n;
        }
        this.mYLabels.mEntryCount = n;
        if (this.mYLabels.mEntries.length < n) {
            this.mYLabels.mEntries = new float[n];
        }
        f = first;
        for (int i = 0; i < n; ++i) {
            this.mYLabels.mEntries[i] = (float)f;
            f += interval;
        }
        this.mYLabels.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
    }

    protected void drawXLabels() {
        if (!this.mDrawXLabels) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        for (int i = 0; i < this.mCurrentData.getXValCount(); ++i) {
            if (i % this.mXAxisLabelModulus != 0) continue;
            position[0] = i;
            if (this.mCenterXAxisLabels) {
                position[0] = position[0] + 0.5f;
            }
            this.transformPointArray(position);
            if (!(position[0] >= (float)this.mOffsetLeft) || !(position[0] <= (float)(this.getWidth() - this.mOffsetRight + 10))) continue;
            this.mDrawCanvas.drawText(this.mCurrentData.getXVals().get(i), position[0], (float)(this.mOffsetTop - 5), this.mXLabelPaint);
        }
    }

    protected void drawYLabels() {
        if (!this.mDrawYLabels) {
            return;
        }
        float[] positions = new float[this.mYLabels.mEntryCount * 2];
        for (int i = 0; i < positions.length; i += 2) {
            positions[i + 1] = this.mYLabels.mEntries[i / 2];
        }
        this.transformPointArray(positions);
        float xPos = this.mOffsetLeft - 10;
        for (int i = 0; i < this.mYLabels.mEntryCount; ++i) {
            String text = Utils.formatNumber(this.mYLabels.mEntries[i], this.mYLabels.mDecimals, this.mSeparateTousands);
            if (!this.mDrawTopYLabelEntry && i >= this.mYLabels.mEntryCount - 1) {
                return;
            }
            if (this.mDrawUnitsInLabels) {
                this.mDrawCanvas.drawText(text + this.mUnit, xPos, positions[i * 2 + 1], this.mYLabelPaint);
                continue;
            }
            this.mDrawCanvas.drawText(text, xPos, positions[i * 2 + 1], this.mYLabelPaint);
        }
    }

    protected void drawBorder() {
        if (!this.mDrawBorder || this.mBorderStyles == null) {
            return;
        }
        block6: for (int i = 0; i < this.mBorderStyles.length; ++i) {
            switch (this.mBorderStyles[i]) {
                case LEFT: {
                    this.mDrawCanvas.drawLine((float)this.mOffsetLeft, (float)this.mOffsetTop, (float)this.mOffsetLeft, (float)(this.getHeight() - this.mOffsetBottom), this.mBorderPaint);
                    continue block6;
                }
                case RIGHT: {
                    this.mDrawCanvas.drawLine((float)(this.getWidth() - this.mOffsetRight), (float)this.mOffsetTop, (float)(this.getWidth() - this.mOffsetRight), (float)(this.getHeight() - this.mOffsetBottom), this.mBorderPaint);
                    continue block6;
                }
                case TOP: {
                    this.mDrawCanvas.drawLine((float)this.mOffsetLeft, (float)this.mOffsetTop, (float)(this.getWidth() - this.mOffsetRight), (float)this.mOffsetTop, this.mBorderPaint);
                    continue block6;
                }
                case BOTTOM: {
                    this.mDrawCanvas.drawLine((float)this.mOffsetLeft, (float)(this.getHeight() - this.mOffsetBottom), (float)(this.getWidth() - this.mOffsetRight), (float)(this.getHeight() - this.mOffsetBottom), this.mBorderPaint);
                }
            }
        }
    }

    protected void drawGridBackground() {
        if (!this.mDrawGridBackground) {
            return;
        }
        Rect gridBackground = new Rect(this.mOffsetLeft + 1, this.mOffsetTop + 1, this.getWidth() - this.mOffsetRight, this.getHeight() - this.mOffsetBottom);
        this.mDrawCanvas.drawRect(gridBackground, this.mGridBackgroundPaint);
    }

    protected void drawHorizontalGrid() {
        if (!this.mDrawHorizontalGrid) {
            return;
        }
        Path p = new Path();
        for (int i = 0; i < this.mYLabels.mEntryCount; ++i) {
            p.reset();
            p.moveTo(0.0f, this.mYLabels.mEntries[i]);
            p.lineTo(this.mDeltaX, this.mYLabels.mEntries[i]);
            this.transformPath(p);
            this.mDrawCanvas.drawPath(p, this.mGridPaint);
        }
    }

    protected void drawVerticalGrid() {
        if (!this.mDrawVerticalGrid) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        for (int i = 0; i < this.mCurrentData.getXValCount(); ++i) {
            if (i % this.mXAxisLabelModulus != 0) continue;
            position[0] = i;
            this.transformPointArray(position);
            if (!(position[0] >= (float)this.mOffsetLeft) || !(position[0] <= (float)this.getWidth())) continue;
            this.mDrawCanvas.drawLine(position[0], (float)this.mOffsetTop, position[0], (float)(this.getHeight() - this.mOffsetBottom), this.mGridPaint);
        }
    }

    protected boolean isOffContentRight(float p) {
        return p > (float)this.mContentRect.right;
    }

    protected boolean isOffContentLeft(float p) {
        return p < (float)this.mContentRect.left;
    }

    protected boolean isOffContentTop(float p) {
        return p < (float)this.mContentRect.top;
    }

    protected boolean isOffContentBottom(float p) {
        return p > (float)this.mContentRect.bottom;
    }

    public void disableScroll() {
        ViewParent parent = this.getParent();
        parent.requestDisallowInterceptTouchEvent(true);
    }

    public void enableScroll() {
        ViewParent parent = this.getParent();
        parent.requestDisallowInterceptTouchEvent(false);
    }

    public void zoomIn(float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(1.4f, 1.4f, x, y);
        this.refreshTouch(save);
    }

    public void zoomOut(float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(0.7f, 0.7f, x, y);
        this.refreshTouch(save);
    }

    public void zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(scaleX, scaleY, x, -y);
        this.refreshTouch(save);
    }

    public synchronized void centerViewPort(final int xIndex, final float yVal) {
        this.post(new Runnable(){

            @Override
            public void run() {
                float indicesInView = BarLineChartBase.this.mDeltaX / BarLineChartBase.this.mScaleX;
                float valsInView = BarLineChartBase.this.mDeltaY / BarLineChartBase.this.mScaleY;
                float[] pts = new float[]{(float)xIndex - indicesInView / 2.0f, yVal + valsInView / 2.0f};
                Matrix save = new Matrix();
                save.set(BarLineChartBase.this.mMatrixTouch);
                BarLineChartBase.this.transformPointArray(pts);
                float x = -pts[0] + (float)BarLineChartBase.this.getOffsetLeft();
                float y = -pts[1] + (float)BarLineChartBase.this.getOffsetBottom();
                save.postTranslate(x, y);
                BarLineChartBase.this.refreshTouchNoInvalidate(save);
            }
        });
    }

    public Matrix refreshTouch(Matrix newTouchMatrix) {
        this.mMatrixTouch.set(newTouchMatrix);
        this.limitTransAndScale(this.mMatrixTouch);
        this.invalidate();
        newTouchMatrix.set(this.mMatrixTouch);
        return newTouchMatrix;
    }

    public Matrix refreshTouchNoInvalidate(Matrix newTouchMatrix) {
        this.mMatrixTouch.set(newTouchMatrix);
        this.limitTransAndScale(this.mMatrixTouch);
        newTouchMatrix.set(this.mMatrixTouch);
        return newTouchMatrix;
    }

    protected void limitTransAndScale(Matrix matrix) {
        float[] vals = new float[9];
        matrix.getValues(vals);
        float curTransX = vals[2];
        float curScaleX = vals[0];
        float curTransY = vals[5];
        float curScaleY = vals[4];
        this.mScaleX = Math.max(this.mMinScaleX, Math.min(this.getMaxScaleX(), curScaleX));
        this.mScaleY = Math.max(this.mMinScaleY, Math.min(this.getMaxScaleY(), curScaleY));
        if (this.mContentRect == null) {
            return;
        }
        float maxTransX = -((float)this.mContentRect.width()) * (this.mScaleX - 1.0f);
        float newTransX = Math.min(Math.max(curTransX, maxTransX), 0.0f);
        float maxTransY = (float)this.mContentRect.height() * (this.mScaleY - 1.0f);
        float newTransY = Math.max(Math.min(curTransY, maxTransY), 0.0f);
        vals[2] = newTransX;
        vals[0] = this.mScaleX;
        vals[5] = newTransY;
        vals[4] = this.mScaleY;
        matrix.setValues(vals);
    }

    public void setOnDrawListener(OnDrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public void setDrawingEnabled(boolean drawingEnabled) {
        if (this.mListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mListener).setDrawingEnabled(drawingEnabled);
        }
    }

    public void setAutoFinish(boolean enabled) {
        this.mAutoFinishDrawing = enabled;
    }

    public boolean isAutoFinishEnabled() {
        return this.mAutoFinishDrawing;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public void setScaleMinima(float scaleXmin, float scaleYmin) {
        this.mMinScaleX = scaleXmin;
        this.mMinScaleY = scaleYmin;
        this.zoom(this.mMinScaleX, this.mMinScaleY, 0.0f, 0.0f);
    }

    public void setDrawTopYLabelEntry(boolean enabled) {
        this.mDrawTopYLabelEntry = enabled;
    }

    public void setYRange(float minY, float maxY, boolean invalidate) {
        if (Float.isNaN(minY) || Float.isNaN(maxY)) {
            this.resetYRange(invalidate);
            return;
        }
        this.mFixedYValues = true;
        this.mYChartMin = minY;
        this.mYChartMax = maxY;
        if (minY < 0.0f) {
            this.mStartAtZero = false;
        }
        this.mDeltaY = this.mYChartMax - this.mYChartMin;
        this.calcFormats();
        this.prepareMatrix();
        if (invalidate) {
            this.invalidate();
        }
    }

    public void resetYRange(boolean invalidate) {
        this.mFixedYValues = false;
        this.calcMinMax(this.mFixedYValues);
        this.prepareMatrix();
        if (invalidate) {
            this.invalidate();
        }
    }

    public void setYLabelCount(int yCount) {
        if (yCount > 15) {
            yCount = 15;
        }
        if (yCount < 3) {
            yCount = 3;
        }
        this.mYLabelCount = yCount;
    }

    public void setAdjustXLabels(boolean enabled) {
        this.mAdjustXAxisLabels = enabled;
    }

    public boolean isAdjustXLabelsEnabled() {
        return this.mAdjustXAxisLabels;
    }

    public boolean hasFixedYValues() {
        return this.mFixedYValues;
    }

    public void setGridColor(int color2) {
        this.mGridPaint.setColor(color2);
    }

    public void setMaxVisibleValueCount(int count) {
        this.mMaxVisibleCount = count;
    }

    public void setYLabelTextSize(float size) {
        if (size > 14.0f) {
            size = 14.0f;
        }
        if (size < 7.0f) {
            size = 7.0f;
        }
        this.mYLabelPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setXLabelTextSize(float size) {
        if (size > 14.0f) {
            size = 14.0f;
        }
        if (size < 7.0f) {
            size = 7.0f;
        }
        this.mXLabelPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setHighlightIndicatorEnabled(boolean enabled) {
        this.mHighLightIndicatorEnabled = enabled;
    }

    public void setStartAtZero(boolean enabled) {
        this.mStartAtZero = enabled;
        this.prepare();
        this.prepareMatrix();
    }

    public void setUnit(String unit) {
        this.mUnit = unit;
    }

    public boolean isStartAtZeroEnabled() {
        return this.mStartAtZero;
    }

    public void setDrawUnitsInChart(boolean enabled) {
        this.mDrawUnitInChart = enabled;
    }

    public void setDrawUnitsInYLabel(boolean enabled) {
        this.mDrawUnitsInLabels = enabled;
    }

    public void setCenterXLabelText(boolean enabled) {
        this.mCenterXAxisLabels = enabled;
    }

    public boolean isXLabelTextCentered() {
        return this.mCenterXAxisLabels;
    }

    public void setDrawLegend(boolean enabled) {
        this.mDrawLegend = enabled;
    }

    public boolean isDrawLegendEnabled() {
        return this.mDrawLegend;
    }

    public Legend getLegend() {
        return this.mLegend;
    }

    public void setGridWidth(float width) {
        if (width < 0.1f) {
            width = 0.1f;
        }
        if (width > 3.0f) {
            width = 3.0f;
        }
        this.mGridWidth = width;
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setDrawVerticalGrid(boolean enabled) {
        this.mDrawVerticalGrid = enabled;
    }

    public void setDrawHorizontalGrid(boolean enabled) {
        this.mDrawHorizontalGrid = enabled;
    }

    public boolean isDrawVerticalGridEnabled() {
        return this.mDrawVerticalGrid;
    }

    public boolean isDrawHorizontalGridEnabled() {
        return this.mDrawHorizontalGrid;
    }

    public void setDrawBorder(boolean enabled) {
        this.mDrawBorder = enabled;
    }

    public void setDrawGridBackground(boolean enabled) {
        this.mDrawGridBackground = enabled;
    }

    public void setDrawXLabels(boolean enabled) {
        this.mDrawXLabels = enabled;
    }

    public void setDrawYLabels(boolean enabled) {
        this.mDrawYLabels = enabled;
    }

    public void setBorderStyles(BorderStyle[] styles) {
        this.mBorderStyles = styles;
    }

    public Highlight getHighlightByTouchPoint(float x, float y) {
        ArrayList<SelInfo> valsAtIndex;
        float[] pts = new float[]{x, y};
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixTouch.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        double base = Math.floor(xTouchVal);
        Log.i((String)"MPChart", (String)("touchindex x: " + xTouchVal + ", touchindex y: " + yTouchVal));
        if ((this instanceof LineChart || this instanceof ScatterChart) && (xTouchVal < 0.0 || xTouchVal > (double)this.mDeltaX)) {
            return null;
        }
        if (this instanceof BarChart && (xTouchVal < 0.0 || xTouchVal > (double)(this.mDeltaX + 1.0f))) {
            return null;
        }
        int xIndex = (int)base;
        int dataSetIndex = 0;
        if ((this instanceof LineChart || this instanceof ScatterChart) && xTouchVal - base > 0.5) {
            xIndex = (int)base + 1;
        }
        if ((dataSetIndex = this.getClosestDataSetIndex(valsAtIndex = this.getYValsAtIndex(xIndex), (float)yTouchVal)) == -1) {
            return null;
        }
        return new Highlight(xIndex, dataSetIndex);
    }

    private int getClosestDataSetIndex(ArrayList<SelInfo> valsAtIndex, float val) {
        int index = -1;
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < valsAtIndex.size(); ++i) {
            float cdistance = Math.abs(valsAtIndex.get((int)i).val - val);
            if (!(cdistance < distance)) continue;
            index = valsAtIndex.get((int)i).dataSetIndex;
            distance = cdistance;
        }
        Log.i((String)"MPChart", (String)("Closest DataSet index: " + index));
        return index;
    }

    public PointD getValuesByTouchPoint(float x, float y) {
        float[] pts = new float[]{x, y};
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixTouch.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        return new PointD(xTouchVal, yTouchVal);
    }

    public PointD getPixelsForValues(float x, float y) {
        float[] pts = new float[]{x, y};
        this.transformPointArray(pts);
        return new PointD(pts[0], pts[1]);
    }

    public float getYValueByTouchPoint(float x, float y) {
        return (float)this.getValuesByTouchPoint((float)x, (float)y).y;
    }

    public Entry getEntryByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return this.mCurrentData.getEntryForHighlight(h);
        }
        return null;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public float getMaxScaleX() {
        return this.mDeltaX / 2.0f;
    }

    public float getMaxScaleY() {
        return this.mMaxScaleY;
    }

    public void setMaxScaleY(float factor) {
        if (factor < 1.0f) {
            factor = 1.0f;
        }
        if (factor > 20.0f) {
            factor = 20.0f;
        }
        this.mMaxScaleY = factor;
    }

    public void setXLabelTypeface(Typeface t) {
        this.mXLabelPaint.setTypeface(t);
    }

    public void setYLabelTypeface(Typeface t) {
        this.mYLabelPaint.setTypeface(t);
    }

    public void setLabelTypeface(Typeface t) {
        this.setXLabelTypeface(t);
        this.setYLabelTypeface(t);
    }

    public void enableFiltering(Approximator a) {
        this.mFilterData = true;
        this.mApproximator = a;
    }

    public void disableFiltering() {
        this.mFilterData = false;
    }

    public boolean isFilteringEnabled() {
        return this.mFilterData;
    }

    public void setPinchZoom(boolean enabled) {
        this.mPinchZoomEnabled = enabled;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    private ChartData getFilteredData() {
        float deltaRatio = this.mDeltaY / this.mDeltaX;
        float scaleRatio = this.mScaleY / this.mScaleX;
        this.mApproximator.setRatios(deltaRatio, scaleRatio);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (int j = 0; j < this.mOriginalData.getDataSetCount(); ++j) {
            DataSet old = this.mOriginalData.getDataSetByIndex(j);
            ArrayList<Entry> approximated = this.mApproximator.filter(old.getYVals());
            DataSet set = new DataSet(approximated, old.getLabel());
            dataSets.add(set);
        }
        ChartData d = new ChartData(this.mOriginalData.getXVals(), dataSets);
        return d;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 3: {
                this.mGridPaint = p;
                break;
            }
            case 4: {
                this.mGridBackgroundPaint = p;
                break;
            }
            case 12: {
                this.mBorderPaint = p;
                break;
            }
            case 6: {
                this.mXLabelPaint = p;
                break;
            }
            case 5: {
                this.mYLabelPaint = p;
                break;
            }
            case 18: {
                this.mLegendLabelPaint = p;
            }
        }
    }

    public static enum BorderStyle {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

