/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BubbleChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    protected BubbleDataProvider mChart;
    private float[] sizeBuffer = new float[4];
    private float[] pointBuffer = new float[2];
    private float[] _hsvBuffer = new float[3];

    public BubbleChartRenderer(BubbleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        for (IBubbleDataSet set : bubbleData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected float getShapeSize(float entrySize, float maxSize, float reference, boolean normalizeSize) {
        float factor = normalizeSize ? (maxSize == 0.0f ? 1.0f : (float)Math.sqrt(entrySize / maxSize)) : entrySize;
        float shapeSize = reference * factor;
        return shapeSize;
    }

    protected void drawDataSet(Canvas c, IBubbleDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.mAnimator.getPhaseY();
        this.mXBounds.set(this.mChart, dataSet);
        this.sizeBuffer[0] = 0.0f;
        this.sizeBuffer[2] = 1.0f;
        trans.pointValuesToPixel(this.sizeBuffer);
        boolean normalizeSize = dataSet.isNormalizeSizeEnabled();
        float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
        float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
        float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
        for (int j = this.mXBounds.min; j <= this.mXBounds.range + this.mXBounds.min; ++j) {
            BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j);
            this.pointBuffer[0] = entry.getX();
            this.pointBuffer[1] = entry.getY() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            int color = dataSet.getColor((int)entry.getX());
            this.mRenderPaint.setColor(color);
            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = bubbleData.getDataSets();
            float lineHeight = Utils.calcTextHeight(this.mValuePaint, "1");
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                IBubbleDataSet dataSet = (IBubbleDataSet)dataSets.get(i);
                if (!this.shouldDrawValues(dataSet)) continue;
                this.applyValueTextStyle(dataSet);
                float phaseX = Math.max(0.0f, Math.min(1.0f, this.mAnimator.getPhaseX()));
                float phaseY = this.mAnimator.getPhaseY();
                this.mXBounds.set(this.mChart, dataSet);
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesBubble(dataSet, phaseY, this.mXBounds.min, this.mXBounds.max);
                float alpha = phaseX == 1.0f ? phaseY : phaseX;
                for (int j = 0; j < positions.length; j += 2) {
                    int valueTextColor = dataSet.getValueTextColor(j / 2 + this.mXBounds.min);
                    valueTextColor = Color.argb((int)Math.round(255.0f * alpha), (int)Color.red((int)valueTextColor), (int)Color.green((int)valueTextColor), (int)Color.blue((int)valueTextColor));
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j / 2 + this.mXBounds.min);
                    this.drawValue(c, dataSet.getValueFormatter(), entry.getSize(), entry, i, x, y + 0.5f * lineHeight, valueTextColor);
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        float phaseY = this.mAnimator.getPhaseY();
        for (Highlight high : indices) {
            BubbleEntry entry;
            IBubbleDataSet set = (IBubbleDataSet)bubbleData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || (entry = (BubbleEntry)set.getEntryForXValue(high.getX(), high.getY())).getY() != high.getY() || !this.isInBoundsX(entry, set)) continue;
            Transformer trans = this.mChart.getTransformer(set.getAxisDependency());
            this.sizeBuffer[0] = 0.0f;
            this.sizeBuffer[2] = 1.0f;
            trans.pointValuesToPixel(this.sizeBuffer);
            boolean normalizeSize = set.isNormalizeSizeEnabled();
            float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
            float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
            float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
            this.pointBuffer[0] = entry.getX();
            this.pointBuffer[1] = entry.getY() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            high.setDraw(this.pointBuffer[0], this.pointBuffer[1]);
            float shapeHalf = this.getShapeSize(entry.getSize(), set.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            int originalColor = set.getColor((int)entry.getX());
            Color.RGBToHSV((int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor), (float[])this._hsvBuffer);
            this._hsvBuffer[2] = this._hsvBuffer[2] * 0.5f;
            int color = Color.HSVToColor((int)Color.alpha((int)originalColor), (float[])this._hsvBuffer);
            this.mHighlightPaint.setColor(color);
            this.mHighlightPaint.setStrokeWidth(set.getHighlightCircleWidth());
            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mHighlightPaint);
        }
    }
}

