/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.IHighlighter;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.MPPointD;
import java.util.ArrayList;
import java.util.List;

public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider>
implements IHighlighter {
    protected T mChart;
    protected List<Highlight> mHighlightBuffer = new ArrayList<Highlight>();

    public ChartHighlighter(T chart) {
        this.mChart = chart;
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        MPPointD pos = this.getValsForTouch(x, y);
        float xVal = (float)pos.x;
        MPPointD.recycleInstance(pos);
        Highlight high = this.getHighlightForX(xVal, x, y);
        return high;
    }

    protected MPPointD getValsForTouch(float x, float y) {
        MPPointD pos = this.mChart.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(x, y);
        return pos;
    }

    protected Highlight getHighlightForX(float xVal, float x, float y) {
        float rightAxisMinDist;
        List<Highlight> closestValues = this.getHighlightsAtXValue(xVal, x, y);
        if (closestValues.isEmpty()) {
            return null;
        }
        float leftAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axis = leftAxisMinDist < (rightAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        Highlight detail = this.getClosestHighlightByPixel(closestValues, x, y, axis, this.mChart.getMaxHighlightDistance());
        return detail;
    }

    protected float getMinimumDistance(List<Highlight> closestValues, float pos, YAxis.AxisDependency axis) {
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < closestValues.size(); ++i) {
            float tempDistance;
            Highlight high = closestValues.get(i);
            if (high.getAxis() != axis || !((tempDistance = Math.abs(this.getHighlightPos(high) - pos)) < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    protected float getHighlightPos(Highlight h) {
        return h.getYPx();
    }

    protected List<Highlight> getHighlightsAtXValue(float xVal, float x, float y) {
        this.mHighlightBuffer.clear();
        BarLineScatterCandleBubbleData data = this.getData();
        if (data == null) {
            return this.mHighlightBuffer;
        }
        int dataSetCount = data.getDataSetCount();
        for (int i = 0; i < dataSetCount; ++i) {
            Object dataSet = data.getDataSetByIndex(i);
            if (!dataSet.isHighlightEnabled()) continue;
            this.mHighlightBuffer.addAll(this.buildHighlights((IDataSet)dataSet, i, xVal, DataSet.Rounding.CLOSEST));
        }
        return this.mHighlightBuffer;
    }

    protected List<Highlight> buildHighlights(IDataSet set, int dataSetIndex, float xVal, DataSet.Rounding rounding) {
        Object closest;
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        List entries = set.getEntriesForXValue(xVal);
        if (entries.size() == 0 && (closest = set.getEntryForXValue(xVal, Float.NaN, rounding)) != null) {
            entries = set.getEntriesForXValue(((Entry)closest).getX());
        }
        if (entries.size() == 0) {
            return highlights;
        }
        for (Entry e : entries) {
            MPPointD pixels = this.mChart.getTransformer(set.getAxisDependency()).getPixelForValues(e.getX(), e.getY());
            highlights.add(new Highlight(e.getX(), e.getY(), (float)pixels.x, (float)pixels.y, dataSetIndex, set.getAxisDependency()));
        }
        return highlights;
    }

    public Highlight getClosestHighlightByPixel(List<Highlight> closestValues, float x, float y, YAxis.AxisDependency axis, float minSelectionDistance) {
        Highlight closest = null;
        float distance = minSelectionDistance;
        for (int i = 0; i < closestValues.size(); ++i) {
            float cDistance;
            Highlight high = closestValues.get(i);
            if (axis != null && high.getAxis() != axis || !((cDistance = this.getDistance(x, y, high.getXPx(), high.getYPx())) < distance)) continue;
            closest = high;
            distance = cDistance;
        }
        return closest;
    }

    protected float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    protected BarLineScatterCandleBubbleData getData() {
        return this.mChart.getData();
    }
}

